/*
 * Decompiled with CFR 0.152.
 */
package com.skynex.mylands;

import com.skynex.mylands.commands.LandCommand;
import com.skynex.mylands.gui.GuiManager;
import com.skynex.mylands.integration.MyLandProvider;
import com.skynex.mylands.libs.bstats.bukkit.Metrics;
import com.skynex.mylands.listeners.ChatListener;
import com.skynex.mylands.listeners.LandListener;
import com.skynex.mylands.manager.LandManager;
import com.skynex.mylands.util.PluginLogger;
import fr.skynex.mycore.api.MyCoreAPI;
import fr.skynex.mycore.api.lands.LandProvider;
import fr.skynex.mycore.api.provider.Provider;
import java.util.concurrent.CompletableFuture;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class LandsPlugin
extends JavaPlugin {
    private LandManager landManager;
    private GuiManager guiManager;

    public void onEnable() {
        long startTime = System.currentTimeMillis();
        try {
            new Metrics((Plugin)this, 28894);
            this.landManager = new LandManager((Plugin)this);
            this.guiManager = new GuiManager();
            this.landManager.setGuiManager(this.guiManager);
            ((CompletableFuture)this.landManager.initialize().thenRun(() -> {
                LandCommand landCommand = new LandCommand(this.landManager);
                this.getCommand("mylands").setExecutor((CommandExecutor)landCommand);
                this.getCommand("mylands").setTabCompleter((TabCompleter)landCommand);
                this.getServer().getPluginManager().registerEvents((Listener)new LandListener(this.landManager), (Plugin)this);
                this.getServer().getPluginManager().registerEvents((Listener)new ChatListener(this.landManager), (Plugin)this);
                this.getServer().getPluginManager().registerEvents((Listener)this.guiManager, (Plugin)this);
                this.registerWithMyCore();
                long duration = System.currentTimeMillis() - startTime;
                PluginLogger.info("MyLands v{} enabled! ({}ms)", this.getDescription().getVersion(), duration);
            })).exceptionally(ex -> {
                PluginLogger.error("Failed to initialize MyLands", ex);
                this.getServer().getPluginManager().disablePlugin((Plugin)this);
                return null;
            });
        }
        catch (Exception e) {
            PluginLogger.error("Critical error during plugin initialization", e);
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
    }

    public void onDisable() {
        this.unregisterFromMyCore();
        if (this.landManager != null) {
            this.landManager.shutdown().join();
        }
        PluginLogger.info("MyLands disabled.", new Object[0]);
    }

    private void registerWithMyCore() {
        if (this.getServer().getPluginManager().getPlugin("MyCore") != null) {
            try {
                MyCoreAPI.register(LandProvider.class, (Provider)new MyLandProvider(this, this.landManager), (JavaPlugin)this);
            }
            catch (Exception e) {
                PluginLogger.error("Failed to register with MyCore", e);
            }
        }
    }

    private void unregisterFromMyCore() {
        if (this.getServer().getPluginManager().getPlugin("MyCore") != null) {
            try {
                MyCoreAPI.unregisterAll((JavaPlugin)this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

