/*
 * Decompiled with CFR 0.152.
 */
package com.skynex.mylands.commands;

import com.skynex.mylands.commands.GradeSubCommand;
import com.skynex.mylands.config.Messages;
import com.skynex.mylands.gui.ConfigurableQuestsGui;
import com.skynex.mylands.manager.LandManager;
import com.skynex.mylands.model.Land;
import com.skynex.mylands.model.LandLevel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LandCommand
implements CommandExecutor,
TabCompleter {
    private final LandManager landManager;
    private final Messages messages;
    private final GradeSubCommand gradeSubCommand;

    public LandCommand(@NotNull LandManager landManager) {
        this.landManager = landManager;
        this.messages = landManager.getMessages();
        this.gradeSubCommand = new GradeSubCommand(landManager, landManager.getGradeService());
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        String subCommand;
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.messages.noPermission());
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            this.sendHelpMessage(player);
            return true;
        }
        return switch (subCommand = args[0].toLowerCase()) {
            case "create" -> this.handleCreate(player, args);
            case "delete" -> this.handleDelete(player);
            case "level" -> this.handleLevel(player);
            case "upgrade" -> this.handleUpgrade(player);
            case "zone" -> this.handleZone(player, args);
            case "sethome" -> this.handleSetHome(player);
            case "home" -> this.handleHome(player);
            case "visit" -> this.handleVisit(player, args);
            case "invite" -> this.handleInvite(player, args);
            case "remove" -> this.handleRemove(player, args);
            case "join" -> this.handleJoin(player);
            case "quit" -> this.handleQuit(player);
            case "menu", "gui" -> this.handleMenu(player);
            case "grade", "grades", "rank", "ranks" -> this.gradeSubCommand.handle(player, args);
            case "help" -> {
                this.sendHelpMessage(player);
                yield true;
            }
            case "quest", "quests" -> this.handleQuests(player, args);
            case "admin" -> this.handleAdmin(player, args);
            case "reload" -> this.handleReload(player);
            default -> {
                this.sendHelpMessage(player);
                yield true;
            }
        };
    }

    private boolean handleAdmin(Player player, String[] args) {
        String adminCommand;
        if (!player.hasPermission("mylands.admin.reload")) {
            player.sendMessage(this.messages.noPermission());
            return true;
        }
        if (args.length < 2) {
            player.sendMessage(this.messages.adminUsage());
            return true;
        }
        return switch (adminCommand = args[1].toLowerCase()) {
            case "reload" -> this.handleReload(player);
            case "quests" -> this.handleQuests(player, args);
            default -> {
                player.sendMessage(this.messages.adminUnknownCommand());
                yield true;
            }
        };
    }

    private boolean handleCreate(Player player, String[] args) {
        if (!player.hasPermission("mylands.create")) {
            player.sendMessage(this.messages.noPermission());
            return true;
        }
        if (args.length < 2) {
            this.landManager.addAwaitingLandName(player.getUniqueId());
            player.sendMessage(this.messages.get("awaiting_name"));
            return true;
        }
        String landName = String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length));
        ((CompletableFuture)this.landManager.createLand(player, landName).thenAccept(land -> player.sendMessage(this.messages.farmCreated(landName)))).exceptionally(ex -> {
            Throwable cause = ex.getCause() != null ? ex.getCause() : ex;
            String errorMsg = cause.getMessage();
            if (cause instanceof IllegalArgumentException) {
                player.sendMessage(this.messages.invalidFarmName());
            } else if (errorMsg != null && errorMsg.contains("overlaps")) {
                player.sendMessage(this.messages.farmOverlaps());
            } else if (errorMsg != null && errorMsg.contains("Insufficient")) {
                player.sendMessage(this.messages.get("insufficient_funds_for_creation", Map.of("cost", String.valueOf(this.landManager.getConfigManager().getCreationCost()))));
            } else if (errorMsg != null && errorMsg.contains("already has")) {
                player.sendMessage(this.messages.alreadyHasFarm());
            } else {
                player.sendMessage(this.messages.get("error_creating_farm", Map.of("error", errorMsg != null ? errorMsg : "Unknown error")));
            }
            return null;
        });
        return true;
    }

    private boolean handleDelete(Player player) {
        if (!player.hasPermission("mylands.delete")) {
            player.sendMessage(this.messages.noPermission());
            return true;
        }
        ((CompletableFuture)this.landManager.deleteLand(player).thenAccept(success -> {
            if (!success.booleanValue()) {
                player.sendMessage(this.messages.noFarm());
            }
        })).exceptionally(ex -> {
            player.sendMessage(this.messages.errorDeletingFarm(ex.getMessage() != null ? ex.getMessage() : "Unknown error"));
            return null;
        });
        return true;
    }

    private boolean handleLevel(Player player) {
        this.landManager.getLand(player.getUniqueId()).thenAccept(landOpt -> {
            if (landOpt.isEmpty()) {
                player.sendMessage(this.messages.noFarm());
                return;
            }
            Land land = (Land)landOpt.get();
            int nextLevel = land.level() + 1;
            Optional<LandLevel> nextLevelConfig = this.landManager.getConfigManager().getLandLevel(nextLevel);
            String nextCost = nextLevelConfig.map(lvl -> String.valueOf(lvl.upgradeCost())).orElse("Max Level");
            String jobReqs = nextLevelConfig.map(lvl -> lvl.getRequirementsString()).orElse("None");
            player.sendMessage(this.messages.get("farm_level", Map.of("level", String.valueOf(land.level()), "increase", String.valueOf(this.landManager.getConfigManager().getSizeIncreasePerLevel() * (land.level() - 1)), "next_cost", nextCost, "job_requirements", jobReqs)));
        });
        return true;
    }

    private boolean handleUpgrade(Player player) {
        if (!player.hasPermission("mylands.upgrade")) {
            player.sendMessage(this.messages.noPermission());
            return true;
        }
        this.landManager.getLand(player.getUniqueId()).thenAccept(landOptBefore -> {
            if (landOptBefore.isEmpty()) {
                player.sendMessage(this.messages.noFarm());
                return;
            }
            Land landBefore = (Land)landOptBefore.get();
            double oldSize = this.landManager.getConfigManager().calculateLandSize(landBefore.level());
            ((CompletableFuture)this.landManager.upgradeLand(player).thenAccept(land -> {
                double newSize = this.landManager.getConfigManager().calculateLandSize(land.level());
                player.sendMessage(this.messages.upgradeSuccessDetailed(land.level(), (int)oldSize, (int)newSize, (int)(newSize - oldSize)));
            })).exceptionally(ex -> {
                String msg;
                String string = msg = ex.getCause() != null ? ex.getCause().getMessage() : ex.getMessage();
                if (msg != null && msg.contains("overlap")) {
                    player.sendMessage(this.messages.upgradeWouldOverlap());
                } else if (msg != null && msg.contains("Max level")) {
                    player.sendMessage(this.messages.maxLevelReached());
                } else if (msg != null && msg.contains("Insufficient")) {
                    int nextLevel = landBefore.level() + 1;
                    Optional<LandLevel> nextLevelConfig = this.landManager.getConfigManager().getLandLevel(nextLevel);
                    String upgradeCost = nextLevelConfig.map(lvl -> String.valueOf(lvl.upgradeCost())).orElse("Unknown");
                    player.sendMessage(this.messages.get("insufficient_coins", Map.of("cost", upgradeCost)));
                } else if (msg == null || !msg.contains("Job requirements")) {
                    player.sendMessage(this.messages.noFarm());
                }
                return null;
            });
        });
        return true;
    }

    private boolean handleZone(Player player, String[] args) {
        String type;
        String string = type = args.length >= 2 ? args[1].toLowerCase() : "particles";
        if (!type.equals("particles") && !type.equals("blocks")) {
            player.sendMessage(this.messages.get("usage_zone"));
            return true;
        }
        this.landManager.showZone(player, type);
        return true;
    }

    private boolean handleSetHome(Player player) {
        ((CompletableFuture)this.landManager.setHome(player, player.getLocation()).thenAccept(land -> player.sendMessage(this.messages.homeSet()))).exceptionally(ex -> {
            if (ex.getMessage() != null && ex.getMessage().contains("within")) {
                player.sendMessage(this.messages.notInFarm());
            } else {
                player.sendMessage(this.messages.noFarm());
            }
            return null;
        });
        return true;
    }

    private boolean handleHome(Player player) {
        this.landManager.teleportHome(player).thenAccept(success -> {
            if (success.booleanValue()) {
                player.sendMessage(this.messages.teleportedHome());
            } else {
                player.sendMessage(this.messages.noHomeSet());
            }
        });
        return true;
    }

    private boolean handleVisit(Player player, String[] args) {
        if (args.length < 2) {
            player.sendMessage(this.messages.get("usage_visit"));
            return true;
        }
        String target = args[1];
        if (target.equalsIgnoreCase("open") || target.equalsIgnoreCase("close")) {
            boolean open = target.equalsIgnoreCase("open");
            this.landManager.setVisitsOpen(player.getUniqueId(), open).thenAccept(land -> player.sendMessage(open ? this.messages.visitOpened() : this.messages.visitClosed()));
            return true;
        }
        Player targetPlayer = Bukkit.getPlayer((String)target);
        if (targetPlayer == null) {
            player.sendMessage(this.messages.playerNotFound());
            return true;
        }
        this.landManager.visitLand(player, targetPlayer.getUniqueId()).thenAccept(success -> {
            if (success.booleanValue()) {
                player.sendMessage(this.messages.teleportedToFarm(targetPlayer.getName()));
            } else {
                player.sendMessage(this.messages.visitsClosed(targetPlayer.getName()));
            }
        });
        return true;
    }

    private boolean handleInvite(Player player, String[] args) {
        if (args.length < 2) {
            player.sendMessage(this.messages.get("usage_invite"));
            return true;
        }
        Player target = Bukkit.getPlayer((String)args[1]);
        if (target == null) {
            player.sendMessage(this.messages.playerNotFound());
            return true;
        }
        try {
            if (this.landManager.inviteCoOwner(player.getUniqueId(), target.getUniqueId())) {
                player.sendMessage(this.messages.inviteSent(target.getName()));
                target.sendMessage(this.messages.inviteReceived(player.getName()));
            }
        }
        catch (IllegalStateException ex) {
            player.sendMessage(ex.getMessage());
        }
        return true;
    }

    private boolean handleRemove(Player player, String[] args) {
        if (args.length < 2) {
            player.sendMessage(this.messages.get("usage_remove"));
            return true;
        }
        Player target = Bukkit.getPlayer((String)args[1]);
        if (target == null) {
            player.sendMessage(this.messages.playerNotFound());
            return true;
        }
        ((CompletableFuture)this.landManager.removeCoOwner(player.getUniqueId(), target.getUniqueId()).thenAccept(land -> {
            player.sendMessage(this.messages.removeSuccess(target.getName()));
            target.sendMessage(this.messages.removedFromFarm(player.getName()));
        })).exceptionally(ex -> {
            player.sendMessage(ex.getMessage());
            return null;
        });
        return true;
    }

    private boolean handleJoin(Player player) {
        if (!this.landManager.hasPendingInvitation(player.getUniqueId())) {
            player.sendMessage(this.messages.noPendingInvitation());
            return true;
        }
        ((CompletableFuture)this.landManager.acceptInvitation(player.getUniqueId()).thenAccept(land -> player.sendMessage(this.messages.joinSuccess("owner")))).exceptionally(ex -> {
            player.sendMessage(ex.getMessage());
            return null;
        });
        return true;
    }

    private boolean handleQuit(Player player) {
        ((CompletableFuture)this.landManager.quitLand(player.getUniqueId()).thenAccept(v -> player.sendMessage(this.messages.quitSuccess("owner")))).exceptionally(ex -> {
            if (ex.getMessage() != null && ex.getMessage().contains("owner")) {
                player.sendMessage(this.messages.ownerCannotQuit());
            } else {
                player.sendMessage(this.messages.noFarm());
            }
            return null;
        });
        return true;
    }

    private boolean handleReload(Player player) {
        if (!player.hasPermission("mylands.admin.reload")) {
            player.sendMessage(this.messages.noPermission());
            return true;
        }
        this.landManager.reload();
        player.sendMessage(this.messages.reloadSuccess());
        return true;
    }

    private boolean handleMenu(Player player) {
        if (!player.hasPermission("mylands.menu")) {
            player.sendMessage(this.messages.noPermission());
            return true;
        }
        ((CompletableFuture)this.landManager.getLand(player.getUniqueId()).thenAccept(landOpt -> {
            if (landOpt.isEmpty()) {
                player.sendMessage(this.messages.noFarm());
                return;
            }
            this.landManager.openLandMenu(player, (Land)landOpt.get());
        })).exceptionally(ex -> {
            player.sendMessage(this.messages.dbError());
            return null;
        });
        return true;
    }

    private boolean handleQuests(Player player, String[] args) {
        if (!player.hasPermission("mylands.quests")) {
            player.sendMessage(this.messages.noPermission());
            return true;
        }
        ((CompletableFuture)this.landManager.getLand(player.getUniqueId()).thenAccept(landOpt -> {
            if (landOpt.isEmpty()) {
                player.sendMessage(this.messages.noFarm());
                return;
            }
            ConfigurableQuestsGui questsGui = new ConfigurableQuestsGui(this.landManager.getConfigManager().getGuiConfig(), this.landManager.getQuestService());
            player.openInventory(questsGui.createInventory());
        })).exceptionally(ex -> {
            player.sendMessage(this.messages.dbError());
            return null;
        });
        return true;
    }

    private void sendHelpMessage(Player player) {
        player.sendMessage(this.messages.get("help_title"));
        player.sendMessage(this.messages.get("help_menu"));
        player.sendMessage(this.messages.get("help_create"));
        player.sendMessage(this.messages.get("help_level"));
        player.sendMessage(this.messages.get("help_upgrade"));
        player.sendMessage(this.messages.get("help_delete"));
        player.sendMessage(this.messages.get("help_zone"));
        player.sendMessage(this.messages.get("help_sethome"));
        player.sendMessage(this.messages.get("help_home"));
        player.sendMessage(this.messages.get("help_visit"));
        player.sendMessage(this.messages.get("help_invite"));
        player.sendMessage(this.messages.get("help_remove"));
        player.sendMessage(this.messages.get("help_join"));
        player.sendMessage(this.messages.get("help_quit"));
        player.sendMessage("\u00a7e/lands grade menu\u00a77 - Manage land grades and permissions.");
        if (player.hasPermission("mylands.admin.reload")) {
            player.sendMessage(this.messages.get("help_admin_reload"));
        }
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (args.length == 1) {
            ArrayList<String> completions = new ArrayList<String>(Arrays.asList("menu", "gui", "grade", "create", "delete", "level", "upgrade", "zone", "sethome", "home", "visit", "invite", "remove", "join", "quit", "help"));
            if (sender.hasPermission("mylands.admin.reload")) {
                completions.add("admin");
            }
            if (sender.hasPermission("mylands.admin.reload")) {
                completions.add("admin");
            }
            return completions;
        }
        if (args.length == 2) {
            return switch (args[0].toLowerCase()) {
                case "zone" -> Arrays.asList("particles", "blocks");
                case "visit" -> Arrays.asList("open", "close");
                case "grade", "grades", "rank", "ranks" -> this.gradeSubCommand.getTabCompletions(args);
                case "admin" -> {
                    if (sender.hasPermission("mylands.admin.reload")) {
                        yield List.of("reload");
                    }
                    yield Collections.emptyList();
                }
                case "invite", "remove" -> null;
                default -> Collections.emptyList();
            };
        }
        return Collections.emptyList();
    }
}

