/*
 * Decompiled with CFR 0.152.
 */
package com.skynex.mylands.gui;

import com.skynex.mylands.gui.ConfigurableActivityLogsGui;
import com.skynex.mylands.gui.ConfigurableLeaderboardGui;
import com.skynex.mylands.gui.ConfigurableMembersGui;
import com.skynex.mylands.gui.ConfigurableQuestsGui;
import com.skynex.mylands.gui.ConfigurableSettingsGui;
import com.skynex.mylands.gui.GradesMenuGui;
import com.skynex.mylands.gui.GuiConfig;
import com.skynex.mylands.gui.GuiManager;
import com.skynex.mylands.gui.LandGui;
import com.skynex.mylands.manager.LandManager;
import com.skynex.mylands.model.Land;
import com.skynex.mylands.service.GradeService;
import com.skynex.mylands.service.LandService;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public class ConfigurableLandMenuGui
implements LandGui {
    private static final String GUI_NAME = "land_menu";
    private final GuiManager guiManager;
    private final GuiConfig guiConfig;
    private final Land land;
    private final LandService landService;
    private final GradeService gradeService;
    private final LandManager landManager;
    private final Map<Integer, String> slotToItemName = new HashMap<Integer, String>();

    public ConfigurableLandMenuGui(@NotNull GuiManager guiManager, @NotNull GuiConfig guiConfig, @NotNull Land land, @NotNull LandService landService, @NotNull GradeService gradeService, @NotNull LandManager landManager) {
        this.guiManager = guiManager;
        this.guiConfig = guiConfig;
        this.land = land;
        this.landService = landService;
        this.gradeService = gradeService;
        this.landManager = landManager;
        this.initializeSlotCache();
    }

    private void initializeSlotCache() {
        String[] items;
        for (String itemName : items = new String[]{"info", "upgrade", "members", "settings", "home", "logs", "quests", "leaderboard", "grades", "close"}) {
            GuiConfig.GuiItemConfig config = this.guiConfig.getItem(GUI_NAME, itemName);
            if (config == null) continue;
            this.slotToItemName.put(config.getSlot(), itemName);
        }
    }

    @Override
    @NotNull
    public Inventory createInventory() {
        Inventory inv = Bukkit.createInventory(null, (int)this.getSize(), (String)this.getTitle());
        this.createItem(inv, "info");
        this.createItem(inv, "upgrade");
        this.createItem(inv, "members");
        this.createItem(inv, "settings");
        this.createItem(inv, "home");
        this.createItem(inv, "logs");
        this.createItem(inv, "quests");
        this.createItem(inv, "leaderboard");
        this.createItem(inv, "grades");
        this.createItem(inv, "close");
        return inv;
    }

    private void createItem(@NotNull Inventory inv, @NotNull String itemName) {
        GuiConfig.GuiItemConfig itemConfig = this.guiConfig.getItem(GUI_NAME, itemName);
        if (itemConfig == null) {
            return;
        }
        Map<String, String> placeholders = this.getPlaceholders();
        ItemStack item = new ItemStack(itemConfig.getMaterial());
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            String name = itemConfig.getName();
            for (Map.Entry<String, String> entry : placeholders.entrySet()) {
                name = name.replace("{" + entry.getKey() + "}", entry.getValue());
            }
            meta.setDisplayName(name);
            meta.setLore(itemConfig.getLore(placeholders));
            item.setItemMeta(meta);
        }
        inv.setItem(itemConfig.getSlot(), item);
    }

    private Map<String, String> getPlaceholders() {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        Player owner = Bukkit.getPlayer((UUID)this.land.ownerId());
        placeholders.put("owner", owner != null ? owner.getName() : "Unknown");
        placeholders.put("name", this.land.name());
        placeholders.put("level", String.valueOf(this.land.level()));
        placeholders.put("next_level", String.valueOf(this.land.level() + 1));
        int size = this.land.cuboid().getSizeX();
        placeholders.put("size", String.valueOf(size));
        int maxCoOwners = 5;
        placeholders.put("coowners", String.valueOf(this.land.coOwners().size()));
        placeholders.put("max_coowners", String.valueOf(maxCoOwners));
        placeholders.put("visits_status", this.land.visitsOpen() ? "\u00a7aOpen" : "\u00a7cClosed");
        String cost = "0";
        try {
            cost = String.valueOf(10000 * this.land.level());
        }
        catch (Exception e) {
            cost = "N/A";
        }
        placeholders.put("cost", cost);
        return placeholders;
    }

    @Override
    public void handleClick(@NotNull Player player, int slot, @NotNull ItemStack item, @NotNull ClickType clickType) {
        String itemName = this.getItemNameBySlot(slot);
        if (itemName == null) {
            return;
        }
        switch (itemName) {
            case "upgrade": {
                this.handleUpgrade(player);
                break;
            }
            case "members": {
                this.handleMembers(player);
                break;
            }
            case "settings": {
                this.handleSettings(player);
                break;
            }
            case "home": {
                this.handleHome(player, clickType);
                break;
            }
            case "logs": {
                this.handleLogs(player);
                break;
            }
            case "quests": {
                this.handleQuests(player);
                break;
            }
            case "leaderboard": {
                this.handleLeaderboard(player);
                break;
            }
            case "grades": {
                this.handleGrades(player);
                break;
            }
            case "close": {
                player.closeInventory();
            }
        }
    }

    private String getItemNameBySlot(int slot) {
        return this.slotToItemName.get(slot);
    }

    private void handleUpgrade(Player player) {
        player.closeInventory();
        player.performCommand("lands upgrade");
    }

    private void handleMembers(Player player) {
        player.closeInventory();
        this.guiManager.openGui(player, new ConfigurableMembersGui(this.guiConfig, this.land, this.gradeService));
    }

    private void handleSettings(Player player) {
        player.closeInventory();
        this.guiManager.openGui(player, new ConfigurableSettingsGui(this.guiConfig, this.land));
    }

    private void handleHome(Player player, ClickType clickType) {
        player.closeInventory();
        if (clickType.isLeftClick()) {
            player.performCommand("lands home");
        } else if (clickType.isRightClick()) {
            player.performCommand("lands sethome");
        }
    }

    private void handleLogs(Player player) {
        player.closeInventory();
        this.guiManager.openGui(player, new ConfigurableActivityLogsGui(this.guiManager, this.guiConfig, this.land));
    }

    private void handleQuests(Player player) {
        player.closeInventory();
        this.guiManager.openGui(player, new ConfigurableQuestsGui(this.guiConfig, this.landManager.getQuestService()));
    }

    private void handleLeaderboard(Player player) {
        player.closeInventory();
        this.guiManager.openGui(player, new ConfigurableLeaderboardGui(this.guiManager, this.guiConfig, this.landService));
    }

    private void handleGrades(Player player) {
        player.closeInventory();
        this.guiManager.openGui(player, new GradesMenuGui(this.guiManager, this.land, this.gradeService));
    }

    @Override
    @NotNull
    public String getTitle() {
        String title = this.guiConfig.getTitle(GUI_NAME);
        Map<String, String> placeholders = this.getPlaceholders();
        for (Map.Entry<String, String> entry : placeholders.entrySet()) {
            title = title.replace("{" + entry.getKey() + "}", entry.getValue());
        }
        return title.replace("&", "\u00a7");
    }

    @Override
    public int getSize() {
        return this.guiConfig.getSize(GUI_NAME);
    }
}

