/*
 * Decompiled with CFR 0.152.
 */
package com.skynex.mylands.gui;

import com.skynex.mylands.gui.GuiConfig;
import com.skynex.mylands.gui.LandGui;
import com.skynex.mylands.model.Quest;
import com.skynex.mylands.model.QuestType;
import com.skynex.mylands.service.QuestService;
import com.skynex.mylands.util.PluginLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public class ConfigurableQuestsGui
implements LandGui {
    private static final String GUI_NAME = "quests_menu";
    private final GuiConfig guiConfig;
    private final List<Quest> quests;
    private final QuestService questService;

    public ConfigurableQuestsGui(@NotNull GuiConfig guiConfig, @NotNull QuestService questService) {
        this.guiConfig = guiConfig;
        this.questService = questService;
        this.quests = this.getAllAvailableQuests();
    }

    @NotNull
    private String convertColors(@NotNull String text) {
        return text.replace("&0", "\u00a70").replace("&1", "\u00a71").replace("&2", "\u00a72").replace("&3", "\u00a73").replace("&4", "\u00a74").replace("&5", "\u00a75").replace("&6", "\u00a76").replace("&7", "\u00a77").replace("&8", "\u00a78").replace("&9", "\u00a79").replace("&a", "\u00a7a").replace("&b", "\u00a7b").replace("&c", "\u00a7c").replace("&d", "\u00a7d").replace("&e", "\u00a7e").replace("&f", "\u00a7f").replace("&k", "\u00a7k").replace("&l", "\u00a7l").replace("&m", "\u00a7m").replace("&n", "\u00a7n").replace("&o", "\u00a7o").replace("&r", "\u00a7r");
    }

    @NotNull
    private List<Quest> getAllAvailableQuests() {
        ArrayList<Quest> allQuests = new ArrayList<Quest>();
        for (QuestType type : QuestType.values()) {
            List<Quest> typeQuests = this.questService.getQuestsByType(type);
            allQuests.addAll(typeQuests);
            PluginLogger.info("[QuestGUI] Loaded {} quests for type: {}", new Object[]{typeQuests.size(), type});
        }
        PluginLogger.info("[QuestGUI] Total quests loaded: {}", allQuests.size());
        return allQuests;
    }

    @Override
    @NotNull
    public Inventory createInventory() {
        return this.createInventory(null);
    }

    @NotNull
    public Inventory createInventory(Player player) {
        Inventory inv = Bukkit.createInventory(null, (int)this.getSize(), (String)this.getTitle());
        this.displayQuests(inv, player);
        this.createItem(inv, "back");
        return inv;
    }

    private void displayQuests(@NotNull Inventory inv, Player player) {
        int maxQuests = Math.min(this.quests.size(), 26);
        boolean isCollaborative = this.questService.isCollaborativeMode();
        String activeQuestId = player != null ? this.questService.getActiveQuest(player.getUniqueId()) : null;
        for (int i = 0; i < maxQuests; ++i) {
            Quest quest = this.quests.get(i);
            boolean isFollowing = player != null && activeQuestId != null && activeQuestId.equals(quest.id());
            ItemStack item = new ItemStack(quest.material());
            ItemMeta meta = item.getItemMeta();
            if (meta != null) {
                meta.setDisplayName(this.convertColors(quest.name()));
                ArrayList<String> lore = new ArrayList<String>();
                lore.add(this.convertColors("&8&m\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501"));
                lore.add(this.convertColors(quest.description()));
                if (isCollaborative) {
                    lore.add("");
                    lore.add(this.convertColors("&b&l\ud83e\udd1d Mode Collaboratif"));
                    lore.add(this.convertColors("&7Tous les membres contribuent"));
                } else {
                    lore.add("");
                    lore.add(this.convertColors("&e&l\ud83d\udc64 Mode Personnel"));
                    lore.add(this.convertColors("&7Progression individuelle"));
                }
                lore.add("");
                for (String obj : quest.objectives()) {
                    lore.add(this.convertColors(obj));
                }
                lore.add(this.convertColors("&8&m\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501"));
                if (quest.completed()) {
                    lore.add("");
                    lore.add(this.convertColors("&a&l\u2714 COMPLETED"));
                } else if (isFollowing) {
                    lore.add("");
                    lore.add(this.convertColors("&a&l\u2713 Qu\u00eate suivi(e)"));
                } else {
                    lore.add("");
                    lore.add(this.convertColors("&e\u25b6 Cliquez pour suivre"));
                }
                meta.setLore(lore);
                item.setItemMeta(meta);
            }
            inv.setItem(i, item);
        }
    }

    private void createItem(@NotNull Inventory inv, @NotNull String itemName) {
        GuiConfig.GuiItemConfig itemConfig = this.guiConfig.getItem(GUI_NAME, itemName);
        if (itemConfig == null) {
            return;
        }
        ItemStack item = new ItemStack(itemConfig.getMaterial());
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(itemConfig.getName());
            meta.setLore(itemConfig.getLore(new HashMap<String, String>()));
            item.setItemMeta(meta);
        }
        inv.setItem(itemConfig.getSlot(), item);
    }

    @Override
    public void handleClick(@NotNull Player player, int slot, @NotNull ItemStack item, @NotNull ClickType clickType) {
        int maxQuestSlots = Math.min(this.quests.size(), 26);
        if (slot >= 0 && slot < maxQuestSlots) {
            Quest quest = this.quests.get(slot);
            if (!quest.completed()) {
                boolean wasFollowing;
                String currentActiveQuestId = this.questService.getActiveQuest(player.getUniqueId());
                boolean bl = wasFollowing = currentActiveQuestId != null && currentActiveQuestId.equals(quest.id());
                if (wasFollowing) {
                    this.questService.setActiveQuest(player.getUniqueId(), null);
                } else {
                    this.questService.setActiveQuest(player.getUniqueId(), quest.id());
                }
                Inventory newInv = this.createInventory(player);
                player.getOpenInventory().getTopInventory().setContents(newInv.getContents());
            } else {
                player.sendMessage(this.convertColors("&a\u2714 This quest is already completed!"));
            }
            return;
        }
        String itemName = this.getItemNameBySlot(slot);
        if (itemName != null && itemName.equals("back")) {
            this.handleBack(player);
        }
    }

    private String getItemNameBySlot(int slot) {
        GuiConfig.GuiItemConfig config = this.guiConfig.getItem(GUI_NAME, "back");
        if (config != null && config.getSlot() == slot) {
            return "back";
        }
        return null;
    }

    private void handleBack(Player player) {
        player.closeInventory();
        player.performCommand("lands menu");
    }

    @Override
    @NotNull
    public String getTitle() {
        return this.guiConfig.getTitle(GUI_NAME).replace("&", "\u00a7");
    }

    @Override
    public int getSize() {
        return this.guiConfig.getSize(GUI_NAME);
    }
}

