/*
 * Decompiled with CFR 0.152.
 */
package com.skynex.mylands.gui;

import com.skynex.mylands.gui.GuiConfig;
import com.skynex.mylands.gui.LandGui;
import com.skynex.mylands.model.Land;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public class ConfigurableSettingsGui
implements LandGui {
    private static final String GUI_NAME = "settings_menu";
    private final GuiConfig guiConfig;
    private final Land land;

    public ConfigurableSettingsGui(@NotNull GuiConfig guiConfig, @NotNull Land land) {
        this.guiConfig = guiConfig;
        this.land = land;
    }

    @Override
    @NotNull
    public Inventory createInventory() {
        Inventory inv = Bukkit.createInventory(null, (int)this.getSize(), (String)this.getTitle());
        this.createVisitsItem(inv);
        this.createItem(inv, "zone_display");
        this.createItem(inv, "delete");
        this.createItem(inv, "back");
        return inv;
    }

    private void createVisitsItem(@NotNull Inventory inv) {
        GuiConfig.GuiItemConfig itemConfig = this.guiConfig.getItem(GUI_NAME, "visits");
        if (itemConfig == null) {
            return;
        }
        Map<String, String> placeholders = this.getPlaceholders();
        boolean visitsOpen = this.land.visitsOpen();
        ItemStack item = new ItemStack(itemConfig.getMaterial(visitsOpen));
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            String name = itemConfig.getName(visitsOpen);
            for (Map.Entry<String, String> entry : placeholders.entrySet()) {
                name = name.replace("{" + entry.getKey() + "}", entry.getValue());
            }
            meta.setDisplayName(name);
            meta.setLore(itemConfig.getLore(placeholders));
            item.setItemMeta(meta);
        }
        inv.setItem(itemConfig.getSlot(), item);
    }

    private void createItem(@NotNull Inventory inv, @NotNull String itemName) {
        GuiConfig.GuiItemConfig itemConfig = this.guiConfig.getItem(GUI_NAME, itemName);
        if (itemConfig == null) {
            return;
        }
        Map<String, String> placeholders = this.getPlaceholders();
        ItemStack item = new ItemStack(itemConfig.getMaterial());
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            String name = itemConfig.getName();
            for (Map.Entry<String, String> entry : placeholders.entrySet()) {
                name = name.replace("{" + entry.getKey() + "}", entry.getValue());
            }
            meta.setDisplayName(name);
            meta.setLore(itemConfig.getLore(placeholders));
            item.setItemMeta(meta);
        }
        inv.setItem(itemConfig.getSlot(), item);
    }

    private Map<String, String> getPlaceholders() {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("status", this.land.visitsOpen() ? "\u00a7aOpen" : "\u00a7cClosed");
        try {
            int refund = 5000 * this.land.level();
            placeholders.put("refund", String.valueOf(refund));
        }
        catch (Exception e) {
            placeholders.put("refund", "N/A");
        }
        return placeholders;
    }

    @Override
    public void handleClick(@NotNull Player player, int slot, @NotNull ItemStack item, @NotNull ClickType clickType) {
        String itemName = this.getItemNameBySlot(slot);
        if (itemName == null) {
            return;
        }
        switch (itemName) {
            case "visits": {
                this.handleVisits(player);
                break;
            }
            case "zone_display": {
                this.handleZoneDisplay(player, clickType);
                break;
            }
            case "delete": {
                this.handleDelete(player, clickType);
                break;
            }
            case "back": {
                this.handleBack(player);
            }
        }
    }

    private String getItemNameBySlot(int slot) {
        String[] items;
        for (String itemName : items = new String[]{"visits", "zone_display", "delete", "back"}) {
            GuiConfig.GuiItemConfig config = this.guiConfig.getItem(GUI_NAME, itemName);
            if (config == null || config.getSlot() != slot) continue;
            return itemName;
        }
        return null;
    }

    private void handleVisits(Player player) {
        player.closeInventory();
        player.performCommand("lands visit " + (this.land.visitsOpen() ? "close" : "open"));
    }

    private void handleZoneDisplay(Player player, ClickType clickType) {
        player.closeInventory();
        if (clickType.isLeftClick()) {
            player.performCommand("lands zone particles");
        } else if (clickType.isRightClick()) {
            player.performCommand("lands zone blocks");
        }
    }

    private void handleDelete(Player player, ClickType clickType) {
        if (clickType.isShiftClick()) {
            player.closeInventory();
            player.performCommand("lands delete");
        } else {
            player.sendMessage("\u00a7c\u00a7lWARNING: \u00a77Shift-click to confirm deletion!");
        }
    }

    private void handleBack(Player player) {
        player.closeInventory();
        player.performCommand("lands menu");
    }

    @Override
    @NotNull
    public String getTitle() {
        return this.guiConfig.getTitle(GUI_NAME).replace("&", "\u00a7");
    }

    @Override
    public int getSize() {
        return this.guiConfig.getSize(GUI_NAME);
    }
}

