/*
 * Decompiled with CFR 0.152.
 */
package com.skynex.mylands.gui;

import com.skynex.mylands.gui.GradesMenuGui;
import com.skynex.mylands.gui.GuiManager;
import com.skynex.mylands.gui.LandGui;
import com.skynex.mylands.model.Grade;
import com.skynex.mylands.model.Land;
import com.skynex.mylands.model.LandPermission;
import com.skynex.mylands.service.GradeService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public class GradePermissionsGui
implements LandGui {
    private final GuiManager guiManager;
    private final Land land;
    private final Grade grade;
    private final GradeService gradeService;

    public GradePermissionsGui(@NotNull GuiManager guiManager, @NotNull Land land, @NotNull Grade grade, @NotNull GradeService gradeService) {
        this.guiManager = guiManager;
        this.land = land;
        this.grade = grade;
        this.gradeService = gradeService;
    }

    @Override
    @NotNull
    public Inventory createInventory() {
        Inventory inv = Bukkit.createInventory(null, (int)54, (String)this.getTitle());
        LandPermission[] permissions = LandPermission.values();
        int maxPermissions = Math.min(permissions.length, 45);
        for (int i = 0; i < maxPermissions; ++i) {
            inv.setItem(i, this.createPermissionItem(permissions[i]));
        }
        inv.setItem(49, this.createToggleAllButton());
        inv.setItem(53, this.createSaveButton());
        inv.setItem(45, this.createBackButton());
        return inv;
    }

    private ItemStack createPermissionItem(@NotNull LandPermission permission) {
        ItemStack item;
        ItemMeta meta;
        boolean hasPermission = this.grade.hasPermission(permission);
        Material material = Material.getMaterial((String)permission.getIconMaterial());
        if (material == null) {
            material = Material.PAPER;
        }
        if ((meta = (item = new ItemStack(material)).getItemMeta()) != null) {
            String status = hasPermission ? "\u00a7a\u2714 " : "\u00a7c\u2716 ";
            meta.setDisplayName(status + permission.getColoredName());
            ArrayList<Object> lore = new ArrayList<Object>();
            lore.add("\u00a78&m\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
            lore.add(permission.getDescription());
            lore.add("\u00a78&m\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
            lore.add("");
            lore.add("\u00a77Status: " + (hasPermission ? "\u00a7aEnabled" : "\u00a7cDisabled"));
            lore.add("");
            lore.add("\u00a7e\u25b6 Click to toggle");
            meta.setLore(lore);
            item.setItemMeta(meta);
        }
        return item;
    }

    private ItemStack createToggleAllButton() {
        ItemStack item = new ItemStack(Material.COMMAND_BLOCK);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName("\u00a76\u00a7lToggle All");
            ArrayList<String> lore = new ArrayList<String>();
            lore.add("\u00a78&m\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
            lore.add("\u00a77Enable or disable all permissions");
            lore.add("\u00a78&m\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
            lore.add("");
            lore.add("\u00a7e\u25b6 Left-click: \u00a7aEnable all");
            lore.add("\u00a7e\u25b6 Right-click: \u00a7cDisable all");
            meta.setLore(lore);
            item.setItemMeta(meta);
        }
        return item;
    }

    private ItemStack createSaveButton() {
        ItemStack item = new ItemStack(Material.EMERALD);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName("\u00a7a\u00a7l\u2714 Save Changes");
            ArrayList<String> lore = new ArrayList<String>();
            lore.add("\u00a78&m\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
            lore.add("\u00a77Save permission changes");
            lore.add("\u00a78&m\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
            lore.add("");
            lore.add("\u00a7e\u25b6 Click to save!");
            meta.setLore(lore);
            item.setItemMeta(meta);
        }
        return item;
    }

    private ItemStack createBackButton() {
        ItemStack item = new ItemStack(Material.ARROW);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName("\u00a7e\u00a7l\u2190 Back");
            ArrayList<String> lore = new ArrayList<String>();
            lore.add("\u00a77Return to grades menu");
            meta.setLore(lore);
            item.setItemMeta(meta);
        }
        return item;
    }

    @Override
    public void handleClick(@NotNull Player player, int slot, @NotNull ItemStack item, @NotNull ClickType clickType) {
        LandPermission[] permissions = LandPermission.values();
        int maxPermissions = Math.min(permissions.length, 45);
        if (slot >= 0 && slot < maxPermissions) {
            LandPermission permission = permissions[slot];
            this.togglePermission(permission);
            this.guiManager.openGui(player, this);
            return;
        }
        if (slot == 49) {
            if (clickType.isLeftClick()) {
                this.enableAllPermissions();
            } else if (clickType.isRightClick()) {
                this.disableAllPermissions();
            }
            this.guiManager.openGui(player, this);
        } else if (slot == 53) {
            this.handleSave(player);
        } else if (slot == 45) {
            player.closeInventory();
            this.guiManager.openGui(player, new GradesMenuGui(this.guiManager, this.land, this.gradeService));
        }
    }

    private void togglePermission(@NotNull LandPermission permission) {
        HashSet<LandPermission> newPermissions = new HashSet<LandPermission>(this.grade.permissions());
        if (newPermissions.contains((Object)permission)) {
            newPermissions.remove((Object)permission);
        } else {
            newPermissions.add(permission);
        }
        Grade updatedGrade = new Grade(this.grade.id(), this.grade.landOwnerId(), this.grade.name(), this.grade.color(), this.grade.icon(), this.grade.priority(), newPermissions, this.grade.isDefault());
        this.gradeService.updateGrade(updatedGrade);
    }

    private void enableAllPermissions() {
        Grade updatedGrade = new Grade(this.grade.id(), this.grade.landOwnerId(), this.grade.name(), this.grade.color(), this.grade.icon(), this.grade.priority(), Set.of(LandPermission.values()), this.grade.isDefault());
        this.gradeService.updateGrade(updatedGrade);
    }

    private void disableAllPermissions() {
        Grade updatedGrade = new Grade(this.grade.id(), this.grade.landOwnerId(), this.grade.name(), this.grade.color(), this.grade.icon(), this.grade.priority(), Collections.emptySet(), this.grade.isDefault());
        this.gradeService.updateGrade(updatedGrade);
    }

    private void handleSave(Player player) {
        player.closeInventory();
        player.sendMessage("\u00a7a\u00a7l\u2714 Permissions saved for grade " + this.grade.getColoredName());
        player.sendMessage("\u00a77Total permissions: \u00a7e" + this.grade.permissions().size());
    }

    @Override
    @NotNull
    public String getTitle() {
        return "\u00a75\u00a7l\u2699 " + this.grade.name() + " Permissions";
    }

    @Override
    public int getSize() {
        return 54;
    }
}

