/*
 * Decompiled with CFR 0.152.
 */
package com.skynex.mylands.gui;

import com.skynex.mylands.gui.GradePermissionsGui;
import com.skynex.mylands.gui.GuiManager;
import com.skynex.mylands.gui.LandGui;
import com.skynex.mylands.model.Grade;
import com.skynex.mylands.model.Land;
import com.skynex.mylands.service.GradeService;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public class GradesMenuGui
implements LandGui {
    private final GuiManager guiManager;
    private final Land land;
    private final GradeService gradeService;

    public GradesMenuGui(@NotNull GuiManager guiManager, @NotNull Land land, @NotNull GradeService gradeService) {
        this.guiManager = guiManager;
        this.land = land;
        this.gradeService = gradeService;
    }

    @Override
    @NotNull
    public Inventory createInventory() {
        Inventory inv = Bukkit.createInventory(null, (int)54, (String)this.getTitle());
        this.displayGrades(inv);
        inv.setItem(49, this.createNewGradeButton());
        inv.setItem(45, this.createBackButton());
        return inv;
    }

    private void displayGrades(@NotNull Inventory inv) {
        List<Grade> grades = this.gradeService.getGrades(this.land.ownerId());
        int maxGrades = Math.min(grades.size(), 45);
        for (int i = 0; i < maxGrades; ++i) {
            Grade grade = grades.get(i);
            inv.setItem(i, this.createGradeItem(grade));
        }
    }

    private ItemStack createGradeItem(@NotNull Grade grade) {
        ItemStack item;
        ItemMeta meta;
        Material material = Material.getMaterial((String)grade.icon());
        if (material == null) {
            material = Material.NAME_TAG;
        }
        if ((meta = (item = new ItemStack(material)).getItemMeta()) != null) {
            meta.setDisplayName(grade.getColoredName() + " \u00a77(Priority: " + grade.priority() + ")");
            ArrayList<Object> lore = new ArrayList<Object>();
            lore.add("\u00a78&m\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
            lore.add("\u00a77Permissions: \u00a7e" + grade.permissions().size());
            lore.add("\u00a77Default: " + (grade.isDefault() ? "\u00a7aYes" : "\u00a7cNo"));
            lore.add("\u00a78&m\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
            lore.add("");
            lore.add("\u00a7e\u25b6 Left-click: \u00a77Edit permissions");
            lore.add("\u00a7e\u25b6 Right-click: \u00a77Edit grade");
            if (!grade.isDefault()) {
                lore.add("\u00a7c\u25b6 Shift-click: \u00a77Delete grade");
            }
            meta.setLore(lore);
            item.setItemMeta(meta);
        }
        return item;
    }

    private ItemStack createNewGradeButton() {
        ItemStack item = new ItemStack(Material.LIME_DYE);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName("\u00a7a\u00a7l+ Create New Grade");
            ArrayList<String> lore = new ArrayList<String>();
            lore.add("\u00a78&m\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
            lore.add("\u00a77Create a new custom grade");
            lore.add("\u00a78&m\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
            lore.add("");
            lore.add("\u00a7e\u25b6 Click to create!");
            meta.setLore(lore);
            item.setItemMeta(meta);
        }
        return item;
    }

    private ItemStack createBackButton() {
        ItemStack item = new ItemStack(Material.ARROW);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName("\u00a7e\u00a7l\u2190 Back");
            ArrayList<String> lore = new ArrayList<String>();
            lore.add("\u00a77Return to land menu");
            meta.setLore(lore);
            item.setItemMeta(meta);
        }
        return item;
    }

    @Override
    public void handleClick(@NotNull Player player, int slot, @NotNull ItemStack item, @NotNull ClickType clickType) {
        List<Grade> grades = this.gradeService.getGrades(this.land.ownerId());
        int maxGrades = Math.min(grades.size(), 45);
        if (slot >= 0 && slot < maxGrades) {
            Grade grade = grades.get(slot);
            if (clickType.isShiftClick() && !grade.isDefault()) {
                this.handleDeleteGrade(player, grade);
            } else if (clickType.isLeftClick()) {
                this.handleEditPermissions(player, grade);
            } else if (clickType.isRightClick()) {
                this.handleEditGrade(player, grade);
            }
            return;
        }
        if (slot == 49) {
            this.handleCreateGrade(player);
        } else if (slot == 45) {
            player.closeInventory();
            player.performCommand("lands menu");
        }
    }

    private void handleEditPermissions(Player player, Grade grade) {
        player.closeInventory();
        this.guiManager.openGui(player, new GradePermissionsGui(this.guiManager, this.land, grade, this.gradeService));
    }

    private void handleEditGrade(Player player, Grade grade) {
        player.closeInventory();
        player.sendMessage("\u00a7e\u00a7l\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
        player.sendMessage("\u00a76\u00a7lEdit Grade: " + grade.getColoredName());
        player.sendMessage("\u00a77Use commands to edit:");
        player.sendMessage("\u00a7e/lands grade rename " + grade.id() + " <name>");
        player.sendMessage("\u00a7e/lands grade color " + grade.id() + " <color>");
        player.sendMessage("\u00a7e/lands grade priority " + grade.id() + " <1-10>");
        player.sendMessage("\u00a7e\u00a7l\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
    }

    private void handleDeleteGrade(Player player, Grade grade) {
        if (this.gradeService.deleteGrade(this.land.ownerId(), grade.id())) {
            player.sendMessage("\u00a7a\u2714 Grade " + grade.getColoredName() + " \u00a7adeleted!");
            this.guiManager.openGui(player, this);
        } else {
            player.sendMessage("\u00a7c\u2716 Failed to delete grade!");
        }
    }

    private void handleCreateGrade(Player player) {
        player.closeInventory();
        player.sendMessage("\u00a7e\u00a7l\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
        player.sendMessage("\u00a76\u00a7lCreate New Grade");
        player.sendMessage("\u00a77Use the command:");
        player.sendMessage("\u00a7e/lands grade create <name>");
        player.sendMessage("\u00a7e\u00a7l\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
    }

    @Override
    @NotNull
    public String getTitle() {
        return "\u00a75\u00a7l\u2694 Land Grades";
    }

    @Override
    public int getSize() {
        return 54;
    }
}

