/*
 * Decompiled with CFR 0.152.
 */
package com.skynex.mylands.gui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuiConfig {
    private final FileConfiguration config;
    private final Map<String, GuiItemConfig> itemConfigs = new HashMap<String, GuiItemConfig>();

    public GuiConfig(@NotNull FileConfiguration config) {
        this.config = config;
        this.loadConfigs();
    }

    private void loadConfigs() {
        for (String guiKey : this.config.getKeys(false)) {
            ConfigurationSection itemsSection;
            ConfigurationSection guiSection = this.config.getConfigurationSection(guiKey);
            if (guiSection == null || (itemsSection = guiSection.getConfigurationSection("items")) == null) continue;
            for (String itemKey : itemsSection.getKeys(false)) {
                ConfigurationSection itemSection = itemsSection.getConfigurationSection(itemKey);
                if (itemSection == null) continue;
                String fullKey = guiKey + "." + itemKey;
                GuiItemConfig itemConfig = new GuiItemConfig(itemSection.getInt("slot", 0), Material.getMaterial((String)itemSection.getString("material", "STONE")), itemSection.getString("name", ""), itemSection.getStringList("lore"), itemSection.getString("material_open"), itemSection.getString("material_closed"), itemSection.getString("name_open"), itemSection.getString("name_closed"));
                this.itemConfigs.put(fullKey, itemConfig);
            }
        }
    }

    @Nullable
    public GuiItemConfig getItem(@NotNull String guiName, @NotNull String itemName) {
        return this.itemConfigs.get(guiName + "." + itemName);
    }

    @NotNull
    public String getTitle(@NotNull String guiName) {
        return this.config.getString(guiName + ".title", "&6GUI");
    }

    public int getSize(@NotNull String guiName) {
        return this.config.getInt(guiName + ".size", 27);
    }

    public static class GuiItemConfig {
        private final int slot;
        private final Material material;
        private final String name;
        private final List<String> lore;
        private final String materialOpen;
        private final String materialClosed;
        private final String nameOpen;
        private final String nameClosed;

        public GuiItemConfig(int slot, @Nullable Material material, @NotNull String name, @NotNull List<String> lore, @Nullable String materialOpen, @Nullable String materialClosed, @Nullable String nameOpen, @Nullable String nameClosed) {
            this.slot = slot;
            this.material = material != null ? material : Material.STONE;
            this.name = name;
            this.lore = new ArrayList<String>(lore);
            this.materialOpen = materialOpen;
            this.materialClosed = materialClosed;
            this.nameOpen = nameOpen;
            this.nameClosed = nameClosed;
        }

        public int getSlot() {
            return this.slot;
        }

        @NotNull
        public Material getMaterial() {
            return this.material;
        }

        @NotNull
        public Material getMaterial(boolean state) {
            if (state && this.materialOpen != null) {
                Material mat = Material.getMaterial((String)this.materialOpen);
                return mat != null ? mat : this.material;
            }
            if (!state && this.materialClosed != null) {
                Material mat = Material.getMaterial((String)this.materialClosed);
                return mat != null ? mat : this.material;
            }
            return this.material;
        }

        @NotNull
        public String getName() {
            return this.colorize(this.name);
        }

        @NotNull
        public String getName(boolean state) {
            if (state && this.nameOpen != null) {
                return this.colorize(this.nameOpen);
            }
            if (!state && this.nameClosed != null) {
                return this.colorize(this.nameClosed);
            }
            return this.getName();
        }

        @NotNull
        public List<String> getLore() {
            ArrayList<String> colorized = new ArrayList<String>();
            for (String line : this.lore) {
                colorized.add(this.colorize(line));
            }
            return colorized;
        }

        @NotNull
        public List<String> getLore(@NotNull Map<String, String> placeholders) {
            ArrayList<String> result = new ArrayList<String>();
            Iterator<String> iterator = this.lore.iterator();
            while (iterator.hasNext()) {
                String line;
                String processed = line = iterator.next();
                for (Map.Entry<String, String> entry : placeholders.entrySet()) {
                    processed = processed.replace("{" + entry.getKey() + "}", entry.getValue());
                }
                result.add(this.colorize(processed));
            }
            return result;
        }

        private String colorize(@NotNull String text) {
            return text.replace("&", "\u00a7");
        }
    }
}

