/*
 * Decompiled with CFR 0.152.
 */
package com.skynex.mylands.gui;

import com.skynex.mylands.gui.LandGui;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.jetbrains.annotations.NotNull;

public class GuiManager
implements Listener {
    private final Map<UUID, LandGui> openGuis = new ConcurrentHashMap<UUID, LandGui>();

    public void openGui(@NotNull Player player, @NotNull LandGui gui) {
        Inventory inventory = gui.createInventory();
        this.openGuis.put(player.getUniqueId(), gui);
        player.openInventory(inventory);
    }

    public void closeGui(@NotNull Player player) {
        this.openGuis.remove(player.getUniqueId());
        player.closeInventory();
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        LandGui gui = this.openGuis.get(player.getUniqueId());
        if (gui == null) {
            return;
        }
        event.setCancelled(true);
        if (event.getCurrentItem() == null) {
            return;
        }
        gui.handleClick(player, event.getSlot(), event.getCurrentItem(), event.getClick());
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        HumanEntity humanEntity = event.getPlayer();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        LandGui gui = this.openGuis.get(player.getUniqueId());
        if (gui != null) {
            gui.onClose(player);
            this.openGuis.remove(player.getUniqueId());
        }
    }

    public boolean hasGuiOpen(@NotNull Player player) {
        return this.openGuis.containsKey(player.getUniqueId());
    }

    public LandGui getOpenGui(@NotNull Player player) {
        return this.openGuis.get(player.getUniqueId());
    }
}

