/*
 * Decompiled with CFR 0.152.
 */
package com.skynex.mylands.integration;

import com.skynex.mylands.manager.LandManager;
import com.skynex.mylands.model.Land;
import fr.skynex.mycore.api.lands.LandProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class MyLandProvider
implements LandProvider {
    private final JavaPlugin plugin;
    private final LandManager landManager;

    public MyLandProvider(JavaPlugin plugin, LandManager landManager) {
        this.plugin = plugin;
        this.landManager = landManager;
    }

    public String getProviderName() {
        return "MyLands";
    }

    public String getProviderVersion() {
        return this.plugin.getDescription().getVersion();
    }

    public boolean isEnabled() {
        return this.plugin.isEnabled();
    }

    public boolean hasLand(Player player) {
        return this.hasLand(player.getUniqueId());
    }

    public boolean hasLand(UUID uuid) {
        return this.landManager.getLandService().getLand(uuid).join().isPresent();
    }

    public int getLandCount(UUID uuid) {
        return this.hasLand(uuid) ? 1 : 0;
    }

    public List<String> getPlayerLandIds(UUID uuid) {
        if (this.hasLand(uuid)) {
            return List.of(uuid.toString());
        }
        return Collections.emptyList();
    }

    public boolean isInLand(Location location) {
        return this.landManager.getLandService().getLandAtLocation(location) != null;
    }

    public Optional<String> getLandAt(Location location) {
        Land land = this.landManager.getLandService().getLandAtLocation(location);
        return land != null ? Optional.of(land.ownerId().toString()) : Optional.empty();
    }

    public Optional<UUID> getLandOwnerAt(Location location) {
        Land land = this.landManager.getLandService().getLandAtLocation(location);
        return land != null ? Optional.of(land.ownerId()) : Optional.empty();
    }

    public boolean isOwnerAt(Player player, Location location) {
        Land land = this.landManager.getLandService().getLandAtLocation(location);
        return land != null && land.ownerId().equals(player.getUniqueId());
    }

    public boolean isMemberAt(Player player, Location location) {
        Land land = this.landManager.getLandService().getLandAtLocation(location);
        return land != null && land.hasAccess(player.getUniqueId());
    }

    public boolean canBuild(Player player, Location location) {
        return this.landManager.getLandService().hasAccessToLocation(player.getUniqueId(), location);
    }

    public boolean canInteract(Player player, Location location) {
        return this.landManager.getLandService().hasAccessToLocation(player.getUniqueId(), location);
    }

    public boolean canAccessContainers(Player player, Location location) {
        return this.landManager.getLandService().hasAccessToLocation(player.getUniqueId(), location);
    }

    public boolean canTeleport(Player player, String landId) {
        try {
            UUID ownerId = UUID.fromString(landId);
            Optional<Land> landOpt = this.landManager.getLandService().getLand(ownerId).join();
            if (landOpt.isEmpty()) {
                return false;
            }
            Land land = landOpt.get();
            return land.hasAccess(player.getUniqueId()) || land.visitsOpen();
        }
        catch (Exception e) {
            return false;
        }
    }

    public Optional<String> getLandName(String landId) {
        try {
            UUID ownerId = UUID.fromString(landId);
            return this.landManager.getLandService().getLand(ownerId).join().map(Land::name);
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public Optional<UUID> getLandOwner(String landId) {
        try {
            UUID ownerId = UUID.fromString(landId);
            return this.landManager.getLandService().getLand(ownerId).join().map(Land::ownerId);
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public int getLandSize(String landId) {
        try {
            UUID ownerId = UUID.fromString(landId);
            return this.landManager.getLandService().getLand(ownerId).join().map(land -> (int)land.cuboid().getVolume()).orElse(0);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public int getLandLevel(String landId) {
        try {
            UUID ownerId = UUID.fromString(landId);
            return this.landManager.getLandService().getLand(ownerId).join().map(Land::level).orElse(0);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public Optional<Location> getLandSpawn(String landId) {
        try {
            UUID ownerId = UUID.fromString(landId);
            return this.landManager.getLandService().getLand(ownerId).join().map(Land::home);
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public List<UUID> getLandMembers(String landId) {
        try {
            UUID ownerId = UUID.fromString(landId);
            return this.landManager.getLandService().getLand(ownerId).join().map(land -> {
                ArrayList<UUID> members = new ArrayList<UUID>(land.coOwners());
                members.add(0, land.ownerId());
                return members;
            }).orElse(Collections.emptyList());
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    public boolean isMember(UUID uuid, String landId) {
        try {
            UUID ownerId = UUID.fromString(landId);
            return this.landManager.getLandService().getLand(ownerId).join().map(land -> land.hasAccess(uuid)).orElse(false);
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getMemberRole(UUID uuid, String landId) {
        try {
            UUID ownerId = UUID.fromString(landId);
            Optional<Land> landOpt = this.landManager.getLandService().getLand(ownerId).join();
            if (landOpt.isEmpty()) {
                return null;
            }
            Land land = landOpt.get();
            if (land.ownerId().equals(uuid)) {
                return "OWNER";
            }
            if (land.isCoOwner(uuid)) {
                return "MEMBER";
            }
            return "VISITOR";
        }
        catch (Exception e) {
            return null;
        }
    }

    public double getLandPrice(String landId) {
        return 0.0;
    }

    public double getPricePerBlock() {
        return 0.0;
    }

    public double calculatePrice(int sizeX, int sizeY, int sizeZ) {
        return this.landManager.getConfigManager().getCreationCost();
    }

    public double getLandTax(String landId) {
        return 0.0;
    }
}

