/*
 * Decompiled with CFR 0.152.
 */
package com.skynex.mylands.listeners;

import com.skynex.mylands.manager.LandManager;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;

public class ChatListener
implements Listener {
    private final LandManager landManager;

    public ChatListener(LandManager landManager) {
        this.landManager = landManager;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        UUID playerId = player.getUniqueId();
        if (!this.landManager.isAwaitingLandName(playerId)) {
            return;
        }
        event.setCancelled(true);
        this.landManager.removeAwaitingLandName(playerId);
        String landName = event.getMessage().trim();
        if (landName.equalsIgnoreCase("cancel")) {
            player.sendMessage(this.landManager.getMessages().get("farm_creation_cancelled"));
            return;
        }
        if (!this.landManager.isValidLandName(landName)) {
            player.sendMessage(this.landManager.getMessages().invalidFarmName());
            return;
        }
        ((CompletableFuture)this.landManager.createLand(player, landName).thenAccept(land -> player.sendMessage(this.landManager.getMessages().farmCreated(landName)))).exceptionally(ex -> {
            String message;
            String string = message = ex.getCause() != null ? ex.getCause().getMessage() : ex.getMessage();
            if (message != null && message.contains("overlaps")) {
                player.sendMessage(this.landManager.getMessages().farmOverlaps());
            } else if (message != null && message.contains("Insufficient")) {
                player.sendMessage(this.landManager.getMessages().get("insufficient_funds_for_creation", Map.of("cost", String.valueOf(this.landManager.getConfigManager().getCreationCost()))));
            } else {
                player.sendMessage(this.landManager.getMessages().alreadyHasFarm());
            }
            return null;
        });
    }
}

