/*
 * Decompiled with CFR 0.152.
 */
package com.skynex.mylands.model;

import org.bukkit.Location;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;

public record Cuboid(@NotNull World world, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
    public static Cuboid from(@NotNull Location corner1, @NotNull Location corner2) {
        if (!corner1.getWorld().equals((Object)corner2.getWorld())) {
            throw new IllegalArgumentException("Corners must be in the same world");
        }
        return new Cuboid(corner1.getWorld(), Math.min(corner1.getX(), corner2.getX()), Math.min(corner1.getY(), corner2.getY()), Math.min(corner1.getZ(), corner2.getZ()), Math.max(corner1.getX(), corner2.getX()), Math.max(corner1.getY(), corner2.getY()), Math.max(corner1.getZ(), corner2.getZ()));
    }

    public boolean contains(@NotNull Location location) {
        if (!location.getWorld().equals((Object)this.world)) {
            return false;
        }
        double x = location.getX();
        double y = location.getY();
        double z = location.getZ();
        return x >= this.minX && x <= this.maxX && y >= this.minY && y <= this.maxY && z >= this.minZ && z <= this.maxZ;
    }

    public boolean overlaps(@NotNull Cuboid other) {
        if (!this.world.equals((Object)other.world)) {
            return false;
        }
        return this.minX < other.maxX && this.maxX > other.minX && this.minY < other.maxY && this.maxY > other.minY && this.minZ < other.maxZ && this.maxZ > other.minZ;
    }

    @NotNull
    public Location getCenter() {
        return new Location(this.world, (this.minX + this.maxX) / 2.0, (this.minY + this.maxY) / 2.0, (this.minZ + this.maxZ) / 2.0);
    }

    @NotNull
    public Location getMinCorner() {
        return new Location(this.world, this.minX, this.minY, this.minZ);
    }

    @NotNull
    public Location getMaxCorner() {
        return new Location(this.world, this.maxX, this.maxY, this.maxZ);
    }

    public Cuboid expand(double amount) {
        return new Cuboid(this.world, this.minX - amount, this.minY, this.minZ - amount, this.maxX + amount, this.maxY, this.maxZ + amount);
    }

    public double getVolume() {
        return (this.maxX - this.minX) * (this.maxY - this.minY) * (this.maxZ - this.minZ);
    }

    public int getSizeX() {
        return (int)Math.round(this.maxX - this.minX);
    }

    public int getSizeY() {
        return (int)Math.round(this.maxY - this.minY);
    }

    public int getSizeZ() {
        return (int)Math.round(this.maxZ - this.minZ);
    }

    @Override
    public String toString() {
        return String.format("Cuboid[world=%s, min=(%.1f,%.1f,%.1f), max=(%.1f,%.1f,%.1f)]", this.world.getName(), this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }
}

