/*
 * Decompiled with CFR 0.152.
 */
package com.skynex.mylands.model;

import com.skynex.mylands.model.LandPermission;
import java.util.EnumSet;
import java.util.Set;

public enum MemberRole {
    OWNER("Owner", "Full access to everything", EnumSet.allOf(LandPermission.class)),
    ADMIN("Admin", "Manage land and members", EnumSet.of(LandPermission.BUILD, new LandPermission[]{LandPermission.INTERACT, LandPermission.ANIMALS, LandPermission.CROPS, LandPermission.CONTAINERS, LandPermission.REDSTONE, LandPermission.INVITE, LandPermission.KICK, LandPermission.MANAGE_GRADES, LandPermission.TELEPORT, LandPermission.SET_HOME, LandPermission.SETTINGS, LandPermission.UPGRADE})),
    MEMBER("Member", "Build and interact", EnumSet.of(LandPermission.BUILD, new LandPermission[]{LandPermission.INTERACT, LandPermission.ANIMALS, LandPermission.CROPS, LandPermission.CONTAINERS, LandPermission.TELEPORT})),
    GUEST("Guest", "Basic access only", EnumSet.of(LandPermission.INTERACT, LandPermission.TELEPORT)),
    CUSTOM("Custom", "Custom permissions", EnumSet.noneOf(LandPermission.class));

    private final String displayName;
    private final String description;
    private final Set<LandPermission> defaultPermissions;

    private MemberRole(String displayName, String description, Set<LandPermission> defaultPermissions) {
        this.displayName = displayName;
        this.description = description;
        this.defaultPermissions = defaultPermissions;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public Set<LandPermission> getDefaultPermissions() {
        return EnumSet.copyOf(this.defaultPermissions);
    }

    public boolean hasPermission(LandPermission permission) {
        return this.defaultPermissions.contains((Object)permission);
    }
}

