/*
 * Decompiled with CFR 0.152.
 */
package com.skynex.mylands.service;

import com.skynex.mylands.util.PluginLogger;
import java.util.concurrent.CompletableFuture;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.jetbrains.annotations.NotNull;

public class EconomyService {
    private final Economy economy;
    private final boolean enabled;

    public EconomyService(@NotNull Plugin plugin, boolean enabled) {
        this.enabled = enabled;
        if (enabled) {
            RegisteredServiceProvider rsp = plugin.getServer().getServicesManager().getRegistration(Economy.class);
            if (rsp == null) {
                PluginLogger.warn("Vault economy not found, economy features will be disabled", new Object[0]);
                this.economy = null;
            } else {
                this.economy = (Economy)rsp.getProvider();
                PluginLogger.info("Economy system initialized with {}", this.economy.getName());
            }
        } else {
            this.economy = null;
            PluginLogger.info("Economy system disabled in configuration", new Object[0]);
        }
    }

    public boolean isEnabled() {
        return this.enabled && this.economy != null;
    }

    public CompletableFuture<Boolean> has(@NotNull OfflinePlayer player, double amount) {
        if (!this.isEnabled()) {
            return CompletableFuture.completedFuture(true);
        }
        return CompletableFuture.supplyAsync(() -> this.economy.has(player, amount));
    }

    public CompletableFuture<Double> getBalance(@NotNull OfflinePlayer player) {
        if (!this.isEnabled()) {
            return CompletableFuture.completedFuture(0.0);
        }
        return CompletableFuture.supplyAsync(() -> this.economy.getBalance(player));
    }

    public CompletableFuture<Boolean> withdraw(@NotNull OfflinePlayer player, double amount) {
        if (!this.isEnabled()) {
            return CompletableFuture.completedFuture(true);
        }
        return CompletableFuture.supplyAsync(() -> {
            if (!this.economy.has(player, amount)) {
                return false;
            }
            EconomyResponse response = this.economy.withdrawPlayer(player, amount);
            if (response.transactionSuccess()) {
                PluginLogger.debug("Withdrew {} from player {}", amount, player.getName());
                return true;
            }
            PluginLogger.warn("Failed to withdraw {} from player {}: {}", amount, player.getName(), response.errorMessage);
            return false;
        });
    }

    public CompletableFuture<Boolean> deposit(@NotNull OfflinePlayer player, double amount) {
        if (!this.isEnabled()) {
            return CompletableFuture.completedFuture(true);
        }
        return CompletableFuture.supplyAsync(() -> {
            EconomyResponse response = this.economy.depositPlayer(player, amount);
            if (response.transactionSuccess()) {
                PluginLogger.debug("Deposited {} to player {}", amount, player.getName());
                return true;
            }
            PluginLogger.warn("Failed to deposit {} to player {}: {}", amount, player.getName(), response.errorMessage);
            return false;
        });
    }

    public String format(double amount) {
        if (!this.isEnabled()) {
            return String.format("%.2f", amount);
        }
        return this.economy.format(amount);
    }

    public String getCurrencyName() {
        if (!this.isEnabled()) {
            return "coins";
        }
        return this.economy.currencyNameSingular();
    }

    public String getCurrencyNamePlural() {
        if (!this.isEnabled()) {
            return "coins";
        }
        return this.economy.currencyNamePlural();
    }
}

