/*
 * Decompiled with CFR 0.152.
 */
package com.skynex.mylands.service;

import com.skynex.mylands.model.Grade;
import com.skynex.mylands.model.LandMember;
import com.skynex.mylands.model.LandPermission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradeService {
    private final Map<UUID, Map<String, Grade>> grades = new ConcurrentHashMap<UUID, Map<String, Grade>>();
    private final Map<UUID, Map<UUID, LandMember>> members = new ConcurrentHashMap<UUID, Map<UUID, LandMember>>();
    private final int maxGradesPerLand;

    public GradeService(int maxGradesPerLand) {
        this.maxGradesPerLand = maxGradesPerLand;
    }

    public boolean createGrade(@NotNull Grade grade) {
        Map landGrades = this.grades.computeIfAbsent(grade.landOwnerId(), k -> new ConcurrentHashMap());
        if (landGrades.size() >= this.maxGradesPerLand) {
            return false;
        }
        if (landGrades.containsKey(grade.id())) {
            return false;
        }
        landGrades.put(grade.id(), grade);
        return true;
    }

    public boolean updateGrade(@NotNull Grade grade) {
        Map<String, Grade> landGrades = this.grades.get(grade.landOwnerId());
        if (landGrades == null || !landGrades.containsKey(grade.id())) {
            return false;
        }
        landGrades.put(grade.id(), grade);
        return true;
    }

    public boolean deleteGrade(@NotNull UUID landOwnerId, @NotNull String gradeId) {
        Map<String, Grade> landGrades = this.grades.get(landOwnerId);
        if (landGrades == null) {
            return false;
        }
        Grade grade = landGrades.get(gradeId);
        if (grade == null || grade.isDefault()) {
            return false;
        }
        Map<UUID, LandMember> landMembers = this.members.get(landOwnerId);
        if (landMembers != null) {
            landMembers.values().stream().filter(member -> gradeId.equals(member.gradeId())).forEach(member -> {
                Grade defaultGrade = this.getDefaultGrade(landOwnerId);
                if (defaultGrade != null) {
                    this.assignGrade(landOwnerId, member.playerId(), defaultGrade.id());
                }
            });
        }
        landGrades.remove(gradeId);
        return true;
    }

    @Nullable
    public Grade getGrade(@NotNull UUID landOwnerId, @NotNull String gradeId) {
        Map<String, Grade> landGrades = this.grades.get(landOwnerId);
        return landGrades != null ? landGrades.get(gradeId) : null;
    }

    @NotNull
    public List<Grade> getGrades(@NotNull UUID landOwnerId) {
        Map<String, Grade> landGrades = this.grades.get(landOwnerId);
        if (landGrades == null) {
            return Collections.emptyList();
        }
        ArrayList<Grade> gradeList = new ArrayList<Grade>(landGrades.values());
        gradeList.sort(Comparator.comparingInt(Grade::priority).reversed());
        return gradeList;
    }

    @Nullable
    public Grade getDefaultGrade(@NotNull UUID landOwnerId) {
        Map<String, Grade> landGrades = this.grades.get(landOwnerId);
        if (landGrades == null) {
            return null;
        }
        return landGrades.values().stream().filter(Grade::isDefault).findFirst().orElse(null);
    }

    public boolean assignGrade(@NotNull UUID landOwnerId, @NotNull UUID playerId, @NotNull String gradeId) {
        Grade grade = this.getGrade(landOwnerId, gradeId);
        if (grade == null) {
            return false;
        }
        Map landMembers = this.members.computeIfAbsent(landOwnerId, k -> new ConcurrentHashMap());
        LandMember existingMember = (LandMember)landMembers.get(playerId);
        LandMember newMember = new LandMember(playerId, landOwnerId, gradeId, existingMember != null ? existingMember.joinedAt() : System.currentTimeMillis());
        landMembers.put(playerId, newMember);
        return true;
    }

    @Nullable
    public Grade getMemberGrade(@NotNull UUID landOwnerId, @NotNull UUID playerId) {
        Map<UUID, LandMember> landMembers = this.members.get(landOwnerId);
        if (landMembers == null) {
            return null;
        }
        LandMember member = landMembers.get(playerId);
        if (member == null || member.gradeId() == null) {
            return this.getDefaultGrade(landOwnerId);
        }
        return this.getGrade(landOwnerId, member.gradeId());
    }

    public boolean hasPermission(@NotNull UUID landOwnerId, @NotNull UUID playerId, @NotNull LandPermission permission) {
        if (landOwnerId.equals(playerId)) {
            return true;
        }
        Grade grade = this.getMemberGrade(landOwnerId, playerId);
        return grade != null && grade.hasPermission(permission);
    }

    @NotNull
    public List<LandMember> getMembers(@NotNull UUID landOwnerId) {
        Map<UUID, LandMember> landMembers = this.members.get(landOwnerId);
        return landMembers != null ? new ArrayList<LandMember>(landMembers.values()) : Collections.emptyList();
    }

    public boolean removeMember(@NotNull UUID landOwnerId, @NotNull UUID playerId) {
        Map<UUID, LandMember> landMembers = this.members.get(landOwnerId);
        if (landMembers == null) {
            return false;
        }
        return landMembers.remove(playerId) != null;
    }

    public boolean addMember(@NotNull UUID landOwnerId, @NotNull UUID playerId) {
        Grade defaultGrade = this.getDefaultGrade(landOwnerId);
        if (defaultGrade == null) {
            return false;
        }
        return this.assignGrade(landOwnerId, playerId, defaultGrade.id());
    }

    public void initializeDefaultGrades(@NotNull UUID landOwnerId) {
        Grade memberGrade = new Grade("member", landOwnerId, "Member", "\u00a77", "PLAYER_HEAD", 1, Set.of(LandPermission.BUILD, LandPermission.INTERACT, LandPermission.ANIMALS, LandPermission.CROPS, LandPermission.TELEPORT), true);
        Grade modGrade = new Grade("moderator", landOwnerId, "Moderator", "\u00a7b", "DIAMOND_SWORD", 5, Set.of(LandPermission.BUILD, LandPermission.INTERACT, LandPermission.ANIMALS, LandPermission.CROPS, LandPermission.CONTAINERS, LandPermission.REDSTONE, LandPermission.INVITE, LandPermission.KICK, LandPermission.TELEPORT), false);
        Grade adminGrade = new Grade("admin", landOwnerId, "Admin", "\u00a7c", "NETHER_STAR", 8, Set.of(LandPermission.values()), false);
        this.createGrade(memberGrade);
        this.createGrade(modGrade);
        this.createGrade(adminGrade);
    }
}

