/*
 * Decompiled with CFR 0.152.
 */
package com.skynex.mylands.util;

import com.skynex.mylands.model.Cuboid;
import com.skynex.mylands.util.PluginLogger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;

public class ZoneVisualizer {
    private final Plugin plugin;
    private final Map<Location, BlockData> temporaryBlocks = new ConcurrentHashMap<Location, BlockData>();
    private BukkitTask cleanupTask;

    public ZoneVisualizer(@NotNull Plugin plugin) {
        this.plugin = plugin;
        this.startCleanupTask();
    }

    private void startCleanupTask() {
        this.cleanupTask = new BukkitRunnable(){

            public void run() {
                ZoneVisualizer.this.cleanupExpiredBlocks();
            }
        }.runTaskTimer(this.plugin, 20L, 20L);
    }

    private void cleanupExpiredBlocks() {
        long currentTime = System.currentTimeMillis();
        ArrayList<Location> toRemove = new ArrayList<Location>();
        for (Map.Entry<Location, BlockData> entry : this.temporaryBlocks.entrySet()) {
            Location loc = entry.getKey();
            BlockData data = entry.getValue();
            if (currentTime < data.expirationTime) continue;
            if (loc.getWorld() != null && loc.getWorld().isChunkLoaded(loc.getBlockX() >> 4, loc.getBlockZ() >> 4)) {
                loc.getBlock().setType(data.originalMaterial);
            }
            toRemove.add(loc);
        }
        toRemove.forEach(this.temporaryBlocks::remove);
        if (!toRemove.isEmpty()) {
            PluginLogger.debug("Cleaned up {} expired temporary blocks", toRemove.size());
        }
    }

    public void shutdown() {
        if (this.cleanupTask != null) {
            this.cleanupTask.cancel();
        }
        for (Map.Entry<Location, BlockData> entry : this.temporaryBlocks.entrySet()) {
            Location loc = entry.getKey();
            BlockData data = entry.getValue();
            if (loc.getWorld() == null || !loc.getWorld().isChunkLoaded(loc.getBlockX() >> 4, loc.getBlockZ() >> 4)) continue;
            loc.getBlock().setType(data.originalMaterial);
        }
        this.temporaryBlocks.clear();
        PluginLogger.info("ZoneVisualizer shutdown - all temporary blocks restored", new Object[0]);
    }

    public void displayWithParticles(final @NotNull Player player, final @NotNull Cuboid cuboid, final @NotNull Particle particle, final int durationSeconds) {
        new BukkitRunnable(this){
            int ticks = 0;
            final int duration = durationSeconds * 20;
            final /* synthetic */ ZoneVisualizer this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                if (this.ticks >= this.duration) {
                    this.cancel();
                    return;
                }
                if (this.ticks % 5 == 0) {
                    this.this$0.spawnParticles(player, cuboid, particle);
                }
                ++this.ticks;
            }
        }.runTaskTimer(this.plugin, 0L, 1L);
    }

    public void displayWithBlocks(@NotNull Player player, @NotNull Cuboid cuboid, @NotNull Material material, int durationSeconds) {
        final List<Location> borderLocations = this.getBorderLocations(cuboid);
        long expirationTime = System.currentTimeMillis() + (long)durationSeconds * 1000L;
        Bukkit.getScheduler().runTask(this.plugin, () -> {
            for (Location loc : borderLocations) {
                if (!loc.getWorld().isChunkLoaded(loc.getBlockX() >> 4, loc.getBlockZ() >> 4)) continue;
                if (this.temporaryBlocks.containsKey(loc)) {
                    BlockData oldData = this.temporaryBlocks.get(loc);
                    loc.getBlock().setType(oldData.originalMaterial);
                }
                Material originalMaterial = loc.getBlock().getType();
                loc.getBlock().setType(material);
                this.temporaryBlocks.put(loc.clone(), new BlockData(originalMaterial, expirationTime));
            }
            PluginLogger.debug("Placed {} temporary blocks (expires in {}s)", borderLocations.size(), durationSeconds);
            new BukkitRunnable(this){
                final /* synthetic */ ZoneVisualizer this$0;
                {
                    this.this$0 = this$0;
                }

                public void run() {
                    int restored = 0;
                    for (Location loc : borderLocations) {
                        if (!this.this$0.temporaryBlocks.containsKey(loc)) continue;
                        BlockData data = this.this$0.temporaryBlocks.remove(loc);
                        if (loc.getWorld() == null || !loc.getWorld().isChunkLoaded(loc.getBlockX() >> 4, loc.getBlockZ() >> 4)) continue;
                        loc.getBlock().setType(data.originalMaterial);
                        ++restored;
                    }
                    if (restored > 0) {
                        PluginLogger.debug("Manual cleanup restored {} blocks", restored);
                    }
                }
            }.runTaskLater(this.plugin, (long)(durationSeconds + 1) * 20L);
        });
    }

    private void spawnParticles(@NotNull Player player, @NotNull Cuboid cuboid, @NotNull Particle particle) {
        double minX = cuboid.minX();
        double maxX = cuboid.maxX();
        double minY = cuboid.minY();
        double maxY = cuboid.maxY();
        double minZ = cuboid.minZ();
        double maxZ = cuboid.maxZ();
        double spacing = 0.5;
        this.drawLine(player, particle, minX, minY, minZ, maxX, minY, minZ, spacing);
        this.drawLine(player, particle, minX, minY, maxZ, maxX, minY, maxZ, spacing);
        this.drawLine(player, particle, minX, minY, minZ, minX, minY, maxZ, spacing);
        this.drawLine(player, particle, maxX, minY, minZ, maxX, minY, maxZ, spacing);
        this.drawLine(player, particle, minX, maxY, minZ, maxX, maxY, minZ, spacing);
        this.drawLine(player, particle, minX, maxY, maxZ, maxX, maxY, maxZ, spacing);
        this.drawLine(player, particle, minX, maxY, minZ, minX, maxY, maxZ, spacing);
        this.drawLine(player, particle, maxX, maxY, minZ, maxX, maxY, maxZ, spacing);
        this.drawLine(player, particle, minX, minY, minZ, minX, maxY, minZ, spacing);
        this.drawLine(player, particle, maxX, minY, minZ, maxX, maxY, minZ, spacing);
        this.drawLine(player, particle, minX, minY, maxZ, minX, maxY, maxZ, spacing);
        this.drawLine(player, particle, maxX, minY, maxZ, maxX, maxY, maxZ, spacing);
    }

    private void drawLine(@NotNull Player player, @NotNull Particle particle, double x1, double y1, double z1, double x2, double y2, double z2, double spacing) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        double dz = z2 - z1;
        double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
        int points = (int)Math.ceil(distance / spacing);
        for (int i = 0; i <= points; ++i) {
            double t2 = (double)i / (double)points;
            double x = x1 + dx * t2;
            double y = y1 + dy * t2;
            double z = z1 + dz * t2;
            player.spawnParticle(particle, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private List<Location> getBorderLocations(@NotNull Cuboid cuboid) {
        double z;
        double x;
        ArrayList<Location> locations = new ArrayList<Location>();
        double minX = cuboid.minX();
        double maxX = cuboid.maxX();
        double minY = cuboid.minY();
        double maxY = cuboid.maxY();
        double minZ = cuboid.minZ();
        double maxZ = cuboid.maxZ();
        for (x = minX; x <= maxX; x += 1.0) {
            locations.add(new Location(cuboid.world(), x, minY, minZ));
            locations.add(new Location(cuboid.world(), x, minY, maxZ));
        }
        for (z = minZ; z <= maxZ; z += 1.0) {
            locations.add(new Location(cuboid.world(), minX, minY, z));
            locations.add(new Location(cuboid.world(), maxX, minY, z));
        }
        for (x = minX; x <= maxX; x += 1.0) {
            locations.add(new Location(cuboid.world(), x, maxY, minZ));
            locations.add(new Location(cuboid.world(), x, maxY, maxZ));
        }
        for (z = minZ; z <= maxZ; z += 1.0) {
            locations.add(new Location(cuboid.world(), minX, maxY, z));
            locations.add(new Location(cuboid.world(), maxX, maxY, z));
        }
        for (double y = minY; y <= maxY; y += 5.0) {
            locations.add(new Location(cuboid.world(), minX, y, minZ));
            locations.add(new Location(cuboid.world(), maxX, y, minZ));
            locations.add(new Location(cuboid.world(), minX, y, maxZ));
            locations.add(new Location(cuboid.world(), maxX, y, maxZ));
        }
        return locations;
    }

    private static class BlockData {
        final Material originalMaterial;
        final long expirationTime;

        BlockData(Material originalMaterial, long expirationTime) {
            this.originalMaterial = originalMaterial;
            this.expirationTime = expirationTime;
        }
    }
}

