/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.mycommands;

import fr.skynex.mycommands.commands.CommandRegistry;
import fr.skynex.mycommands.integrations.MyCommandsExpansion;
import fr.skynex.mycommands.integrations.MyPlayerProvider;
import fr.skynex.mycommands.integrations.VaultIntegration;
import fr.skynex.mycommands.libs.bstats.bukkit.Metrics;
import fr.skynex.mycommands.listeners.JoinQuitListener;
import fr.skynex.mycommands.listeners.PlayerListener;
import fr.skynex.mycommands.managers.AFKManager;
import fr.skynex.mycommands.managers.CacheManager;
import fr.skynex.mycommands.managers.ConfirmationManager;
import fr.skynex.mycommands.managers.CooldownManager;
import fr.skynex.mycommands.managers.DataManager;
import fr.skynex.mycommands.managers.EconomyManager;
import fr.skynex.mycommands.managers.EffectsManager;
import fr.skynex.mycommands.managers.GUIConfig;
import fr.skynex.mycommands.managers.JailManager;
import fr.skynex.mycommands.managers.MessageManager;
import fr.skynex.mycommands.managers.SoundManager;
import fr.skynex.mycommands.managers.StatisticsManager;
import fr.skynex.mycommands.storage.SQLOptimizer;
import fr.skynex.mycommands.utils.AsyncOperations;
import fr.skynex.mycore.api.MyCoreAPI;
import fr.skynex.mycore.api.player.PlayerProvider;
import fr.skynex.mycore.api.provider.Provider;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class MyCommands
extends JavaPlugin {
    private MessageManager messageManager;
    private DataManager dataManager;
    private CooldownManager cooldownManager;
    private StatisticsManager statisticsManager;
    private EconomyManager economyManager;
    private GUIConfig guiConfig;
    private EffectsManager effectsManager;
    private SoundManager soundManager;
    private ConfirmationManager confirmationManager;
    private AFKManager afkManager;
    private JailManager jailManager;
    private CacheManager cacheManager;
    private AsyncOperations asyncOperations;
    private SQLOptimizer sqlOptimizer;
    private VaultIntegration vaultIntegration;

    public void onEnable() {
        long startTime = System.currentTimeMillis();
        try {
            this.saveDefaultConfig();
            this.initializeManagers();
            this.initializeUXManagers();
            this.initializeIntegrations();
            this.registerListeners();
            this.registerCommands();
            this.registerPlaceholders();
            this.initializeMetrics();
            this.registerWithMyCore();
            long duration = System.currentTimeMillis() - startTime;
            this.getLogger().info("MyCommands v" + this.getVersion() + " enabled! (" + duration + "ms)");
        }
        catch (Exception e) {
            this.getLogger().severe("FATAL: " + e.getMessage());
            e.printStackTrace();
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
    }

    private void initializeManagers() {
        try {
            this.messageManager = new MessageManager(this);
            this.dataManager = new DataManager(this);
            this.cooldownManager = new CooldownManager(this);
            if (this.getConfig().getBoolean("statistics.enabled", true)) {
                this.statisticsManager = new StatisticsManager(this);
            }
            this.guiConfig = new GUIConfig(this);
            if (this.getConfig().getBoolean("cache.enabled", false)) {
                this.cacheManager = new CacheManager(this);
            }
            this.asyncOperations = new AsyncOperations(this);
            if (this.dataManager.getStorageType().equalsIgnoreCase("mysql") && this.getConfig().getBoolean("database.batch-enabled", true)) {
                this.sqlOptimizer = new SQLOptimizer(this);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Manager initialization failed", e);
        }
    }

    private void initializeUXManagers() {
        try {
            if (this.getConfig().getBoolean("effects.enabled", true)) {
                this.effectsManager = new EffectsManager(this);
            }
            if (this.getConfig().getBoolean("sounds.enabled", true)) {
                this.soundManager = new SoundManager(this);
            }
            if (this.getConfig().getBoolean("afk.enabled", true)) {
                this.afkManager = new AFKManager(this);
            }
            if (this.getConfig().getBoolean("jail.enabled", true)) {
                this.jailManager = new JailManager(this);
            }
            if (this.getConfig().getBoolean("confirmations.enabled", true)) {
                this.confirmationManager = new ConfirmationManager(this);
            }
        }
        catch (Exception e) {
            this.debug("UX managers init failed: " + e.getMessage());
        }
    }

    private void initializeIntegrations() {
        if (this.getServer().getPluginManager().getPlugin("Vault") != null) {
            try {
                this.vaultIntegration = new VaultIntegration(this);
                if (this.vaultIntegration.setupEconomy()) {
                    this.economyManager = new EconomyManager(this, this.vaultIntegration);
                }
            }
            catch (Exception e) {
                this.debug("Vault integration failed: " + e.getMessage());
            }
        }
    }

    private void registerListeners() {
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new JoinQuitListener(this), (Plugin)this);
    }

    private void registerCommands() {
        CommandRegistry registry = new CommandRegistry(this);
        registry.registerAll();
        if (this.confirmationManager != null) {
            this.registerConfirmationCommands();
        }
    }

    private void registerConfirmationCommands() {
        if (this.getCommand("confirm") != null) {
            this.getCommand("confirm").setExecutor((sender, cmd, label, args) -> {
                if (!(sender instanceof Player)) {
                    sender.sendMessage(this.messageManager.getMessage("general.command-player-only"));
                    return true;
                }
                return this.confirmationManager.confirm((Player)sender);
            });
        }
        if (this.getCommand("cancel") != null) {
            this.getCommand("cancel").setExecutor((sender, cmd, label, args) -> {
                if (!(sender instanceof Player)) {
                    sender.sendMessage(this.messageManager.getMessage("general.command-player-only"));
                    return true;
                }
                return this.confirmationManager.cancel((Player)sender);
            });
        }
    }

    private void registerPlaceholders() {
        if (this.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null) {
            try {
                new MyCommandsExpansion(this).register();
            }
            catch (Exception e) {
                this.debug("PlaceholderAPI registration failed: " + e.getMessage());
            }
        }
    }

    private void initializeMetrics() {
        if (this.getConfig().getBoolean("metrics.enabled", true)) {
            try {
                new Metrics((Plugin)this, 28736);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void onDisable() {
        try {
            this.unregisterFromMyCore();
            for (Player player : this.getServer().getOnlinePlayers()) {
                if (this.dataManager == null) continue;
                this.dataManager.savePlayerData(player.getUniqueId());
            }
            if (this.confirmationManager != null) {
                this.confirmationManager.shutdown();
            }
            if (this.afkManager != null) {
                this.afkManager.shutdown();
            }
            if (this.jailManager != null) {
                this.jailManager.shutdown();
            }
            if (this.dataManager != null) {
                this.dataManager.shutdown();
            }
            if (this.cooldownManager != null) {
                this.cooldownManager.shutdown();
            }
            if (this.statisticsManager != null) {
                this.statisticsManager.shutdown();
            }
            if (this.asyncOperations != null) {
                this.asyncOperations.shutdown();
            }
            if (this.cacheManager != null) {
                this.cacheManager.shutdown();
            }
            this.getLogger().info("MyCommands disabled.");
        }
        catch (Exception e) {
            this.getLogger().severe("Shutdown error: " + e.getMessage());
        }
    }

    public MessageManager getMessageManager() {
        return this.messageManager;
    }

    public DataManager getDataManager() {
        return this.dataManager;
    }

    public CooldownManager getCooldownManager() {
        return this.cooldownManager;
    }

    public StatisticsManager getStatisticsManager() {
        return this.statisticsManager;
    }

    public EconomyManager getEconomyManager() {
        return this.economyManager;
    }

    public GUIConfig getGUIConfig() {
        return this.guiConfig;
    }

    public VaultIntegration getVaultIntegration() {
        return this.vaultIntegration;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public AsyncOperations getAsyncOperations() {
        return this.asyncOperations;
    }

    public SQLOptimizer getSQLOptimizer() {
        return this.sqlOptimizer;
    }

    public EffectsManager getEffectsManager() {
        return this.effectsManager;
    }

    public SoundManager getSoundManager() {
        return this.soundManager;
    }

    public ConfirmationManager getConfirmationManager() {
        return this.confirmationManager;
    }

    public AFKManager getAFKManager() {
        return this.afkManager;
    }

    public JailManager getJailManager() {
        return this.jailManager;
    }

    public void reloadPlugin() {
        try {
            this.reloadConfig();
            if (this.messageManager != null) {
                this.messageManager.reload();
            }
            if (this.dataManager != null) {
                this.dataManager.reload();
            }
            if (this.cooldownManager != null) {
                this.cooldownManager.reload();
            }
            if (this.economyManager != null) {
                this.economyManager.reload();
            }
            if (this.cacheManager != null) {
                this.cacheManager.reload();
            }
            if (this.effectsManager != null) {
                this.effectsManager.reload();
            }
            if (this.soundManager != null) {
                this.soundManager.reload();
            }
            this.getLogger().info("Configuration reloaded.");
        }
        catch (Exception e) {
            this.getLogger().severe("Reload failed: " + e.getMessage());
            throw new RuntimeException("Reload failed", e);
        }
    }

    public boolean isDebugMode() {
        return this.getConfig().getBoolean("debug.enabled", false);
    }

    public void debug(String message) {
        if (this.isDebugMode()) {
            this.getLogger().info("[DEBUG] " + message);
        }
    }

    public void debug(String message, Throwable throwable) {
        if (this.isDebugMode()) {
            this.getLogger().warning("[DEBUG] " + message);
            throwable.printStackTrace();
        }
    }

    public String getVersion() {
        return this.getDescription().getVersion();
    }

    public String getAuthor() {
        return this.getDescription().getAuthors().isEmpty() ? "SkyNex" : (String)this.getDescription().getAuthors().get(0);
    }

    public boolean areStatisticsEnabled() {
        return this.statisticsManager != null && this.getConfig().getBoolean("statistics.enabled", true);
    }

    public boolean isEconomyEnabled() {
        return this.economyManager != null && this.economyManager.isEnabled();
    }

    public boolean isCacheEnabled() {
        return this.cacheManager != null && this.getConfig().getBoolean("cache.enabled", false);
    }

    public boolean isEffectsEnabled() {
        return this.effectsManager != null && this.getConfig().getBoolean("effects.enabled", true);
    }

    public boolean isSoundsEnabled() {
        return this.soundManager != null && this.getConfig().getBoolean("sounds.enabled", true);
    }

    public boolean isConfirmationsEnabled() {
        return this.confirmationManager != null && this.getConfig().getBoolean("confirmations.enabled", true);
    }

    public String getStorageType() {
        return this.dataManager != null ? this.dataManager.getStorageType() : "unknown";
    }

    public boolean isVaultAvailable() {
        return this.vaultIntegration != null && this.vaultIntegration.isEconomyAvailable();
    }

    public boolean isPlaceholderAPIAvailable() {
        return this.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null;
    }

    private void registerWithMyCore() {
        if (this.getServer().getPluginManager().getPlugin("MyCore") != null) {
            try {
                MyCoreAPI.register(PlayerProvider.class, (Provider)new MyPlayerProvider(this), (JavaPlugin)this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void unregisterFromMyCore() {
        if (this.getServer().getPluginManager().getPlugin("MyCore") != null) {
            try {
                MyCoreAPI.unregisterAll((JavaPlugin)this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

