/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.mycommands.commands;

import fr.skynex.mycommands.MyCommands;
import fr.skynex.mycommands.commands.BaseCommand;
import fr.skynex.mycommands.managers.StatisticsManager;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class BackCommand
extends BaseCommand {
    public BackCommand(MyCommands plugin) {
        super(plugin);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Player player = this.getPlayerWithPermission(sender, "mycommands.back");
        if (player == null) {
            return true;
        }
        Location lastLocation = this.dataManager.getLastLocation(player.getUniqueId());
        if (lastLocation == null || lastLocation.getWorld() == null) {
            this.msg.sendMessage((CommandSender)player, "teleport.back.no-location");
            return true;
        }
        this.startTeleportDelay(player, "back", () -> {
            if (lastLocation.getWorld() == null) {
                this.msg.sendMessage((CommandSender)player, "teleport.back.no-location");
                return;
            }
            player.teleport(lastLocation);
            this.msg.sendMessage((CommandSender)player, "teleport.back.teleported");
            if (this.statsManager != null) {
                this.statsManager.incrementTeleports(player, StatisticsManager.TeleportType.BACK);
            }
        });
        return true;
    }
}

