/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.mycommands.commands;

import fr.skynex.mycommands.MyCommands;
import fr.skynex.mycommands.commands.BaseCommand;
import fr.skynex.mycommands.exceptions.ValidationException;
import fr.skynex.mycommands.managers.SoundManager;
import fr.skynex.mycommands.managers.StatisticsManager;
import fr.skynex.mycommands.utils.MessageFormatter;
import fr.skynex.mycommands.utils.Validator;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class HomeCommand
extends BaseCommand {
    public HomeCommand(MyCommands plugin) {
        super(plugin);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Player player = this.getPlayerWithPermission(sender, "mycommands.home");
        if (player == null) {
            return true;
        }
        if (args.length < 1) {
            this.sendUsage(sender, "/home <nom>");
            this.playError(player);
            return true;
        }
        String homeName = args[0];
        try {
            Validator.validateHomeName(homeName);
        }
        catch (ValidationException e) {
            this.msg.sendMessage((CommandSender)player, e.getMessageKey());
            this.playError(player);
            return true;
        }
        Location homeLocation = this.dataManager.getHome(player.getUniqueId(), homeName);
        if (homeLocation == null || homeLocation.getWorld() == null) {
            this.msg.sendMessage((CommandSender)player, "teleport.home.not-found", this.msg.placeholder("home", homeName));
            this.playError(player);
            return true;
        }
        try {
            Validator.validateLocation(homeLocation);
        }
        catch (ValidationException e) {
            this.msg.sendMessage((CommandSender)player, e.getMessageKey());
            player.sendMessage(this.msg.colorize("&7&oVous pouvez supprimer ce home avec : &e/delhome " + homeName));
            this.playError(player);
            return true;
        }
        if (this.plugin.getConfig().getBoolean("teleport.preview.enabled", true) && this.plugin.getConfig().getBoolean("teleport.preview.show-particles", true)) {
            this.playPreviewEffect(homeLocation);
        }
        this.startTeleportDelay(player, "home", () -> {
            this.playDepartureEffect(player.getLocation());
            this.playSuccess(player, SoundManager.SoundType.TELEPORT_START);
            player.teleport(homeLocation);
            this.playArrivalEffect(homeLocation);
            this.playSuccess(player, SoundManager.SoundType.TELEPORT_ARRIVE);
            this.msg.sendMessage((CommandSender)player, "teleport.home.teleported", this.msg.placeholder("home", homeName));
            if (this.plugin.getConfig().getBoolean("messages.format.action-bar.enabled", true)) {
                String world = homeLocation.getWorld().getName();
                MessageFormatter.sendActionBar(player, this.msg.colorize("&a\u2713 T\u00e9l\u00e9port\u00e9 \u00e0 &e" + homeName + " &7(" + world + ")"));
            }
            if (this.statsManager != null) {
                this.statsManager.incrementTeleports(player, StatisticsManager.TeleportType.HOME);
            }
        });
        int delay = this.plugin.getConfig().getInt("teleport-delay.delay.home", 3);
        if (delay > 0 && this.plugin.getConfig().getBoolean("effects.particles.teleport.countdown", true)) {
            this.playCountdownEffect(player, delay);
        }
        return true;
    }
}

