/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.mycommands.commands;

import fr.skynex.mycommands.MyCommands;
import fr.skynex.mycommands.commands.BaseCommand;
import fr.skynex.mycommands.managers.JailManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class JailCommand
extends BaseCommand
implements TabCompleter {
    public JailCommand(MyCommands plugin) {
        super(plugin);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!this.checkPermission(sender, "mycommands.jail")) {
            return true;
        }
        if (args.length < 3) {
            this.sendUsage(sender, "/jail <joueur> <prison> <dur\u00e9e> [raison]");
            sender.sendMessage(this.msg.colorize("&7Dur\u00e9e: 0 = permanent, ou temps en secondes/minutes/heures"));
            sender.sendMessage(this.msg.colorize("&7Exemples: 60s, 30m, 2h, 1d"));
            return true;
        }
        Player target = this.plugin.getServer().getPlayer(args[0]);
        if (target == null) {
            this.msg.sendMessage(sender, "general.player-not-found");
            return true;
        }
        String jailName = args[1];
        JailManager jailManager = this.plugin.getJailManager();
        if (!jailManager.getJails().containsKey(jailName)) {
            this.msg.sendMessage(sender, "commands.jail.not-found", this.msg.placeholder("jail", jailName));
            return true;
        }
        long durationSeconds = this.parseDuration(args[2]);
        if (durationSeconds == -1L) {
            this.msg.sendMessage(sender, "commands.jail.invalid-duration");
            return true;
        }
        String reason = args.length > 3 ? String.join((CharSequence)" ", Arrays.copyOfRange(args, 3, args.length)) : "Aucune raison";
        jailManager.jailPlayer(target, jailName, durationSeconds, reason);
        if (durationSeconds == 0L) {
            this.msg.sendMessage(sender, "commands.jail.jailed-permanent", this.msg.placeholder("player", target.getName()), this.msg.placeholder("jail", jailName), this.msg.placeholder("reason", reason));
            this.msg.sendMessage((CommandSender)target, "commands.jail.you-jailed-permanent", this.msg.placeholder("jail", jailName), this.msg.placeholder("reason", reason));
        } else {
            this.msg.sendMessage(sender, "commands.jail.jailed", this.msg.placeholder("player", target.getName()), this.msg.placeholder("jail", jailName), this.msg.placeholder("duration", this.formatDuration(durationSeconds)), this.msg.placeholder("reason", reason));
            this.msg.sendMessage((CommandSender)target, "commands.jail.you-jailed", this.msg.placeholder("jail", jailName), this.msg.placeholder("duration", this.formatDuration(durationSeconds)), this.msg.placeholder("reason", reason));
        }
        return true;
    }

    private long parseDuration(String input) {
        if (input.equals("0")) {
            return 0L;
        }
        try {
            if (input.endsWith("s")) {
                return Long.parseLong(input.substring(0, input.length() - 1));
            }
            if (input.endsWith("m")) {
                return Long.parseLong(input.substring(0, input.length() - 1)) * 60L;
            }
            if (input.endsWith("h")) {
                return Long.parseLong(input.substring(0, input.length() - 1)) * 3600L;
            }
            if (input.endsWith("d")) {
                return Long.parseLong(input.substring(0, input.length() - 1)) * 86400L;
            }
            return Long.parseLong(input);
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    private String formatDuration(long seconds) {
        if (seconds < 60L) {
            return seconds + "s";
        }
        if (seconds < 3600L) {
            return seconds / 60L + "m";
        }
        if (seconds < 86400L) {
            return seconds / 3600L + "h";
        }
        return seconds / 86400L + "j";
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            return this.plugin.getServer().getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length == 2) {
            return this.plugin.getJailManager().getJails().keySet().stream().filter(name -> name.toLowerCase().startsWith(args[1].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length == 3) {
            return Arrays.asList("0", "60s", "30m", "1h", "2h", "1d", "7d");
        }
        return new ArrayList<String>();
    }
}

