/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.mycommands.commands;

import fr.skynex.mycommands.MyCommands;
import fr.skynex.mycommands.commands.BaseCommand;
import fr.skynex.mycommands.commands.ReloadCommand;
import java.util.Arrays;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public class MigrateCommand
extends BaseCommand {
    public MigrateCommand(MyCommands plugin) {
        super(plugin);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            sender.sendMessage(this.msg.colorize("&6&l\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501"));
            sender.sendMessage(this.msg.colorize("&e&lMyCommands &7v" + this.plugin.getDescription().getVersion()));
            sender.sendMessage(this.msg.colorize("&6&l\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501"));
            sender.sendMessage(this.msg.colorize("&7D\u00e9velopp\u00e9 par &eSkyNex"));
            sender.sendMessage(this.msg.colorize("&7Langue: &e" + this.plugin.getConfig().getString("language", "fr").toUpperCase()));
            sender.sendMessage(this.msg.colorize("&7Stockage: &e" + this.plugin.getDataManager().getStorageType().toUpperCase()));
            if (this.plugin.getEconomyManager() != null && this.plugin.getEconomyManager().isEnabled()) {
                sender.sendMessage(this.msg.colorize("&7\u00c9conomie: &aACTIV\u00c9E"));
            } else {
                sender.sendMessage(this.msg.colorize("&7\u00c9conomie: &cD\u00c9SACTIV\u00c9E"));
            }
            if (this.plugin.getConfig().getBoolean("statistics.enabled", true)) {
                sender.sendMessage(this.msg.colorize("&7Statistiques: &aACTIV\u00c9ES"));
            }
            sender.sendMessage("");
            sender.sendMessage(this.msg.colorize("&eCommandes disponibles:"));
            sender.sendMessage(this.msg.colorize("&7/mycommands reload &8- Recharger config"));
            sender.sendMessage(this.msg.colorize("&7/mycommands migrate &8- Migrer donn\u00e9es"));
            sender.sendMessage(this.msg.colorize("&6&l\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501"));
            return true;
        }
        if (args[0].equalsIgnoreCase("reload")) {
            return new ReloadCommand(this.plugin).onCommand(sender, command, label, Arrays.copyOfRange(args, 1, args.length));
        }
        if (args[0].equalsIgnoreCase("migrate")) {
            if (!this.checkPermission(sender, "mycommands.migrate")) {
                return true;
            }
            if (args.length < 2) {
                sender.sendMessage(this.msg.colorize("&c&lMigration Tool"));
                sender.sendMessage(this.msg.colorize("&7Utilisez:"));
                sender.sendMessage(this.msg.colorize("&e/mycommands migrate yaml2mysql &8- YAML \u2192 MySQL"));
                sender.sendMessage(this.msg.colorize("&e/mycommands migrate mysql2yaml &8- MySQL \u2192 YAML"));
                sender.sendMessage(this.msg.colorize("&e/mycommands migrate check &8- V\u00e9rifier compatibilit\u00e9"));
                sender.sendMessage(this.msg.colorize("&e/mycommands migrate auto &8- D\u00e9tection auto"));
                return true;
            }
            String type = args[1].toLowerCase();
            String currentType = this.plugin.getDataManager().getStorageType();
            switch (type) {
                case "check": {
                    sender.sendMessage(this.msg.colorize("&6&l\u00c9tat actuel:"));
                    sender.sendMessage(this.msg.colorize("&7Type de stockage: &e" + currentType.toUpperCase()));
                    if (currentType.equals("yaml")) {
                        sender.sendMessage(this.msg.colorize("&7Vous pouvez migrer vers: &eMYSQL"));
                        sender.sendMessage(this.msg.colorize("&7Commande: &e/mycommands migrate yaml2mysql"));
                        break;
                    }
                    sender.sendMessage(this.msg.colorize("&7Vous pouvez migrer vers: &eYAML"));
                    sender.sendMessage(this.msg.colorize("&7Commande: &e/mycommands migrate mysql2yaml"));
                    break;
                }
                case "yaml2mysql": {
                    if (currentType.equals("mysql")) {
                        this.msg.sendMessage(sender, "migrate.already-type");
                        return true;
                    }
                    sender.sendMessage(this.msg.colorize("&6Migration YAML \u2192 MySQL en cours..."));
                    if (this.plugin.getConfig().getBoolean("migration.backup-before-migrate", true)) {
                        sender.sendMessage(this.msg.colorize("&7Cr\u00e9ation backup..."));
                    }
                    try {
                        this.plugin.getDataManager().migrate("yaml", "mysql");
                        this.msg.sendMessage(sender, "migrate.success");
                        sender.sendMessage(this.msg.colorize("&aN'oubliez pas de changer 'storage.type' dans config.yml!"));
                    }
                    catch (Exception e) {
                        this.msg.sendMessage(sender, "migrate.error", this.msg.placeholder("error", e.getMessage()));
                    }
                    break;
                }
                case "mysql2yaml": {
                    if (currentType.equals("yaml")) {
                        this.msg.sendMessage(sender, "migrate.already-type");
                        return true;
                    }
                    sender.sendMessage(this.msg.colorize("&6Migration MySQL \u2192 YAML en cours..."));
                    if (this.plugin.getConfig().getBoolean("migration.backup-before-migrate", true)) {
                        sender.sendMessage(this.msg.colorize("&7Cr\u00e9ation backup..."));
                    }
                    try {
                        this.plugin.getDataManager().migrate("mysql", "yaml");
                        this.msg.sendMessage(sender, "migrate.success");
                        sender.sendMessage(this.msg.colorize("&aN'oubliez pas de changer 'storage.type' dans config.yml!"));
                    }
                    catch (Exception e) {
                        this.msg.sendMessage(sender, "migrate.error", this.msg.placeholder("error", e.getMessage()));
                    }
                    break;
                }
                case "auto": {
                    sender.sendMessage(this.msg.colorize("&6D\u00e9tection automatique..."));
                    String configType = this.plugin.getConfig().getString("storage.type", "yaml");
                    if (!configType.equals(currentType)) {
                        sender.sendMessage(this.msg.colorize("&eMigration automatique d\u00e9tect\u00e9e!"));
                        sender.sendMessage(this.msg.colorize("&7Config: &e" + configType.toUpperCase()));
                        sender.sendMessage(this.msg.colorize("&7Actuel: &e" + currentType.toUpperCase()));
                        sender.sendMessage(this.msg.colorize(""));
                        sender.sendMessage(this.msg.colorize("&eEx\u00e9cutez:"));
                        sender.sendMessage(this.msg.colorize("&a/mycommands migrate " + currentType + "2" + configType));
                        break;
                    }
                    sender.sendMessage(this.msg.colorize("&aAucune migration n\u00e9cessaire!"));
                    sender.sendMessage(this.msg.colorize("&7Stockage actuel: &e" + currentType.toUpperCase()));
                    break;
                }
                default: {
                    this.sendUsage(sender, "/mycommands migrate <yaml2mysql|mysql2yaml|check|auto>");
                }
            }
            return true;
        }
        sender.sendMessage(this.msg.colorize("&cSous-commande inconnue: " + args[0]));
        sender.sendMessage(this.msg.colorize("&7Utilisez: &e/mycommands &7pour voir les commandes"));
        return true;
    }
}

