/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.mycommands.commands;

import fr.skynex.mycommands.MyCommands;
import fr.skynex.mycommands.commands.BaseCommand;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class PTimeCommand
extends BaseCommand
implements TabCompleter {
    public PTimeCommand(MyCommands plugin) {
        super(plugin);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String timeArg;
        Player target;
        if (!this.checkPermission(sender, "mycommands.ptime")) {
            return true;
        }
        if (args.length < 1) {
            this.sendUsage(sender, "/ptime <day|night|noon|midnight|reset|ticks> [joueur]");
            return true;
        }
        if (args.length >= 2) {
            if (!this.checkPermission(sender, "mycommands.ptime.others")) {
                return true;
            }
            target = this.plugin.getServer().getPlayer(args[1]);
            if (target == null) {
                this.msg.sendMessage(sender, "general.player-not-found");
                return true;
            }
            timeArg = args[0];
        } else {
            target = this.getPlayer(sender);
            if (target == null) {
                return true;
            }
            timeArg = args[0];
        }
        if (timeArg.equalsIgnoreCase("reset")) {
            target.resetPlayerTime();
            this.msg.sendMessage(sender, "commands.ptime.reset", this.msg.placeholder("player", target.getName()));
        } else {
            long time = this.parseTime(timeArg);
            if (time == -1L) {
                this.sendUsage(sender, "/ptime <day|night|noon|midnight|reset|ticks> [joueur]");
                return true;
            }
            target.setPlayerTime(time, false);
            this.msg.sendMessage(sender, "commands.ptime.set", this.msg.placeholder("player", target.getName()), this.msg.placeholder("time", timeArg));
        }
        return true;
    }

    private long parseTime(String input) {
        switch (input.toLowerCase()) {
            case "day": {
                return 1000L;
            }
            case "noon": {
                return 6000L;
            }
            case "night": {
                return 13000L;
            }
            case "midnight": {
                return 18000L;
            }
        }
        try {
            return Long.parseLong(input);
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            List<String> times = Arrays.asList("day", "night", "noon", "midnight", "reset", "1000", "6000", "13000", "18000");
            return times.stream().filter(s -> s.toLowerCase().startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length == 2 && sender.hasPermission("mycommands.ptime.others")) {
            return this.plugin.getServer().getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(args[1].toLowerCase())).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }
}

