/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.mycommands.commands;

import fr.skynex.mycommands.MyCommands;
import fr.skynex.mycommands.commands.BaseCommand;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class RealnameCommand
extends BaseCommand
implements TabCompleter {
    public RealnameCommand(MyCommands plugin) {
        super(plugin);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Player player;
        if (!this.checkPermission(sender, "mycommands.realname")) {
            return true;
        }
        if (args.length < 1) {
            this.sendUsage(sender, "/realname <pseudo>");
            return true;
        }
        String nickname = args[0];
        Map<UUID, String> nicknames = this.dataManager.getAllNicknames();
        UUID foundUUID = null;
        for (Map.Entry<UUID, String> entry : nicknames.entrySet()) {
            if (!entry.getValue().equalsIgnoreCase(nickname)) continue;
            foundUUID = entry.getKey();
            break;
        }
        if (foundUUID == null) {
            player = this.plugin.getServer().getPlayer(nickname);
            if (player != null) {
                String nick = this.dataManager.getNickname(player.getUniqueId());
                if (nick != null) {
                    this.msg.sendMessage(sender, "commands.realname.has-nickname", this.msg.placeholder("realname", player.getName()), this.msg.placeholder("nickname", nick));
                } else {
                    this.msg.sendMessage(sender, "commands.realname.no-nickname", this.msg.placeholder("player", player.getName()));
                }
                return true;
            }
            this.msg.sendMessage(sender, "general.player-not-found");
            return true;
        }
        player = this.plugin.getServer().getPlayer(foundUUID);
        String realName = player != null ? player.getName() : Bukkit.getOfflinePlayer(foundUUID).getName();
        this.msg.sendMessage(sender, "commands.realname.found", this.msg.placeholder("nickname", nickname), this.msg.placeholder("realname", realName));
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            ArrayList<String> suggestions = new ArrayList<String>();
            suggestions.addAll(this.dataManager.getAllNicknames().values());
            suggestions.addAll(this.plugin.getServer().getOnlinePlayers().stream().map(Player::getName).collect(Collectors.toList()));
            return suggestions.stream().filter(name -> name.toLowerCase().startsWith(args[0].toLowerCase())).distinct().collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }
}

