/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.mycommands.commands;

import fr.skynex.mycommands.MyCommands;
import fr.skynex.mycommands.commands.BaseCommand;
import fr.skynex.mycommands.exceptions.ValidationException;
import fr.skynex.mycommands.managers.SoundManager;
import fr.skynex.mycommands.utils.MessageFormatter;
import fr.skynex.mycommands.utils.Validator;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SetWarpCommand
extends BaseCommand {
    public SetWarpCommand(MyCommands plugin) {
        super(plugin);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        boolean isUpdate;
        int currentCount;
        int maxWarps;
        Player player = this.getPlayerWithPermission(sender, "mycommands.setwarp");
        if (player == null) {
            return true;
        }
        if (!this.hasArg(args, 0)) {
            this.sendUsage(sender, "/setwarp <nom>");
            this.playError(player);
            return true;
        }
        String warpName = args[0];
        if (!this.dataManager.warpExists(warpName) && (maxWarps = this.plugin.getConfig().getInt("limits.max-warps", -1)) >= 0 && (currentCount = this.dataManager.getWarps().size()) >= maxWarps) {
            this.msg.sendMessage((CommandSender)player, "teleport.warp.limit-reached", this.msg.placeholder("limit", String.valueOf(maxWarps)));
            this.playError(player);
            return true;
        }
        try {
            Validator.validateWarpName(warpName);
        }
        catch (ValidationException e) {
            this.msg.sendMessage((CommandSender)player, e.getMessageKey());
            this.playError(player);
            return true;
        }
        Location location = player.getLocation();
        try {
            Validator.validateLocation(location);
        }
        catch (ValidationException e) {
            this.msg.sendMessage((CommandSender)player, e.getMessageKey());
            this.playError(player);
            return true;
        }
        if (this.plugin.getConfig().getBoolean("warp.check-safe-location", true) && !Validator.isSafeLocation(location)) {
            this.msg.sendMessage((CommandSender)player, "validation.location-unsafe");
            this.playWarning(player);
            if (!player.isSneaking()) {
                player.sendMessage(this.msg.colorize("&7&oAppuyez sur &eSHIFT &7&oet retapez la commande pour forcer."));
                return true;
            }
        }
        if ((isUpdate = this.dataManager.warpExists(warpName)) && this.plugin.getConfig().getBoolean("warp.show-overwrite-warning", true)) {
            this.msg.sendMessage((CommandSender)player, "teleport.home.overwrite-warning", this.msg.placeholder("home", warpName));
            this.playWarning(player);
        }
        this.dataManager.setWarp(warpName, location);
        this.playHomeCreatedEffect(location);
        this.playSuccess(player, SoundManager.SoundType.WARP_SET);
        if (this.plugin.getConfig().getBoolean("messages.format.interactive-buttons", true)) {
            MessageFormatter.sendWarpCreatedMessage(player, warpName);
        } else if (isUpdate) {
            this.msg.sendMessage((CommandSender)player, "teleport.warp.updated", this.msg.placeholder("warp", warpName));
        } else {
            this.msg.sendMessage((CommandSender)player, "teleport.warp.set", this.msg.placeholder("warp", warpName));
        }
        if (this.plugin.getConfig().getBoolean("messages.format.action-bar.enabled", true)) {
            MessageFormatter.sendActionBar(player, this.msg.colorize("&a\u2713 Warp &e" + warpName + " &acr\u00e9\u00e9 !"));
        }
        return true;
    }
}

