/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.mycommands.constants;

public final class Permissions {
    public static final String ALL = "mycommands.*";
    public static final String ADMIN = "mycommands.admin";
    public static final String PLAYER = "mycommands.player";
    public static final String EXTENDED = "mycommands.extended";
    public static final String RELOAD = "mycommands.reload";
    public static final String MIGRATE = "mycommands.migrate";
    public static final String HELP = "mycommands.help";
    public static final String GAMEMODE = "mycommands.gamemode";
    public static final String FLY = "mycommands.fly";
    public static final String FLY_OTHERS = "mycommands.fly.others";
    public static final String HEAL = "mycommands.heal";
    public static final String HEAL_OTHERS = "mycommands.heal.others";
    public static final String FEED = "mycommands.feed";
    public static final String FEED_OTHERS = "mycommands.feed.others";
    public static final String GOD = "mycommands.god";
    public static final String GOD_OTHERS = "mycommands.god.others";
    public static final String VANISH = "mycommands.vanish";
    public static final String VANISH_SEE = "mycommands.vanish.see";
    public static final String TP = "mycommands.tp";
    public static final String TPHERE = "mycommands.tphere";
    public static final String TPALL = "mycommands.tpall";
    public static final String GIVE = "mycommands.give";
    public static final String CLEAR = "mycommands.clear";
    public static final String INVSEE = "mycommands.invsee";
    public static final String ENDERCHEST = "mycommands.enderchest";
    public static final String ENDERCHEST_OTHERS = "mycommands.enderchest.others";
    public static final String WEATHER = "mycommands.weather";
    public static final String TIME = "mycommands.time";
    public static final String SPEED = "mycommands.speed";
    public static final String BROADCAST = "mycommands.broadcast";
    public static final String KICK = "mycommands.kick";
    public static final String FREEZE = "mycommands.freeze";
    public static final String FREEZE_BYPASS = "mycommands.freeze.bypass";
    public static final String SETSPAWN = "mycommands.setspawn";
    public static final String SETWARP = "mycommands.setwarp";
    public static final String DELWARP = "mycommands.delwarp";
    public static final String SOCIALSPY = "mycommands.socialspy";
    public static final String NICK_OTHERS = "mycommands.nick.others";
    public static final String STATS_OTHERS = "mycommands.stats.others";
    public static final String MORE = "mycommands.more";
    public static final String REPAIR = "mycommands.repair";
    public static final String REPAIR_ALL = "mycommands.repair.all";
    public static final String ENCHANT = "mycommands.enchant";
    public static final String ENCHANT_UNSAFE = "mycommands.enchant.unsafe";
    public static final String ANVIL = "mycommands.anvil";
    public static final String PTIME = "mycommands.ptime";
    public static final String PTIME_OTHERS = "mycommands.ptime.others";
    public static final String PWEATHER = "mycommands.pweather";
    public static final String PWEATHER_OTHERS = "mycommands.pweather.others";
    public static final String WORKBENCH = "mycommands.workbench";
    public static final String CARTOGRAPHY = "mycommands.cartography";
    public static final String GRINDSTONE = "mycommands.grindstone";
    public static final String SMITHING = "mycommands.smithing";
    public static final String LOOM = "mycommands.loom";
    public static final String STONECUTTER = "mycommands.stonecutter";
    public static final String DISPOSAL = "mycommands.disposal";
    public static final String HAT = "mycommands.hat";
    public static final String SKULL = "mycommands.skull";
    public static final String JAIL = "mycommands.jail";
    public static final String UNJAIL = "mycommands.unjail";
    public static final String SETJAIL = "mycommands.setjail";
    public static final String DELJAIL = "mycommands.deljail";
    public static final String JAILS = "mycommands.jails";
    public static final String REALNAME = "mycommands.realname";
    public static final String SEEN = "mycommands.seen";
    public static final String LIST = "mycommands.list";
    public static final String MOTD = "mycommands.motd";
    public static final String RULES = "mycommands.rules";
    public static final String SPAWN = "mycommands.spawn";
    public static final String HOME = "mycommands.home";
    public static final String SETHOME = "mycommands.sethome";
    public static final String DELHOME = "mycommands.delhome";
    public static final String HOMES = "mycommands.homes";
    public static final String WARP = "mycommands.warp";
    public static final String WARPS = "mycommands.warps";
    public static final String BACK = "mycommands.back";
    public static final String TPA = "mycommands.tpa";
    public static final String TPACCEPT = "mycommands.tpaccept";
    public static final String TPDENY = "mycommands.tpdeny";
    public static final String MSG = "mycommands.msg";
    public static final String REPLY = "mycommands.reply";
    public static final String IGNORE = "mycommands.ignore";
    public static final String NICK = "mycommands.nick";
    public static final String STATS = "mycommands.stats";
    public static final String SUICIDE = "mycommands.suicide";
    public static final String ME = "mycommands.me";
    public static final String NEAR = "mycommands.near";
    public static final String CONFIRM = "mycommands.confirm";
    public static final String CANCEL = "mycommands.cancel";
    public static final String AFK = "mycommands.afk";
    public static final String AFK_BYPASS = "mycommands.afk.bypass";
    public static final String GUI = "mycommands.gui";
    public static final String SETHOME_UNLIMITED = "mycommands.sethome.unlimited";
    public static final String SETHOME_LIMIT_PREFIX = "mycommands.sethome.";
    public static final String COOLDOWN_BYPASS = "mycommands.cooldown.bypass";
    public static final String TELEPORT_DELAY_BYPASS = "mycommands.teleportdelay.bypass";
    public static final String ECONOMY_BYPASS = "mycommands.economy.bypass";
    public static final String ECONOMY_DISCOUNT_VIP = "mycommands.economy.discount.vip";
    public static final String ECONOMY_DISCOUNT_MVP = "mycommands.economy.discount.mvp";
    public static final String ECONOMY_DISCOUNT_ADMIN = "mycommands.economy.discount.admin";

    private Permissions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static String warp(String warpName) {
        if (warpName == null || warpName.trim().isEmpty()) {
            throw new IllegalArgumentException("Warp name cannot be null or empty");
        }
        return "mycommands.warp." + warpName.toLowerCase().trim();
    }

    public static boolean isBypassPermission(String permission) {
        return permission != null && (permission.equals(COOLDOWN_BYPASS) || permission.equals(TELEPORT_DELAY_BYPASS) || permission.equals(FREEZE_BYPASS) || permission.equals(ECONOMY_BYPASS) || permission.equals(AFK_BYPASS));
    }

    public static boolean isEconomyPermission(String permission) {
        return permission != null && permission.startsWith("mycommands.economy.");
    }

    public static boolean isDiscountPermission(String permission) {
        return permission != null && (permission.equals(ECONOMY_DISCOUNT_VIP) || permission.equals(ECONOMY_DISCOUNT_MVP) || permission.equals(ECONOMY_DISCOUNT_ADMIN));
    }

    public static boolean isGUIPermission(String permission) {
        return permission != null && permission.startsWith("mycommands.gui.");
    }

    public static String sethomeLimit(int limit) {
        if (limit < 1) {
            throw new IllegalArgumentException("Home limit must be at least 1");
        }
        return SETHOME_LIMIT_PREFIX + limit;
    }

    public static String[] getHomeLimitPermissions() {
        return new String[]{SETHOME_UNLIMITED};
    }

    public static String[] getDiscountPermissions() {
        return new String[]{ECONOMY_DISCOUNT_VIP, ECONOMY_DISCOUNT_MVP, ECONOMY_DISCOUNT_ADMIN};
    }

    public static String[] getBypassPermissions() {
        return new String[]{COOLDOWN_BYPASS, TELEPORT_DELAY_BYPASS, FREEZE_BYPASS, ECONOMY_BYPASS, AFK_BYPASS};
    }

    public static String[] getGUIPermissions() {
        return new String[]{GUI};
    }
}

