/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.mycommands.integrations;

import fr.skynex.mycommands.MyCommands;
import fr.skynex.mycommands.managers.AFKManager;
import fr.skynex.mycommands.managers.CooldownManager;
import fr.skynex.mycommands.managers.StatisticsManager;
import java.util.Map;
import java.util.Set;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class MyCommandsExpansion
extends PlaceholderExpansion {
    private final MyCommands plugin;

    public MyCommandsExpansion(MyCommands plugin) {
        this.plugin = plugin;
    }

    @NotNull
    public String getIdentifier() {
        return "mycommands";
    }

    @NotNull
    public String getAuthor() {
        return "SkyNex";
    }

    @NotNull
    public String getVersion() {
        return "2.8.0";
    }

    public boolean persist() {
        return true;
    }

    public String onRequest(OfflinePlayer offlinePlayer, @NotNull String params) {
        AFKManager afkManager;
        if (offlinePlayer == null || !offlinePlayer.isOnline()) {
            return "";
        }
        Player player = offlinePlayer.getPlayer();
        if (player == null) {
            return "";
        }
        if (params.equals("homes_count")) {
            return String.valueOf(this.plugin.getDataManager().getHomesCount(player.getUniqueId()));
        }
        if (params.equals("homes_max")) {
            return String.valueOf(this.getMaxHomes(player));
        }
        if (params.equals("homes_remaining")) {
            int current = this.plugin.getDataManager().getHomesCount(player.getUniqueId());
            int max = this.getMaxHomes(player);
            return String.valueOf(Math.max(0, max - current));
        }
        if (params.equals("homes_list")) {
            Map<String, Location> homes = this.plugin.getDataManager().getHomes(player.getUniqueId());
            if (homes.isEmpty()) {
                return "None";
            }
            return String.join((CharSequence)", ", homes.keySet());
        }
        if (params.equals("warps_count")) {
            return String.valueOf(this.plugin.getDataManager().getWarps().size());
        }
        if (params.equals("warps_list")) {
            Set<String> warps = this.plugin.getDataManager().getWarps().keySet();
            if (warps.isEmpty()) {
                return "None";
            }
            return String.join((CharSequence)", ", warps);
        }
        CooldownManager cooldownManager = this.plugin.getCooldownManager();
        if (cooldownManager != null && this.plugin.getConfig().getBoolean("cooldowns.enabled", true)) {
            if (params.startsWith("cooldown_")) {
                String command = params.substring("cooldown_".length());
                if (command.endsWith("_seconds") || params.startsWith("cooldown_remaining_")) {
                    command = params.startsWith("cooldown_remaining_") ? params.substring("cooldown_remaining_".length()) : command.replace("_seconds", "");
                    if (cooldownManager.hasCooldown(player.getUniqueId(), command)) {
                        long seconds = cooldownManager.getRemainingCooldown(player.getUniqueId(), command);
                        return String.valueOf(seconds);
                    }
                    return "0";
                }
                if (cooldownManager.hasCooldown(player.getUniqueId(), command)) {
                    long seconds = cooldownManager.getRemainingCooldown(player.getUniqueId(), command);
                    return this.formatDuration(seconds);
                }
                return "0s";
            }
            if (params.startsWith("has_cooldown_")) {
                String command = params.substring("has_cooldown_".length());
                return cooldownManager.hasCooldown(player.getUniqueId(), command) ? "yes" : "no";
            }
        }
        if ((afkManager = this.plugin.getAFKManager()) != null) {
            if (params.equals("afk")) {
                return afkManager.isAFK(player.getUniqueId()) ? "yes" : "no";
            }
            if (params.equals("afk_time")) {
                if (!afkManager.isAFK(player.getUniqueId())) {
                    return "0s";
                }
                long seconds = afkManager.getAFKTime(player.getUniqueId());
                return this.formatDuration(seconds);
            }
            if (params.equals("afk_display")) {
                if (!afkManager.isAFK(player.getUniqueId())) {
                    return "";
                }
                return afkManager.getAFKDisplay();
            }
            if (params.equals("afk_display_time")) {
                if (!afkManager.isAFK(player.getUniqueId())) {
                    return "";
                }
                return afkManager.getAFKDisplayWithTime(player.getUniqueId());
            }
            if (params.equals("inactive_time")) {
                long seconds = afkManager.getInactiveTime(player.getUniqueId());
                return this.formatDuration(seconds);
            }
            if (params.equals("afk_count")) {
                return String.valueOf(afkManager.getAFKCount());
            }
            if (params.equals("active_players")) {
                int total = Bukkit.getOnlinePlayers().size();
                int afk = afkManager.getAFKCount();
                return String.valueOf(total - afk);
            }
        }
        if (params.equals("world")) {
            return player.getWorld().getName();
        }
        if (params.equals("ping")) {
            try {
                return String.valueOf(player.getPing());
            }
            catch (NoSuchMethodError e) {
                return "N/A";
            }
        }
        if (params.equals("gamemode")) {
            return player.getGameMode().name();
        }
        if (params.equals("health")) {
            return String.valueOf((int)player.getHealth());
        }
        if (params.equals("max_health")) {
            AttributeInstance maxHealthAttr = player.getAttribute(Attribute.GENERIC_MAX_HEALTH);
            if (maxHealthAttr != null) {
                return String.valueOf((int)maxHealthAttr.getValue());
            }
            return "20";
        }
        if (params.equals("food")) {
            return String.valueOf(player.getFoodLevel());
        }
        if (params.equals("exp_level")) {
            return String.valueOf(player.getLevel());
        }
        if (params.equals("economy_balance")) {
            if (this.plugin.getEconomyManager() != null && this.plugin.getEconomyManager().isEnabled()) {
                double balance = this.plugin.getEconomyManager().getBalance(player);
                return String.format("%.2f", balance);
            }
            return "N/A";
        }
        if (params.equals("online")) {
            return String.valueOf(Bukkit.getOnlinePlayers().size());
        }
        if (params.equals("max_players")) {
            return String.valueOf(Bukkit.getMaxPlayers());
        }
        if (this.plugin.getConfig().getBoolean("statistics.enabled", false)) {
            StatisticsManager.PlayerStats stats = this.plugin.getStatisticsManager().getStats(player.getUniqueId());
            if (params.equals("stats_homes_teleports")) {
                return String.valueOf(stats.getTeleports(StatisticsManager.TeleportType.HOME));
            }
            if (params.equals("stats_warps_teleports")) {
                return String.valueOf(stats.getTeleports(StatisticsManager.TeleportType.WARP));
            }
            if (params.equals("stats_homes_set")) {
                return String.valueOf(stats.getHomesCreated());
            }
            if (params.equals("stats_tpa_sent")) {
                return String.valueOf(stats.getTeleports(StatisticsManager.TeleportType.TPA));
            }
            if (params.equals("stats_messages_sent")) {
                return String.valueOf(stats.getMessagesSent());
            }
            if (params.equals("stats_back_uses")) {
                return String.valueOf(stats.getTeleports(StatisticsManager.TeleportType.BACK));
            }
            if (params.equals("teleports_total")) {
                return String.valueOf(stats.getTotalTeleports());
            }
            if (params.equals("teleports_homes")) {
                return String.valueOf(stats.getTeleports(StatisticsManager.TeleportType.HOME));
            }
            if (params.equals("teleports_warps")) {
                return String.valueOf(stats.getTeleports(StatisticsManager.TeleportType.WARP));
            }
            if (params.equals("teleports_spawn")) {
                return String.valueOf(stats.getTeleports(StatisticsManager.TeleportType.SPAWN));
            }
            if (params.equals("teleports_tpa")) {
                return String.valueOf(stats.getTeleports(StatisticsManager.TeleportType.TPA));
            }
            if (params.equals("teleports_back")) {
                return String.valueOf(stats.getTeleports(StatisticsManager.TeleportType.BACK));
            }
            if (params.equals("homes_created")) {
                return String.valueOf(stats.getHomesCreated());
            }
            if (params.equals("messages_sent")) {
                return String.valueOf(stats.getMessagesSent());
            }
        }
        if (this.plugin.getEconomyManager() != null && this.plugin.getEconomyManager().isEnabled()) {
            if (params.equals("balance")) {
                return this.plugin.getEconomyManager().getFormattedBalance(player);
            }
            if (params.equals("economy_enabled")) {
                return "true";
            }
        } else if (params.equals("economy_enabled")) {
            return "false";
        }
        if (params.equals("vanished")) {
            return this.plugin.getDataManager().isVanished(player.getUniqueId()) ? "yes" : "no";
        }
        if (params.equals("frozen")) {
            return this.plugin.getDataManager().isFrozen(player.getUniqueId()) ? "yes" : "no";
        }
        if (params.equals("god")) {
            return player.isInvulnerable() ? "yes" : "no";
        }
        if (params.equals("fly")) {
            return player.getAllowFlight() ? "yes" : "no";
        }
        if (params.equals("storage_type")) {
            return this.plugin.getDataManager().getStorageType().toUpperCase();
        }
        if (params.equals("language")) {
            return this.plugin.getMessageManager().getLanguage().toUpperCase();
        }
        if (params.equals("version")) {
            return this.plugin.getDescription().getVersion();
        }
        return null;
    }

    private int getMaxHomes(Player player) {
        if (player.hasPermission("mycommands.sethome.unlimited")) {
            return Integer.MAX_VALUE;
        }
        for (int i = 100; i >= 1; --i) {
            if (!player.hasPermission("mycommands.sethome." + i)) continue;
            return i;
        }
        return this.plugin.getConfig().getInt("limits.max-homes", 3);
    }

    private String formatDuration(long seconds) {
        if (seconds < 60L) {
            return seconds + "s";
        }
        if (seconds < 3600L) {
            long minutes = seconds / 60L;
            long secs = seconds % 60L;
            return minutes + "m " + secs + "s";
        }
        long hours = seconds / 3600L;
        long minutes = seconds % 3600L / 60L;
        return hours + "h " + minutes + "m";
    }
}

