/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.mycommands.listeners;

import fr.skynex.mycommands.MyCommands;
import fr.skynex.mycommands.managers.AFKManager;
import fr.skynex.mycommands.managers.DataManager;
import fr.skynex.mycommands.managers.MessageManager;
import fr.skynex.mycommands.utils.DiscordWebhook;
import fr.skynex.mycommands.utils.MessageFormatter;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class JoinQuitListener
implements Listener {
    private final MyCommands plugin;
    private final DataManager dataManager;
    private final MessageManager msg;
    private final AFKManager afkManager;

    public JoinQuitListener(MyCommands plugin) {
        this.plugin = plugin;
        this.dataManager = plugin.getDataManager();
        this.msg = plugin.getMessageManager();
        this.afkManager = plugin.getAFKManager();
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Location spawn;
        boolean isFirstJoin;
        Player player = event.getPlayer();
        this.dataManager.loadPlayerData(player.getUniqueId());
        if (this.dataManager.hasGodMode(player.getUniqueId())) {
            player.setInvulnerable(true);
        }
        if (this.afkManager != null) {
            this.afkManager.loadPlayer(player.getUniqueId());
        }
        if (!this.plugin.getConfig().getBoolean("join-quit-messages.enabled", true)) {
            return;
        }
        boolean bl = isFirstJoin = !player.hasPlayedBefore();
        if (this.plugin.getConfig().getBoolean("join-quit-messages.override-default", true)) {
            event.setJoinMessage(null);
        }
        if (isFirstJoin) {
            message = this.plugin.getConfig().getString("join-quit-messages.first-join", "&a&l+ &e{player} &7a rejoint le serveur pour la premi\u00e8re fois ! &a&l+");
            message = this.formatMessage(message, player);
            Bukkit.broadcastMessage((String)this.msg.colorize(message));
            this.sendDiscordWebhook("first-join", message, player);
        } else {
            message = this.plugin.getConfig().getString("join-quit-messages.join", "&e{player} &7a rejoint le serveur &8[&a{online}&8/&a{max}&8]");
            message = this.formatMessage(message, player);
            Bukkit.broadcastMessage((String)this.msg.colorize(message));
            this.sendDiscordWebhook("player-join", message, player);
        }
        this.sendJoinTitle(player);
        this.sendJoinActionBar(player);
        if (this.plugin.getConfig().getBoolean("join-quit-messages.welcome-message.enabled", false)) {
            this.sendWelcomeMessage(player);
        }
        if (isFirstJoin && this.plugin.getConfig().getBoolean("spawn.teleport-on-first-join", true) && (spawn = this.dataManager.getSpawn(player.getWorld())) != null) {
            player.teleport(spawn);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        if (this.afkManager != null) {
            this.afkManager.removePlayer(player.getUniqueId());
        }
        if (!this.plugin.getConfig().getBoolean("join-quit-messages.enabled", true)) {
            return;
        }
        if (this.plugin.getConfig().getBoolean("join-quit-messages.override-default", true)) {
            event.setQuitMessage(null);
        }
        String message = this.plugin.getConfig().getString("join-quit-messages.quit", "&e{player} &7a quitt\u00e9 le serveur &8[&a{online}&8/&a{max}&8]");
        message = this.formatMessage(message, player);
        Bukkit.broadcastMessage((String)this.msg.colorize(message));
        this.sendDiscordWebhook("player-quit", message, player);
    }

    private void sendDiscordWebhook(String event, String formattedIngameMessage, Player player) {
        if (!this.plugin.getConfig().getBoolean("join-quit-messages.discord.enabled", false)) {
            return;
        }
        String webhookUrl = this.plugin.getConfig().getString("join-quit-messages.discord.webhook-url", "");
        if (webhookUrl.isEmpty() || webhookUrl.contains("...")) {
            return;
        }
        boolean send = false;
        String template = "";
        if ("first-join".equals(event) && this.plugin.getConfig().getBoolean("join-quit-messages.discord.first-join.enabled", true)) {
            template = this.plugin.getConfig().getString("join-quit-messages.discord.first-join.message", "**{player}** a rejoint le serveur pour la premi\u00e8re fois !");
            send = true;
        } else if ("player-join".equals(event) && this.plugin.getConfig().getBoolean("join-quit-messages.discord.player-join.enabled", true)) {
            template = this.plugin.getConfig().getString("join-quit-messages.discord.player-join.message", "**{player}** a rejoint le serveur [{online}/{max}]");
            send = true;
        } else if ("player-quit".equals(event) && this.plugin.getConfig().getBoolean("join-quit-messages.discord.player-quit.enabled", true)) {
            template = this.plugin.getConfig().getString("join-quit-messages.discord.player-quit.message", "**{player}** a quitt\u00e9 le serveur [{online}/{max}]");
            send = true;
        }
        if (!send || template.isEmpty()) {
            return;
        }
        String content = this.formatMessage(template, player);
        content = JoinQuitListener.stripColorCodes(content);
        DiscordWebhook.sendAsync(this.plugin, webhookUrl, content);
    }

    private static String stripColorCodes(String s) {
        if (s == null) {
            return "";
        }
        return s.replaceAll("&[0-9a-fk-or]", "").replaceAll("\u00a7[0-9a-fk-or]", "");
    }

    private void sendJoinTitle(Player player) {
        if (!this.plugin.getConfig().getBoolean("join-quit-messages.join-title.enabled", false)) {
            return;
        }
        String title = this.msg.colorize(this.formatMessage(this.plugin.getConfig().getString("join-quit-messages.join-title.title", "&6&lBienvenue"), player));
        String subtitle = this.msg.colorize(this.formatMessage(this.plugin.getConfig().getString("join-quit-messages.join-title.subtitle", "&7Sur le serveur !"), player));
        int fadeIn = this.plugin.getConfig().getInt("join-quit-messages.join-title.fade-in", 10);
        int stay = this.plugin.getConfig().getInt("join-quit-messages.join-title.stay", 70);
        int fadeOut = this.plugin.getConfig().getInt("join-quit-messages.join-title.fade-out", 20);
        String finalTitle = title;
        String finalSubtitle = subtitle;
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            if (player.isOnline()) {
                player.sendTitle(finalTitle, finalSubtitle, fadeIn, stay, fadeOut);
            }
        }, 5L);
    }

    private void sendJoinActionBar(Player player) {
        if (!this.plugin.getConfig().getBoolean("join-quit-messages.join-action-bar.enabled", false)) {
            return;
        }
        int delay = this.plugin.getConfig().getInt("join-quit-messages.join-action-bar.delay", 40);
        String message = this.plugin.getConfig().getString("join-quit-messages.join-action-bar.message", "&eBienvenue &6{player} &e! Tapez &f/help &epour les commandes.");
        message = this.formatMessage(message, player);
        String finalMessage = this.msg.colorize(message);
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            if (player.isOnline()) {
                MessageFormatter.sendActionBar(player, finalMessage);
            }
        }, (long)delay);
    }

    private String formatMessage(String message, Player player) {
        int online = Bukkit.getOnlinePlayers().size();
        int max = Bukkit.getMaxPlayers();
        return message.replace("{player}", player.getName()).replace("{displayname}", player.getDisplayName()).replace("{online}", String.valueOf(online)).replace("{max}", String.valueOf(max));
    }

    private void sendWelcomeMessage(Player player) {
        int delay = this.plugin.getConfig().getInt("join-quit-messages.welcome-message.delay", 20);
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            if (player.isOnline()) {
                List lines = this.plugin.getConfig().getStringList("join-quit-messages.welcome-message.lines");
                for (String line : lines) {
                    line = this.formatMessage(line, player);
                    player.sendMessage(this.msg.colorize(line));
                }
            }
        }, (long)delay);
    }
}

