/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.mycommands.managers;

import fr.skynex.mycommands.MyCommands;
import fr.skynex.mycommands.managers.MessageManager;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class AFKManager {
    private final MyCommands plugin;
    private final MessageManager msg;
    private final Map<UUID, Boolean> afkPlayers;
    private final Map<UUID, Long> lastActivity;
    private final Map<UUID, Long> afkSince;
    private boolean enabled;
    private int afkTimeout;
    private boolean kickEnabled;
    private int kickTimeout;
    private boolean broadcastAFK;
    private boolean broadcastReturn;
    private boolean bypassForOps;
    private String afkDisplayFormat;
    private BukkitTask checkTask;

    public AFKManager(MyCommands plugin) {
        this.plugin = plugin;
        this.msg = plugin.getMessageManager();
        this.afkPlayers = new HashMap<UUID, Boolean>();
        this.lastActivity = new HashMap<UUID, Long>();
        this.afkSince = new HashMap<UUID, Long>();
        this.loadConfig();
        this.startCheckTask();
        plugin.getLogger().info("\u2713 AFKManager initialized (timeout: " + this.afkTimeout + "s)");
    }

    private void loadConfig() {
        this.enabled = this.plugin.getConfig().getBoolean("afk.enabled", true);
        this.afkTimeout = this.plugin.getConfig().getInt("afk.timeout", 300);
        this.kickEnabled = this.plugin.getConfig().getBoolean("afk.kick.enabled", false);
        this.kickTimeout = this.plugin.getConfig().getInt("afk.kick.timeout", 900);
        this.broadcastAFK = this.plugin.getConfig().getBoolean("afk.broadcast.afk", true);
        this.broadcastReturn = this.plugin.getConfig().getBoolean("afk.broadcast.return", true);
        this.bypassForOps = this.plugin.getConfig().getBoolean("afk.bypass-for-ops", true);
        this.afkDisplayFormat = this.plugin.getConfig().getString("afk.display-format", "&7[AFK]");
    }

    private void startCheckTask() {
        if (!this.enabled) {
            return;
        }
        this.checkTask = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            long now = System.currentTimeMillis();
            for (Player player : Bukkit.getOnlinePlayers()) {
                UUID uuid = player.getUniqueId();
                if (this.bypassForOps && player.isOp() || player.hasPermission("mycommands.afk.bypass")) continue;
                Long lastAct = this.lastActivity.get(uuid);
                if (lastAct == null) {
                    this.lastActivity.put(uuid, now);
                    continue;
                }
                long inactiveSeconds = (now - lastAct) / 1000L;
                boolean isAFK = this.isAFK(uuid);
                if (!isAFK && inactiveSeconds >= (long)this.afkTimeout) {
                    this.setAFK(player, true, true);
                }
                if (!isAFK || !this.kickEnabled || inactiveSeconds < (long)this.kickTimeout) continue;
                this.kickForAFK(player, inactiveSeconds);
            }
        }, 20L, 20L);
    }

    private void kickForAFK(Player player, long inactiveSeconds) {
        String time = this.formatDuration(inactiveSeconds);
        String reason = this.msg.getMessage("afk.kick-reason").replace("{time}", time);
        player.kickPlayer(this.msg.colorize(reason));
        if (this.broadcastAFK) {
            this.msg.broadcast("afk.kick-broadcast", this.msg.placeholder("player", player.getName()), this.msg.placeholder("time", time));
        }
        this.removePlayer(player.getUniqueId());
    }

    public void updateActivity(Player player) {
        if (!this.enabled) {
            return;
        }
        UUID uuid = player.getUniqueId();
        long now = System.currentTimeMillis();
        this.lastActivity.put(uuid, now);
        if (this.isAFK(uuid)) {
            this.setAFK(player, false, false);
        }
    }

    public void setAFK(Player player, boolean afk, boolean auto) {
        UUID uuid = player.getUniqueId();
        if (this.afkPlayers.getOrDefault(uuid, false) == afk) {
            return;
        }
        this.afkPlayers.put(uuid, afk);
        if (afk) {
            this.afkSince.put(uuid, System.currentTimeMillis());
            if (auto) {
                this.msg.sendMessage((CommandSender)player, "afk.now-auto");
            } else {
                this.msg.sendMessage((CommandSender)player, "afk.now-manual");
            }
            if (this.broadcastAFK) {
                this.msg.broadcast("afk.broadcast", this.msg.placeholder("player", player.getName()));
            }
        } else {
            Long since = this.afkSince.remove(uuid);
            String duration = "";
            if (since != null) {
                long seconds = (System.currentTimeMillis() - since) / 1000L;
                duration = this.formatDuration(seconds);
            }
            this.msg.sendMessage((CommandSender)player, "afk.return", this.msg.placeholder("time", duration));
            if (this.broadcastReturn) {
                this.msg.broadcast("afk.return-broadcast", this.msg.placeholder("player", player.getName()), this.msg.placeholder("time", duration));
            }
            this.lastActivity.put(uuid, System.currentTimeMillis());
        }
    }

    public void toggleAFK(Player player) {
        boolean isAFK = this.isAFK(player.getUniqueId());
        this.setAFK(player, !isAFK, false);
    }

    public boolean isAFK(UUID uuid) {
        return this.afkPlayers.getOrDefault(uuid, false);
    }

    public long getAFKTime(UUID uuid) {
        if (!this.isAFK(uuid)) {
            return 0L;
        }
        Long since = this.afkSince.get(uuid);
        if (since == null) {
            return 0L;
        }
        return (System.currentTimeMillis() - since) / 1000L;
    }

    public long getInactiveTime(UUID uuid) {
        Long lastAct = this.lastActivity.get(uuid);
        if (lastAct == null) {
            return 0L;
        }
        return (System.currentTimeMillis() - lastAct) / 1000L;
    }

    private String formatDuration(long seconds) {
        if (seconds < 60L) {
            return seconds + "s";
        }
        if (seconds < 3600L) {
            long minutes = seconds / 60L;
            long secs = seconds % 60L;
            return minutes + "m " + secs + "s";
        }
        long hours = seconds / 3600L;
        long minutes = seconds % 3600L / 60L;
        return hours + "h " + minutes + "m";
    }

    public String getAFKDisplay() {
        return this.msg.colorize(this.afkDisplayFormat);
    }

    public String getAFKDisplayWithTime(UUID uuid) {
        if (!this.isAFK(uuid)) {
            return "";
        }
        long seconds = this.getAFKTime(uuid);
        String time = this.formatDuration(seconds);
        return this.msg.colorize(this.afkDisplayFormat + " &7(" + time + ")");
    }

    public void loadPlayer(UUID uuid) {
        this.lastActivity.put(uuid, System.currentTimeMillis());
        this.afkPlayers.put(uuid, false);
    }

    public void removePlayer(UUID uuid) {
        this.afkPlayers.remove(uuid);
        this.lastActivity.remove(uuid);
        this.afkSince.remove(uuid);
    }

    public void reload() {
        this.loadConfig();
        this.plugin.getLogger().info("AFKManager reloaded");
    }

    public void shutdown() {
        if (this.checkTask != null) {
            this.checkTask.cancel();
        }
        this.afkPlayers.clear();
        this.lastActivity.clear();
        this.afkSince.clear();
    }

    public int getAFKCount() {
        return (int)this.afkPlayers.values().stream().filter(b -> b).count();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getAFKTimeout() {
        return this.afkTimeout;
    }

    public int getKickTimeout() {
        return this.kickTimeout;
    }

    public boolean isKickEnabled() {
        return this.kickEnabled;
    }
}

