/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.mycommands.managers;

import fr.skynex.mycommands.MyCommands;
import fr.skynex.mycommands.managers.MessageManager;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class CooldownManager {
    private final MyCommands plugin;
    private final MessageManager msg;
    private final Map<UUID, Map<String, Long>> cooldowns = new ConcurrentHashMap<UUID, Map<String, Long>>();
    private final Map<UUID, BukkitTask> teleportDelays = new ConcurrentHashMap<UUID, BukkitTask>();
    private final Map<UUID, Location> teleportPositions = new ConcurrentHashMap<UUID, Location>();

    public CooldownManager(MyCommands plugin) {
        this.plugin = plugin;
        this.msg = plugin.getMessageManager();
    }

    public void setCooldown(UUID uuid, String type, long seconds) {
        this.cooldowns.computeIfAbsent(uuid, k -> new HashMap()).put(type, System.currentTimeMillis() + seconds * 1000L);
    }

    public boolean hasCooldown(UUID uuid, String type) {
        Map<String, Long> playerCooldowns = this.cooldowns.get(uuid);
        if (playerCooldowns == null) {
            return false;
        }
        Long expiration = playerCooldowns.get(type);
        if (expiration == null) {
            return false;
        }
        if (System.currentTimeMillis() >= expiration) {
            playerCooldowns.remove(type);
            if (playerCooldowns.isEmpty()) {
                this.cooldowns.remove(uuid);
            }
            return false;
        }
        return true;
    }

    public long getRemainingCooldown(UUID uuid, String type) {
        Map<String, Long> playerCooldowns = this.cooldowns.get(uuid);
        if (playerCooldowns == null) {
            return 0L;
        }
        Long expiration = playerCooldowns.get(type);
        if (expiration == null) {
            return 0L;
        }
        long remaining = (expiration - System.currentTimeMillis()) / 1000L;
        return Math.max(0L, remaining);
    }

    public void removeCooldown(UUID uuid, String type) {
        Map<String, Long> playerCooldowns = this.cooldowns.get(uuid);
        if (playerCooldowns != null) {
            playerCooldowns.remove(type);
            if (playerCooldowns.isEmpty()) {
                this.cooldowns.remove(uuid);
            }
        }
    }

    public void clearCooldowns(UUID uuid) {
        this.cooldowns.remove(uuid);
    }

    public boolean checkCooldown(Player player, String type) {
        if (this.hasCooldown(player.getUniqueId(), type)) {
            long remaining = this.getRemainingCooldown(player.getUniqueId(), type);
            this.msg.sendMessage((CommandSender)player, "general.cooldown-active", this.msg.placeholder("time", this.formatTime(remaining)));
            return false;
        }
        return true;
    }

    public long getCooldownDuration(String type) {
        String path = "cooldowns.commands." + type;
        return this.plugin.getConfig().getLong(path, 0L);
    }

    public void startTeleportDelay(Player player, String type, Runnable onComplete) {
        this.cancelTeleportDelay(player.getUniqueId());
        if (!this.plugin.getConfig().getBoolean("teleport-delay.enabled", true)) {
            onComplete.run();
            return;
        }
        if (player.hasPermission("mycommands.teleportdelay.bypass")) {
            onComplete.run();
            return;
        }
        if (player.isOp() && this.plugin.getConfig().getBoolean("teleport-delay.bypass-for-ops", true)) {
            onComplete.run();
            return;
        }
        long delay = this.plugin.getConfig().getLong("teleport-delay.delay." + type, 0L);
        if (delay <= 0L) {
            onComplete.run();
            return;
        }
        this.teleportPositions.put(player.getUniqueId(), player.getLocation().clone());
        this.msg.sendMessage((CommandSender)player, "general.cooldown-wait", this.msg.placeholder("time", this.formatTime(delay)));
        BukkitTask task = this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            boolean cancelOnMove = this.plugin.getConfig().getBoolean("teleport-delay.cancel-on-move", true);
            if (cancelOnMove && this.hasPlayerMoved(player.getUniqueId(), player.getLocation())) {
                this.msg.sendMessage((CommandSender)player, "general.cooldown-cancelled");
                this.teleportDelays.remove(player.getUniqueId());
                this.teleportPositions.remove(player.getUniqueId());
                return;
            }
            onComplete.run();
            this.teleportDelays.remove(player.getUniqueId());
            this.teleportPositions.remove(player.getUniqueId());
        }, delay * 20L);
        this.teleportDelays.put(player.getUniqueId(), task);
    }

    public void startTeleportDelayWithCooldown(Player player, String type, Runnable onComplete) {
        this.startTeleportDelay(player, type, () -> {
            long cooldownDuration = this.getCooldownDuration(type);
            if (cooldownDuration > 0L) {
                this.setCooldown(player.getUniqueId(), type, cooldownDuration);
            }
            onComplete.run();
        });
    }

    public void cancelTeleportDelay(UUID uuid) {
        BukkitTask task = this.teleportDelays.remove(uuid);
        if (task != null) {
            task.cancel();
        }
        this.teleportPositions.remove(uuid);
    }

    public boolean hasTeleportDelay(UUID uuid) {
        return this.teleportDelays.containsKey(uuid);
    }

    private boolean hasPlayerMoved(UUID uuid, Location currentLocation) {
        Location savedLocation = this.teleportPositions.get(uuid);
        if (savedLocation == null) {
            return false;
        }
        if (!savedLocation.getWorld().equals((Object)currentLocation.getWorld())) {
            return true;
        }
        return savedLocation.distance(currentLocation) > 0.1;
    }

    private String formatTime(long seconds) {
        if (seconds < 60L) {
            return seconds + "s";
        }
        if (seconds < 3600L) {
            long minutes = seconds / 60L;
            long remainingSeconds = seconds % 60L;
            if (remainingSeconds > 0L) {
                return minutes + "m " + remainingSeconds + "s";
            }
            return minutes + "m";
        }
        long hours = seconds / 3600L;
        long remainingMinutes = seconds % 3600L / 60L;
        if (remainingMinutes > 0L) {
            return hours + "h " + remainingMinutes + "m";
        }
        return hours + "h";
    }

    public Map<String, Long> getAllCooldowns(UUID uuid) {
        Map<String, Long> playerCooldowns = this.cooldowns.get(uuid);
        if (playerCooldowns == null) {
            return new HashMap<String, Long>();
        }
        HashMap<String, Long> result = new HashMap<String, Long>();
        long now = System.currentTimeMillis();
        for (Map.Entry<String, Long> entry : playerCooldowns.entrySet()) {
            if (entry.getValue() <= now) continue;
            result.put(entry.getKey(), (entry.getValue() - now) / 1000L);
        }
        return result;
    }

    public int getActiveCooldownCount() {
        int count = 0;
        long now = System.currentTimeMillis();
        for (Map<String, Long> playerCooldowns : this.cooldowns.values()) {
            for (Long expiration : playerCooldowns.values()) {
                if (expiration <= now) continue;
                ++count;
            }
        }
        return count;
    }

    public int getActiveTeleportDelayCount() {
        return this.teleportDelays.size();
    }

    public void cleanupExpiredCooldowns() {
        long now = System.currentTimeMillis();
        AtomicInteger cleaned = new AtomicInteger();
        for (UUID uuid : this.cooldowns.keySet()) {
            Map<String, Long> playerCooldowns = this.cooldowns.get(uuid);
            if (playerCooldowns == null) continue;
            playerCooldowns.entrySet().removeIf(entry -> {
                if ((Long)entry.getValue() <= now) {
                    cleaned.getAndIncrement();
                    return true;
                }
                return false;
            });
            if (!playerCooldowns.isEmpty()) continue;
            this.cooldowns.remove(uuid);
        }
        if (cleaned.get() > 0) {
            this.plugin.getLogger().info("Cleaned " + String.valueOf(cleaned) + " expired cooldowns");
        }
    }

    public void reload() {
        this.plugin.getLogger().info("CooldownManager reloaded");
    }

    public void shutdown() {
        for (BukkitTask task : this.teleportDelays.values()) {
            task.cancel();
        }
        this.teleportDelays.clear();
        this.teleportPositions.clear();
        this.plugin.getLogger().info("CooldownManager shutdown complete");
    }

    public void printStats() {
        this.plugin.getLogger().info("=== CooldownManager Stats ===");
        this.plugin.getLogger().info("Active cooldowns: " + this.getActiveCooldownCount());
        this.plugin.getLogger().info("Active teleport delays: " + this.getActiveTeleportDelayCount());
        this.plugin.getLogger().info("Players with cooldowns: " + this.cooldowns.size());
    }
}

