/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.mycommands.managers;

import fr.skynex.mycommands.MyCommands;
import fr.skynex.mycommands.gui.StaticTeleportItem;
import fr.skynex.mycommands.managers.MessageManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class GUIConfig {
    private final MyCommands plugin;
    private File guiFile;
    private FileConfiguration guiConfig;
    private final MessageManager msg;
    private final Map<String, List<StaticTeleportItem>> staticHomesCache = new HashMap<String, List<StaticTeleportItem>>();
    private final Map<String, List<StaticTeleportItem>> staticWarpsCache = new HashMap<String, List<StaticTeleportItem>>();

    public GUIConfig(MyCommands plugin) {
        this.plugin = plugin;
        this.msg = plugin.getMessageManager();
        this.loadConfig();
    }

    public void loadConfig() {
        this.guiFile = new File(this.plugin.getDataFolder(), "guis.yml");
        if (!this.guiFile.exists()) {
            this.plugin.saveResource("guis.yml", false);
        }
        try {
            this.guiConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader((InputStream)new FileInputStream(this.guiFile), StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Erreur lors du chargement de guis.yml: " + e.getMessage());
            this.guiConfig = new YamlConfiguration();
        }
        try {
            YamlConfiguration defConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(this.plugin.getResource("guis.yml"), StandardCharsets.UTF_8));
            this.guiConfig.setDefaults((Configuration)defConfig);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Impossible de charger les valeurs par d\u00e9faut de guis.yml");
        }
        this.loadStaticItems();
    }

    private void loadStaticItems() {
        ConfigurationSection warpsSection;
        this.staticHomesCache.clear();
        this.staticWarpsCache.clear();
        ConfigurationSection homesSection = this.guiConfig.getConfigurationSection("homes-gui.static-homes");
        if (homesSection != null && this.guiConfig.getBoolean("homes-gui.static-homes.enabled", true)) {
            ArrayList<StaticTeleportItem> staticHomes = new ArrayList<StaticTeleportItem>();
            for (String key : homesSection.getKeys(false)) {
                StaticTeleportItem item;
                ConfigurationSection itemSection;
                if (key.equals("enabled") || (itemSection = homesSection.getConfigurationSection(key)) == null || !(item = new StaticTeleportItem(key, itemSection)).isEnabled()) continue;
                staticHomes.add(item);
            }
            this.staticHomesCache.put("default", staticHomes);
            this.plugin.getLogger().info("Charg\u00e9 " + staticHomes.size() + " static homes");
        }
        if ((warpsSection = this.guiConfig.getConfigurationSection("warps-gui.static-warps")) != null && this.guiConfig.getBoolean("warps-gui.static-warps.enabled", true)) {
            ArrayList<StaticTeleportItem> staticWarps = new ArrayList<StaticTeleportItem>();
            for (String key : warpsSection.getKeys(false)) {
                StaticTeleportItem item;
                ConfigurationSection itemSection;
                if (key.equals("enabled") || (itemSection = warpsSection.getConfigurationSection(key)) == null || !(item = new StaticTeleportItem(key, itemSection)).isEnabled()) continue;
                staticWarps.add(item);
            }
            this.staticWarpsCache.put("default", staticWarps);
            this.plugin.getLogger().info("Charg\u00e9 " + staticWarps.size() + " static warps");
        }
    }

    public void reload() {
        this.loadConfig();
    }

    public void save() {
        try {
            this.guiConfig.save(this.guiFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Erreur lors de la sauvegarde de guis.yml: " + e.getMessage());
        }
    }

    public boolean isHomesGUIEnabled() {
        return this.guiConfig.getBoolean("homes-gui.enabled", true);
    }

    public String getHomesTitle() {
        return this.msg.colorize(this.guiConfig.getString("homes-gui.title", "&6&lMes Homes &8({count})"));
    }

    public String getHomesSizeConfig() {
        return this.guiConfig.getString("homes-gui.size", "auto");
    }

    public boolean isDynamicHomesEnabled() {
        return this.guiConfig.getBoolean("homes-gui.dynamic-homes.enabled", true);
    }

    public int getDynamicHomesStartSlot() {
        return this.guiConfig.getInt("homes-gui.dynamic-homes.start-slot", 10);
    }

    public Material getHomeItemMaterial() {
        return this.getMaterial("homes-gui.dynamic-homes.home-item.material", Material.RED_BED);
    }

    public String getHomeItemName() {
        return this.msg.colorize(this.guiConfig.getString("homes-gui.dynamic-homes.home-item.name", "&6&l{home}"));
    }

    public List<String> getHomeItemLore() {
        return this.colorizeList(this.guiConfig.getStringList("homes-gui.dynamic-homes.home-item.lore"));
    }

    public boolean isStaticHomesEnabled() {
        return this.guiConfig.getBoolean("homes-gui.static-homes.enabled", true);
    }

    public List<StaticTeleportItem> getStaticHomes() {
        return new ArrayList<StaticTeleportItem>(this.staticHomesCache.getOrDefault("default", new ArrayList()));
    }

    public Material getAddHomeButtonMaterial() {
        return this.getMaterial("homes-gui.add-home-button.material", Material.LIME_STAINED_GLASS_PANE);
    }

    public String getAddHomeButtonName() {
        return this.msg.colorize(this.guiConfig.getString("homes-gui.add-home-button.name", "&a&l+ Cr\u00e9er un nouveau home"));
    }

    public List<String> getAddHomeButtonLore() {
        return this.colorizeList(this.guiConfig.getStringList("homes-gui.add-home-button.lore"));
    }

    public int getAddHomeButtonSlot() {
        return this.guiConfig.getInt("homes-gui.add-home-button.slot", 0);
    }

    public boolean isAddHomeButtonEnabled() {
        return this.guiConfig.getBoolean("homes-gui.add-home-button.enabled", true);
    }

    public Material getLimitReachedMaterial() {
        return this.getMaterial("homes-gui.limit-reached-item.material", Material.RED_STAINED_GLASS_PANE);
    }

    public String getLimitReachedName() {
        return this.msg.colorize(this.guiConfig.getString("homes-gui.limit-reached-item.name", "&c&lLimite atteinte"));
    }

    public List<String> getLimitReachedLore() {
        return this.colorizeList(this.guiConfig.getStringList("homes-gui.limit-reached-item.lore"));
    }

    public boolean isLimitReachedEnabled() {
        return this.guiConfig.getBoolean("homes-gui.limit-reached-item.enabled", true);
    }

    public Material getHomesCloseButtonMaterial() {
        return this.getMaterial("homes-gui.close-button.material", Material.BARRIER);
    }

    public String getHomesCloseButtonName() {
        return this.msg.colorize(this.guiConfig.getString("homes-gui.close-button.name", "&c&lFermer"));
    }

    public List<String> getHomesCloseButtonLore() {
        return this.colorizeList(this.guiConfig.getStringList("homes-gui.close-button.lore"));
    }

    public int getHomesCloseButtonSlot() {
        return this.guiConfig.getInt("homes-gui.close-button.slot", 8);
    }

    public boolean isHomesCloseButtonEnabled() {
        return this.guiConfig.getBoolean("homes-gui.close-button.enabled", true);
    }

    public boolean isHomesDecorationEnabled() {
        return this.guiConfig.getBoolean("homes-gui.decoration.enabled", false);
    }

    public Material getHomesDecorationMaterial() {
        return this.getMaterial("homes-gui.decoration.material", Material.GRAY_STAINED_GLASS_PANE);
    }

    public String getHomesDecorationName() {
        return this.msg.colorize(this.guiConfig.getString("homes-gui.decoration.name", " "));
    }

    public List<Integer> getHomesDecorationSlots() {
        return this.guiConfig.getIntegerList("homes-gui.decoration.slots");
    }

    public boolean isWarpsGUIEnabled() {
        return this.guiConfig.getBoolean("warps-gui.enabled", true);
    }

    public String getWarpsTitle() {
        return this.msg.colorize(this.guiConfig.getString("warps-gui.title", "&5&lWarps du Serveur &8({count})"));
    }

    public String getWarpsSizeConfig() {
        return this.guiConfig.getString("warps-gui.size", "auto");
    }

    public boolean isDynamicWarpsEnabled() {
        return this.guiConfig.getBoolean("warps-gui.dynamic-warps.enabled", true);
    }

    public int getDynamicWarpsStartSlot() {
        return this.guiConfig.getInt("warps-gui.dynamic-warps.start-slot", 10);
    }

    public Material getWarpItemMaterial() {
        return this.getMaterial("warps-gui.dynamic-warps.warp-item.material", Material.ENDER_PEARL);
    }

    public String getWarpItemName() {
        return this.msg.colorize(this.guiConfig.getString("warps-gui.dynamic-warps.warp-item.name", "&d&l{warp}"));
    }

    public List<String> getWarpItemLore() {
        return this.colorizeList(this.guiConfig.getStringList("warps-gui.dynamic-warps.warp-item.lore"));
    }

    public Material getWarpLockedMaterial() {
        return this.getMaterial("warps-gui.dynamic-warps.warp-locked-item.material", Material.ENDER_EYE);
    }

    public String getWarpLockedName() {
        return this.msg.colorize(this.guiConfig.getString("warps-gui.dynamic-warps.warp-locked-item.name", "&d&l{warp}"));
    }

    public List<String> getWarpLockedLore() {
        return this.colorizeList(this.guiConfig.getStringList("warps-gui.dynamic-warps.warp-locked-item.lore"));
    }

    public boolean isStaticWarpsEnabled() {
        return this.guiConfig.getBoolean("warps-gui.static-warps.enabled", true);
    }

    public List<StaticTeleportItem> getStaticWarps() {
        return new ArrayList<StaticTeleportItem>(this.staticWarpsCache.getOrDefault("default", new ArrayList()));
    }

    public Material getWarpsInfoButtonMaterial() {
        return this.getMaterial("warps-gui.info-button.material", Material.BOOK);
    }

    public String getWarpsInfoButtonName() {
        return this.msg.colorize(this.guiConfig.getString("warps-gui.info-button.name", "&e&lInformations"));
    }

    public List<String> getWarpsInfoButtonLore() {
        return this.colorizeList(this.guiConfig.getStringList("warps-gui.info-button.lore"));
    }

    public int getWarpsInfoButtonSlot() {
        return this.guiConfig.getInt("warps-gui.info-button.slot", 4);
    }

    public boolean isWarpsInfoButtonEnabled() {
        return this.guiConfig.getBoolean("warps-gui.info-button.enabled", true);
    }

    public Material getWarpsCloseButtonMaterial() {
        return this.getMaterial("warps-gui.close-button.material", Material.BARRIER);
    }

    public String getWarpsCloseButtonName() {
        return this.msg.colorize(this.guiConfig.getString("warps-gui.close-button.name", "&c&lFermer"));
    }

    public List<String> getWarpsCloseButtonLore() {
        return this.colorizeList(this.guiConfig.getStringList("warps-gui.close-button.lore"));
    }

    public int getWarpsCloseButtonSlot() {
        return this.guiConfig.getInt("warps-gui.close-button.slot", 8);
    }

    public boolean isWarpsCloseButtonEnabled() {
        return this.guiConfig.getBoolean("warps-gui.close-button.enabled", true);
    }

    public boolean isWarpsDecorationEnabled() {
        return this.guiConfig.getBoolean("warps-gui.decoration.enabled", false);
    }

    public Material getWarpsDecorationMaterial() {
        return this.getMaterial("warps-gui.decoration.material", Material.GRAY_STAINED_GLASS_PANE);
    }

    public String getWarpsDecorationName() {
        return this.msg.colorize(this.guiConfig.getString("warps-gui.decoration.name", " "));
    }

    public List<Integer> getWarpsDecorationSlots() {
        return this.guiConfig.getIntegerList("warps-gui.decoration.slots");
    }

    public boolean isSoundEnabled() {
        return this.guiConfig.getBoolean("sounds.enabled", true);
    }

    public Sound getOpenGUISound() {
        return this.getSound("sounds.open-gui", Sound.UI_BUTTON_CLICK);
    }

    public Sound getClickItemSound() {
        return this.getSound("sounds.click-item", Sound.UI_BUTTON_CLICK);
    }

    public Sound getTeleportSound() {
        return this.getSound("sounds.teleport", Sound.ENTITY_ENDERMAN_TELEPORT);
    }

    public Sound getErrorSound() {
        return this.getSound("sounds.error", Sound.ENTITY_VILLAGER_NO);
    }

    public float getSoundVolume() {
        return (float)this.guiConfig.getDouble("sounds.volume", 1.0);
    }

    public float getSoundPitch() {
        return (float)this.guiConfig.getDouble("sounds.pitch", 1.0);
    }

    public boolean isPreventItemTake() {
        return this.guiConfig.getBoolean("general.prevent-item-take", true);
    }

    public boolean isPreventItemPlace() {
        return this.guiConfig.getBoolean("general.prevent-item-place", true);
    }

    public boolean isCloseAfterTeleport() {
        return this.guiConfig.getBoolean("general.close-after-teleport", true);
    }

    public boolean isRefreshAfterDelete() {
        return this.guiConfig.getBoolean("general.refresh-after-delete", true);
    }

    private Material getMaterial(String path, Material defaultMaterial) {
        String materialName = this.guiConfig.getString(path);
        if (materialName == null) {
            return defaultMaterial;
        }
        try {
            return Material.valueOf((String)materialName.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().warning("Material invalide dans guis.yml: " + path + " = " + materialName);
            return defaultMaterial;
        }
    }

    private Sound getSound(String path, Sound defaultSound) {
        String soundName = this.guiConfig.getString(path);
        if (soundName == null) {
            return defaultSound;
        }
        try {
            return Sound.valueOf((String)soundName.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().warning("Sound invalide dans guis.yml: " + path + " = " + soundName);
            return defaultSound;
        }
    }

    private List<String> colorizeList(List<String> list) {
        list.replaceAll(this.msg::colorize);
        return list;
    }

    public String replacePlaceholders(String text, Map<String, String> placeholders) {
        for (Map.Entry<String, String> entry : placeholders.entrySet()) {
            text = text.replace("{" + entry.getKey() + "}", entry.getValue());
        }
        return text;
    }

    public List<String> replacePlaceholders(List<String> list, Map<String, String> placeholders) {
        list.replaceAll(line -> this.replacePlaceholders((String)line, placeholders));
        return list;
    }
}

