/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.mycommands.managers;

import fr.skynex.mycommands.MyCommands;
import fr.skynex.mycommands.libs.hikari.HikariConfig;
import fr.skynex.mycommands.libs.hikari.HikariDataSource;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class StatisticsManager {
    private final MyCommands plugin;
    private final boolean useMySQL;
    private File statsFile;
    private FileConfiguration statsConfig;
    private HikariDataSource hikariDataSource;
    private final Map<UUID, PlayerStats> statsCache = new ConcurrentHashMap<UUID, PlayerStats>();
    private long totalTeleports = 0L;
    private long totalHomesCreated = 0L;
    private long totalMessagesSent = 0L;

    public StatisticsManager(MyCommands plugin) {
        this.plugin = plugin;
        String storageType = plugin.getConfig().getString("storage.type", "yaml").toLowerCase();
        this.useMySQL = storageType.equals("mysql");
        if (this.useMySQL) {
            plugin.getLogger().info("StatisticsManager: Using MySQL storage");
            this.initializeMySQLTables();
        } else {
            plugin.getLogger().info("StatisticsManager: Using YAML storage");
            this.statsFile = new File(plugin.getDataFolder(), "statistics.yml");
            this.loadStatsFile();
        }
        this.loadGlobalStats();
    }

    private void loadStatsFile() {
        if (!this.statsFile.exists()) {
            try {
                this.statsFile.getParentFile().mkdirs();
                this.statsFile.createNewFile();
                this.plugin.getLogger().info("Created statistics.yml");
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Failed to create statistics.yml: " + e.getMessage());
            }
        }
        this.statsConfig = YamlConfiguration.loadConfiguration((File)this.statsFile);
    }

    private void saveStatsFile() {
        try {
            this.statsConfig.save(this.statsFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to save statistics.yml: " + e.getMessage());
        }
    }

    private void initializeMySQLTables() {
        try {
            HikariConfig config = new HikariConfig();
            config.setJdbcUrl("jdbc:mysql://" + this.plugin.getConfig().getString("storage.mysql.host", "localhost") + ":" + this.plugin.getConfig().getInt("storage.mysql.port", 3306) + "/" + this.plugin.getConfig().getString("storage.mysql.database", "mycommands"));
            config.setUsername(this.plugin.getConfig().getString("storage.mysql.username", "root"));
            config.setPassword(this.plugin.getConfig().getString("storage.mysql.password", ""));
            config.setMaximumPoolSize(this.plugin.getConfig().getInt("storage.mysql.pool-size", 10));
            config.setMinimumIdle(2);
            config.setMaxLifetime(1800000L);
            config.setConnectionTimeout(5000L);
            config.addDataSourceProperty("cachePrepStmts", "true");
            config.addDataSourceProperty("prepStmtCacheSize", "250");
            config.addDataSourceProperty("prepStmtCacheSqlLimit", "2048");
            config.addDataSourceProperty("useServerPrepStmts", "true");
            this.hikariDataSource = new HikariDataSource(config);
            this.plugin.getLogger().info("StatisticsManager: HikariCP initialized");
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Failed to initialize HikariCP for statistics: " + e.getMessage());
            e.printStackTrace();
            return;
        }
        String createPlayerStats = "CREATE TABLE IF NOT EXISTS mycommands_player_statistics (uuid VARCHAR(36) PRIMARY KEY, teleports_home INT DEFAULT 0, teleports_warp INT DEFAULT 0, teleports_spawn INT DEFAULT 0, teleports_tpa INT DEFAULT 0, teleports_back INT DEFAULT 0, teleports_admin INT DEFAULT 0, homes_created INT DEFAULT 0, messages_sent INT DEFAULT 0, first_join BIGINT, last_seen BIGINT)";
        String createHomeTeleports = "CREATE TABLE IF NOT EXISTS mycommands_home_teleports (id INT AUTO_INCREMENT PRIMARY KEY, uuid VARCHAR(36), home_name VARCHAR(64), teleport_count INT DEFAULT 0, UNIQUE KEY unique_home (uuid, home_name))";
        String createGlobalStats = "CREATE TABLE IF NOT EXISTS mycommands_global_statistics (stat_key VARCHAR(64) PRIMARY KEY, stat_value BIGINT DEFAULT 0)";
        try (Connection conn = this.getConnection();){
            conn.createStatement().execute(createPlayerStats);
            conn.createStatement().execute(createHomeTeleports);
            conn.createStatement().execute(createGlobalStats);
            this.plugin.getLogger().info("StatisticsManager: MySQL tables created/verified");
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Failed to create MySQL statistics tables: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private Connection getConnection() throws SQLException {
        if (this.hikariDataSource == null) {
            throw new SQLException("HikariDataSource is not initialized");
        }
        return this.hikariDataSource.getConnection();
    }

    public void incrementTeleports(Player player, TeleportType type) {
        PlayerStats stats = this.getOrCreateStats(player.getUniqueId());
        stats.incrementTeleports(type);
        ++this.totalTeleports;
        this.saveStatsAsync(player.getUniqueId());
    }

    public void incrementHomeTeleport(Player player, String homeName) {
        PlayerStats stats = this.getOrCreateStats(player.getUniqueId());
        stats.incrementTeleports(TeleportType.HOME);
        stats.incrementHomeTeleport(homeName);
        ++this.totalTeleports;
        this.saveStatsAsync(player.getUniqueId());
    }

    public int getHomeTeleports(Player player, String homeName) {
        return this.getHomeTeleports(player.getUniqueId(), homeName);
    }

    public int getHomeTeleports(UUID uuid, String homeName) {
        PlayerStats stats = this.getStats(uuid);
        return stats.getHomeTeleports(homeName);
    }

    public int getTeleports(UUID uuid, TeleportType type) {
        PlayerStats stats = this.getStats(uuid);
        return stats.getTeleports(type);
    }

    public int getTotalTeleports(UUID uuid) {
        PlayerStats stats = this.getStats(uuid);
        return stats.getTotalTeleports();
    }

    public void incrementHomesCreated(Player player) {
        PlayerStats stats = this.getOrCreateStats(player.getUniqueId());
        stats.incrementHomesCreated();
        ++this.totalHomesCreated;
        this.saveStatsAsync(player.getUniqueId());
    }

    public int getHomesCreated(UUID uuid) {
        PlayerStats stats = this.getStats(uuid);
        return stats.getHomesCreated();
    }

    public void removeHomeStats(UUID uuid, String homeName) {
        PlayerStats stats = this.getStats(uuid);
        stats.removeHomeStats(homeName);
        this.saveStatsAsync(uuid);
    }

    public void incrementMessagesSent(Player player) {
        PlayerStats stats = this.getOrCreateStats(player.getUniqueId());
        stats.incrementMessagesSent();
        ++this.totalMessagesSent;
        this.saveStatsAsync(player.getUniqueId());
    }

    public int getMessagesSent(UUID uuid) {
        PlayerStats stats = this.getStats(uuid);
        return stats.getMessagesSent();
    }

    public PlayerStats getStats(UUID uuid) {
        PlayerStats stats = this.statsCache.get(uuid);
        if (stats == null) {
            stats = this.loadStats(uuid);
            this.statsCache.put(uuid, stats);
        }
        return stats;
    }

    private PlayerStats getOrCreateStats(UUID uuid) {
        return this.statsCache.computeIfAbsent(uuid, k -> this.loadStats((UUID)k));
    }

    private PlayerStats loadStats(UUID uuid) {
        if (this.useMySQL) {
            return this.loadStatsMySQL(uuid);
        }
        return this.loadStatsYAML(uuid);
    }

    private PlayerStats loadStatsYAML(UUID uuid) {
        String path = "players." + uuid.toString();
        if (!this.statsConfig.contains(path)) {
            return new PlayerStats();
        }
        ConfigurationSection section = this.statsConfig.getConfigurationSection(path);
        if (section == null) {
            return new PlayerStats();
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (section.contains("teleports")) {
            data.put("teleports", section.getConfigurationSection("teleports").getValues(false));
        }
        if (section.contains("homeTeleports")) {
            data.put("homeTeleports", section.getConfigurationSection("homeTeleports").getValues(false));
        }
        data.put("homesCreated", section.getInt("homesCreated", 0));
        data.put("messagesSent", section.getInt("messagesSent", 0));
        data.put("firstJoin", section.getLong("firstJoin", System.currentTimeMillis()));
        data.put("lastSeen", section.getLong("lastSeen", System.currentTimeMillis()));
        return PlayerStats.fromMap(data);
    }

    private PlayerStats loadStatsMySQL(UUID uuid) {
        PlayerStats stats = new PlayerStats();
        String sql = "SELECT * FROM mycommands_player_statistics WHERE uuid = ?";
        try (Connection conn = this.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setString(1, uuid.toString());
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    stats.teleports.put(TeleportType.HOME, rs.getInt("teleports_home"));
                    stats.teleports.put(TeleportType.WARP, rs.getInt("teleports_warp"));
                    stats.teleports.put(TeleportType.SPAWN, rs.getInt("teleports_spawn"));
                    stats.teleports.put(TeleportType.TPA, rs.getInt("teleports_tpa"));
                    stats.teleports.put(TeleportType.BACK, rs.getInt("teleports_back"));
                    stats.teleports.put(TeleportType.ADMIN, rs.getInt("teleports_admin"));
                    stats.setHomesCreated(rs.getInt("homes_created"));
                    stats.setMessagesSent(rs.getInt("messages_sent"));
                    stats.setFirstJoin(rs.getLong("first_join"));
                    stats.setLastSeen(rs.getLong("last_seen"));
                }
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to load stats from MySQL for " + String.valueOf(uuid) + ": " + e.getMessage());
        }
        String homeTpSql = "SELECT home_name, teleport_count FROM mycommands_home_teleports WHERE uuid = ?";
        try (Connection conn = this.getConnection();
             PreparedStatement homeTpPs = conn.prepareStatement(homeTpSql);){
            homeTpPs.setString(1, uuid.toString());
            try (ResultSet homeTpRs = homeTpPs.executeQuery();){
                while (homeTpRs.next()) {
                    String homeName = homeTpRs.getString("home_name");
                    int count = homeTpRs.getInt("teleport_count");
                    stats.homeTeleports.put(homeName, count);
                }
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to load home teleports from MySQL for " + String.valueOf(uuid) + ": " + e.getMessage());
        }
        return stats;
    }

    private void saveStatsAsync(UUID uuid) {
        PlayerStats stats = this.statsCache.get(uuid);
        if (stats == null) {
            return;
        }
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> this.saveStats(uuid, stats));
    }

    private void saveStats(UUID uuid, PlayerStats stats) {
        if (this.useMySQL) {
            this.saveStatsMySQL(uuid, stats);
        } else {
            this.saveStatsYAML(uuid, stats);
        }
    }

    private void saveStatsYAML(UUID uuid, PlayerStats stats) {
        String path = "players." + uuid.toString();
        Map<String, Object> data = stats.toMap();
        Map teleports = (Map)data.get("teleports");
        for (Map.Entry entry : teleports.entrySet()) {
            this.statsConfig.set(path + ".teleports." + ((TeleportType)((Object)entry.getKey())).name(), entry.getValue());
        }
        Map homeTeleports = (Map)data.get("homeTeleports");
        this.statsConfig.set(path + ".homeTeleports", null);
        for (Map.Entry entry : homeTeleports.entrySet()) {
            this.statsConfig.set(path + ".homeTeleports." + (String)entry.getKey(), entry.getValue());
        }
        this.statsConfig.set(path + ".homesCreated", data.get("homesCreated"));
        this.statsConfig.set(path + ".messagesSent", data.get("messagesSent"));
        this.statsConfig.set(path + ".firstJoin", data.get("firstJoin"));
        this.statsConfig.set(path + ".lastSeen", data.get("lastSeen"));
        this.saveStatsFile();
    }

    private void saveStatsMySQL(UUID uuid, PlayerStats stats) {
        String sql = "INSERT INTO mycommands_player_statistics (uuid, teleports_home, teleports_warp, teleports_spawn, teleports_tpa, teleports_back, teleports_admin, homes_created, messages_sent, first_join, last_seen) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?) ON DUPLICATE KEY UPDATE teleports_home = VALUES(teleports_home), teleports_warp = VALUES(teleports_warp), teleports_spawn = VALUES(teleports_spawn), teleports_tpa = VALUES(teleports_tpa), teleports_back = VALUES(teleports_back), teleports_admin = VALUES(teleports_admin), homes_created = VALUES(homes_created), messages_sent = VALUES(messages_sent), first_join = VALUES(first_join), last_seen = VALUES(last_seen)";
        try (Connection conn = this.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setString(1, uuid.toString());
            ps.setInt(2, stats.getTeleports(TeleportType.HOME));
            ps.setInt(3, stats.getTeleports(TeleportType.WARP));
            ps.setInt(4, stats.getTeleports(TeleportType.SPAWN));
            ps.setInt(5, stats.getTeleports(TeleportType.TPA));
            ps.setInt(6, stats.getTeleports(TeleportType.BACK));
            ps.setInt(7, stats.getTeleports(TeleportType.ADMIN));
            ps.setInt(8, stats.getHomesCreated());
            ps.setInt(9, stats.getMessagesSent());
            ps.setLong(10, stats.getFirstJoin());
            ps.setLong(11, stats.getLastSeen());
            ps.executeUpdate();
            String deleteHomeTpSql = "DELETE FROM mycommands_home_teleports WHERE uuid = ?";
            try (PreparedStatement deletePs = conn.prepareStatement(deleteHomeTpSql);){
                deletePs.setString(1, uuid.toString());
                deletePs.executeUpdate();
            }
            String insertHomeTpSql = "INSERT INTO mycommands_home_teleports (uuid, home_name, teleport_count) VALUES (?, ?, ?)";
            try (PreparedStatement insertPs = conn.prepareStatement(insertHomeTpSql);){
                for (Map.Entry<String, Integer> entry : stats.getAllHomeTeleports().entrySet()) {
                    insertPs.setString(1, uuid.toString());
                    insertPs.setString(2, entry.getKey());
                    insertPs.setInt(3, entry.getValue());
                    insertPs.addBatch();
                }
                insertPs.executeBatch();
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to save stats to MySQL for " + String.valueOf(uuid) + ": " + e.getMessage());
        }
    }

    public void resetStats(UUID uuid) {
        PlayerStats stats = this.getOrCreateStats(uuid);
        stats.reset();
        this.saveStatsAsync(uuid);
    }

    private void loadGlobalStats() {
        if (this.useMySQL) {
            this.loadGlobalStatsMySQL();
        } else {
            this.loadGlobalStatsYAML();
        }
    }

    private void loadGlobalStatsYAML() {
        this.totalTeleports = this.statsConfig.getLong("global.totalTeleports", 0L);
        this.totalHomesCreated = this.statsConfig.getLong("global.totalHomesCreated", 0L);
        this.totalMessagesSent = this.statsConfig.getLong("global.totalMessagesSent", 0L);
    }

    private void loadGlobalStatsMySQL() {
        String sql = "SELECT stat_key, stat_value FROM mycommands_global_statistics";
        try (Connection conn = this.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                String key = rs.getString("stat_key");
                long value = rs.getLong("stat_value");
                switch (key) {
                    case "totalTeleports": {
                        this.totalTeleports = value;
                        break;
                    }
                    case "totalHomesCreated": {
                        this.totalHomesCreated = value;
                        break;
                    }
                    case "totalMessagesSent": {
                        this.totalMessagesSent = value;
                    }
                }
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to load global stats from MySQL: " + e.getMessage());
        }
    }

    private void saveGlobalStats() {
        if (this.useMySQL) {
            this.saveGlobalStatsMySQL();
        } else {
            this.saveGlobalStatsYAML();
        }
    }

    private void saveGlobalStatsYAML() {
        this.statsConfig.set("global.totalTeleports", (Object)this.totalTeleports);
        this.statsConfig.set("global.totalHomesCreated", (Object)this.totalHomesCreated);
        this.statsConfig.set("global.totalMessagesSent", (Object)this.totalMessagesSent);
        this.saveStatsFile();
    }

    private void saveGlobalStatsMySQL() {
        String sql = "INSERT INTO mycommands_global_statistics (stat_key, stat_value) VALUES (?, ?) ON DUPLICATE KEY UPDATE stat_value = VALUES(stat_value)";
        try (Connection conn = this.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setString(1, "totalTeleports");
            ps.setLong(2, this.totalTeleports);
            ps.addBatch();
            ps.setString(1, "totalHomesCreated");
            ps.setLong(2, this.totalHomesCreated);
            ps.addBatch();
            ps.setString(1, "totalMessagesSent");
            ps.setLong(2, this.totalMessagesSent);
            ps.addBatch();
            ps.executeBatch();
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to save global stats to MySQL: " + e.getMessage());
        }
    }

    public long getGlobalTeleports() {
        return this.totalTeleports;
    }

    public long getGlobalHomesCreated() {
        return this.totalHomesCreated;
    }

    public long getGlobalMessagesSent() {
        return this.totalMessagesSent;
    }

    public Map<UUID, Integer> getTopTeleports(int limit) {
        HashMap<UUID, Integer> top = new HashMap<UUID, Integer>();
        this.statsCache.entrySet().stream().sorted((e1, e2) -> Integer.compare(((PlayerStats)e2.getValue()).getTotalTeleports(), ((PlayerStats)e1.getValue()).getTotalTeleports())).limit(limit).forEach(e -> top.put((UUID)e.getKey(), ((PlayerStats)e.getValue()).getTotalTeleports()));
        return top;
    }

    public Map<UUID, Integer> getTopHomesCreated(int limit) {
        HashMap<UUID, Integer> top = new HashMap<UUID, Integer>();
        this.statsCache.entrySet().stream().sorted((e1, e2) -> Integer.compare(((PlayerStats)e2.getValue()).getHomesCreated(), ((PlayerStats)e1.getValue()).getHomesCreated())).limit(limit).forEach(e -> top.put((UUID)e.getKey(), ((PlayerStats)e.getValue()).getHomesCreated()));
        return top;
    }

    public Map<UUID, Integer> getTopMessagesSent(int limit) {
        HashMap<UUID, Integer> top = new HashMap<UUID, Integer>();
        this.statsCache.entrySet().stream().sorted((e1, e2) -> Integer.compare(((PlayerStats)e2.getValue()).getMessagesSent(), ((PlayerStats)e1.getValue()).getMessagesSent())).limit(limit).forEach(e -> top.put((UUID)e.getKey(), ((PlayerStats)e.getValue()).getMessagesSent()));
        return top;
    }

    public void saveAll() {
        this.plugin.getLogger().info("Saving all statistics...");
        for (Map.Entry<UUID, PlayerStats> entry : this.statsCache.entrySet()) {
            this.saveStats(entry.getKey(), entry.getValue());
        }
        this.saveGlobalStats();
        this.plugin.getLogger().info("Statistics saved for " + this.statsCache.size() + " players");
    }

    public void shutdown() {
        this.saveAll();
        this.statsCache.clear();
        if (this.useMySQL && this.hikariDataSource != null) {
            this.hikariDataSource.close();
            this.plugin.getLogger().info("StatisticsManager: HikariCP closed");
        }
        this.plugin.getLogger().info("StatisticsManager shutdown complete");
    }

    public void printStats() {
        this.plugin.getLogger().info("=== StatisticsManager Stats ===");
        this.plugin.getLogger().info("Storage type: " + (this.useMySQL ? "MySQL" : "YAML"));
        this.plugin.getLogger().info("Cached players: " + this.statsCache.size());
        this.plugin.getLogger().info("Global teleports: " + this.totalTeleports);
        this.plugin.getLogger().info("Global homes created: " + this.totalHomesCreated);
        this.plugin.getLogger().info("Global messages sent: " + this.totalMessagesSent);
    }

    public static class PlayerStats {
        private final Map<TeleportType, Integer> teleports = new HashMap<TeleportType, Integer>();
        private final Map<String, Integer> homeTeleports = new HashMap<String, Integer>();
        private int homesCreated = 0;
        private int messagesSent = 0;
        private long firstJoin = System.currentTimeMillis();
        private long lastSeen = System.currentTimeMillis();

        public PlayerStats() {
            for (TeleportType type : TeleportType.values()) {
                this.teleports.put(type, 0);
            }
        }

        public void incrementTeleports(TeleportType type) {
            this.teleports.put(type, this.teleports.getOrDefault((Object)type, 0) + 1);
            this.updateLastSeen();
        }

        public int getTeleports(TeleportType type) {
            return this.teleports.getOrDefault((Object)type, 0);
        }

        public int getTotalTeleports() {
            return this.teleports.values().stream().mapToInt(Integer::intValue).sum();
        }

        public Map<TeleportType, Integer> getAllTeleports() {
            return new HashMap<TeleportType, Integer>(this.teleports);
        }

        public void incrementHomeTeleport(String homeName) {
            this.homeTeleports.put(homeName, this.homeTeleports.getOrDefault(homeName, 0) + 1);
            this.updateLastSeen();
        }

        public int getHomeTeleports(String homeName) {
            return this.homeTeleports.getOrDefault(homeName, 0);
        }

        public Map<String, Integer> getAllHomeTeleports() {
            return new HashMap<String, Integer>(this.homeTeleports);
        }

        public void removeHomeStats(String homeName) {
            this.homeTeleports.remove(homeName);
        }

        public void incrementHomesCreated() {
            ++this.homesCreated;
            this.updateLastSeen();
        }

        public int getHomesCreated() {
            return this.homesCreated;
        }

        public void setHomesCreated(int count) {
            this.homesCreated = count;
        }

        public void incrementMessagesSent() {
            ++this.messagesSent;
            this.updateLastSeen();
        }

        public int getMessagesSent() {
            return this.messagesSent;
        }

        public void setMessagesSent(int count) {
            this.messagesSent = count;
        }

        public long getFirstJoin() {
            return this.firstJoin;
        }

        public void setFirstJoin(long timestamp) {
            this.firstJoin = timestamp;
        }

        public long getLastSeen() {
            return this.lastSeen;
        }

        public void setLastSeen(long timestamp) {
            this.lastSeen = timestamp;
        }

        public void updateLastSeen() {
            this.lastSeen = System.currentTimeMillis();
        }

        public void reset() {
            this.teleports.clear();
            for (TeleportType type : TeleportType.values()) {
                this.teleports.put(type, 0);
            }
            this.homeTeleports.clear();
            this.homesCreated = 0;
            this.messagesSent = 0;
        }

        public Map<String, Object> toMap() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("teleports", new HashMap<TeleportType, Integer>(this.teleports));
            map.put("homeTeleports", new HashMap<String, Integer>(this.homeTeleports));
            map.put("homesCreated", this.homesCreated);
            map.put("messagesSent", this.messagesSent);
            map.put("firstJoin", this.firstJoin);
            map.put("lastSeen", this.lastSeen);
            return map;
        }

        public static PlayerStats fromMap(Map<String, Object> map) {
            PlayerStats stats = new PlayerStats();
            if (map.containsKey("teleports")) {
                Map tpMap = (Map)map.get("teleports");
                for (Map.Entry entry : tpMap.entrySet()) {
                    try {
                        TeleportType type = TeleportType.valueOf((String)entry.getKey());
                        stats.teleports.put(type, (Integer)entry.getValue());
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
            }
            if (map.containsKey("homeTeleports")) {
                Map homeTpMap = (Map)map.get("homeTeleports");
                stats.homeTeleports.putAll(homeTpMap);
            }
            if (map.containsKey("homesCreated")) {
                stats.homesCreated = (Integer)map.get("homesCreated");
            }
            if (map.containsKey("messagesSent")) {
                stats.messagesSent = (Integer)map.get("messagesSent");
            }
            if (map.containsKey("firstJoin")) {
                stats.firstJoin = (Long)map.get("firstJoin");
            }
            if (map.containsKey("lastSeen")) {
                stats.lastSeen = (Long)map.get("lastSeen");
            }
            return stats;
        }

        public String toString() {
            return "PlayerStats{totalTeleports=" + this.getTotalTeleports() + ", homesCreated=" + this.homesCreated + ", messagesSent=" + this.messagesSent + ", trackedHomes=" + this.homeTeleports.size() + "}";
        }
    }

    public static enum TeleportType {
        HOME,
        WARP,
        SPAWN,
        TPA,
        BACK,
        ADMIN;

    }
}

