/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.mycommands.storage;

import fr.skynex.mycommands.MyCommands;
import fr.skynex.mycommands.storage.MySQLStorage;
import fr.skynex.mycommands.storage.StorageProvider;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;

public class SQLOptimizer {
    private final MyCommands plugin;
    private MySQLStorage storage;
    private int batchSize;
    private boolean batchEnabled;

    public SQLOptimizer(MyCommands plugin, MySQLStorage storage) {
        this.plugin = plugin;
        this.storage = storage;
        this.loadConfig();
    }

    public SQLOptimizer(MyCommands plugin) {
        this.plugin = plugin;
        StorageProvider storageProvider = plugin.getDataManager().getStorage();
        if (storageProvider instanceof MySQLStorage) {
            this.storage = (MySQLStorage)storageProvider;
        } else {
            plugin.getLogger().warning("SQLOptimizer: Storage is not MySQL, batch operations will be disabled");
            this.storage = null;
        }
        this.loadConfig();
    }

    private void loadConfig() {
        this.batchEnabled = this.plugin.getConfig().getBoolean("database.batch-enabled", true);
        this.batchSize = this.plugin.getConfig().getInt("database.batch-size", 100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int batchSaveHomes(Map<UUID, Map<String, Location>> homesData) {
        if (!this.batchEnabled || homesData.isEmpty() || this.storage == null) {
            return 0;
        }
        int savedCount = 0;
        Connection conn = null;
        try {
            conn = this.storage.getConnection();
            conn.setAutoCommit(false);
            String sql = "INSERT INTO homes (uuid, name, world, x, y, z, yaw, pitch) VALUES (?, ?, ?, ?, ?, ?, ?, ?) ON DUPLICATE KEY UPDATE world = VALUES(world), x = VALUES(x), y = VALUES(y), z = VALUES(z), yaw = VALUES(yaw), pitch = VALUES(pitch)";
            try (PreparedStatement ps = conn.prepareStatement(sql);){
                int batchCount = 0;
                for (Map.Entry<UUID, Map<String, Location>> playerEntry : homesData.entrySet()) {
                    UUID uuid = playerEntry.getKey();
                    for (Map.Entry<String, Location> homeEntry : playerEntry.getValue().entrySet()) {
                        String homeName = homeEntry.getKey();
                        Location loc = homeEntry.getValue();
                        ps.setString(1, uuid.toString());
                        ps.setString(2, homeName);
                        ps.setString(3, loc.getWorld().getName());
                        ps.setDouble(4, loc.getX());
                        ps.setDouble(5, loc.getY());
                        ps.setDouble(6, loc.getZ());
                        ps.setFloat(7, loc.getYaw());
                        ps.setFloat(8, loc.getPitch());
                        ps.addBatch();
                        if (++batchCount < this.batchSize) continue;
                        int[] results = ps.executeBatch();
                        savedCount += results.length;
                        batchCount = 0;
                    }
                }
                if (batchCount > 0) {
                    int[] results = ps.executeBatch();
                    savedCount += results.length;
                }
                conn.commit();
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Erreur lors du batch save homes: " + e.getMessage());
            if (this.plugin.getConfig().getBoolean("debug.enabled", false)) {
                e.printStackTrace();
            }
        }
        finally {
            if (conn != null) {
                try {
                    conn.setAutoCommit(true);
                    conn.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return savedCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int batchDeleteHomes(List<HomeEntry> homesToDelete) {
        if (!this.batchEnabled || homesToDelete.isEmpty() || this.storage == null) {
            return 0;
        }
        int deletedCount = 0;
        Connection conn = null;
        try {
            conn = this.storage.getConnection();
            conn.setAutoCommit(false);
            String sql = "DELETE FROM homes WHERE uuid = ? AND name = ?";
            try (PreparedStatement ps = conn.prepareStatement(sql);){
                int batchCount = 0;
                for (HomeEntry entry : homesToDelete) {
                    ps.setString(1, entry.uuid.toString());
                    ps.setString(2, entry.homeName);
                    ps.addBatch();
                    if (++batchCount < this.batchSize) continue;
                    int[] results = ps.executeBatch();
                    deletedCount += results.length;
                    batchCount = 0;
                }
                if (batchCount > 0) {
                    int[] results = ps.executeBatch();
                    deletedCount += results.length;
                }
                conn.commit();
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Erreur lors du batch delete homes: " + e.getMessage());
        }
        finally {
            if (conn != null) {
                try {
                    conn.setAutoCommit(true);
                    conn.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return deletedCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int batchSaveWarps(Map<String, Location> warpsData) {
        if (!this.batchEnabled || warpsData.isEmpty() || this.storage == null) {
            return 0;
        }
        int savedCount = 0;
        Connection conn = null;
        try {
            conn = this.storage.getConnection();
            conn.setAutoCommit(false);
            String sql = "INSERT INTO warps (name, world, x, y, z, yaw, pitch) VALUES (?, ?, ?, ?, ?, ?, ?) ON DUPLICATE KEY UPDATE world = VALUES(world), x = VALUES(x), y = VALUES(y), z = VALUES(z), yaw = VALUES(yaw), pitch = VALUES(pitch)";
            try (PreparedStatement ps = conn.prepareStatement(sql);){
                int batchCount = 0;
                for (Map.Entry<String, Location> entry : warpsData.entrySet()) {
                    String warpName = entry.getKey();
                    Location loc = entry.getValue();
                    ps.setString(1, warpName);
                    ps.setString(2, loc.getWorld().getName());
                    ps.setDouble(3, loc.getX());
                    ps.setDouble(4, loc.getY());
                    ps.setDouble(5, loc.getZ());
                    ps.setFloat(6, loc.getYaw());
                    ps.setFloat(7, loc.getPitch());
                    ps.addBatch();
                    if (++batchCount < this.batchSize) continue;
                    int[] results = ps.executeBatch();
                    savedCount += results.length;
                    batchCount = 0;
                }
                if (batchCount > 0) {
                    int[] results = ps.executeBatch();
                    savedCount += results.length;
                }
                conn.commit();
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Erreur lors du batch save warps: " + e.getMessage());
        }
        finally {
            if (conn != null) {
                try {
                    conn.setAutoCommit(true);
                    conn.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return savedCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int batchSaveStatistics(Map<UUID, Map<String, Integer>> statsData) {
        if (!this.batchEnabled || statsData.isEmpty() || this.storage == null) {
            return 0;
        }
        int savedCount = 0;
        Connection conn = null;
        try {
            conn = this.storage.getConnection();
            conn.setAutoCommit(false);
            String sql = "INSERT INTO statistics (uuid, stat_key, stat_value) VALUES (?, ?, ?) ON DUPLICATE KEY UPDATE stat_value = VALUES(stat_value)";
            try (PreparedStatement ps = conn.prepareStatement(sql);){
                int batchCount = 0;
                for (Map.Entry<UUID, Map<String, Integer>> playerEntry : statsData.entrySet()) {
                    UUID uuid = playerEntry.getKey();
                    for (Map.Entry<String, Integer> statEntry : playerEntry.getValue().entrySet()) {
                        ps.setString(1, uuid.toString());
                        ps.setString(2, statEntry.getKey());
                        ps.setInt(3, statEntry.getValue());
                        ps.addBatch();
                        if (++batchCount < this.batchSize) continue;
                        int[] results = ps.executeBatch();
                        savedCount += results.length;
                        batchCount = 0;
                    }
                }
                if (batchCount > 0) {
                    int[] results = ps.executeBatch();
                    savedCount += results.length;
                }
                conn.commit();
            }
            catch (SQLException e) {
                conn.rollback();
                throw e;
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Erreur lors du batch save statistics: " + e.getMessage());
        }
        finally {
            if (conn != null) {
                try {
                    conn.setAutoCommit(true);
                    conn.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return savedCount;
    }

    public void reload() {
        this.loadConfig();
    }

    public static class HomeEntry {
        public final UUID uuid;
        public final String homeName;

        public HomeEntry(UUID uuid, String homeName) {
            this.uuid = uuid;
            this.homeName = homeName;
        }
    }
}

