/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.mycommands.utils;

import fr.skynex.mycommands.MyCommands;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class AsyncOperations {
    private final MyCommands plugin;
    private final ExecutorService executor;
    private long asyncTasksCompleted = 0L;
    private long asyncTasksFailed = 0L;

    public AsyncOperations(MyCommands plugin) {
        this.plugin = plugin;
        int threadPoolSize = plugin.getConfig().getInt("async.thread-pool-size", 4);
        this.executor = Executors.newFixedThreadPool(threadPoolSize, r -> {
            Thread thread = new Thread(r, "MyCommands-Async");
            thread.setDaemon(true);
            return thread;
        });
    }

    public void safeTeleport(Player player, Location location, Runnable onSuccess, Consumer<String> onFailure) {
        this.runAsync(() -> {
            try {
                if (!this.isLocationSafe(location)) {
                    this.runSync(() -> {
                        if (onFailure != null) {
                            onFailure.accept("Location non s\u00e9curis\u00e9e");
                        }
                    });
                    return;
                }
                this.runSync(() -> {
                    try {
                        player.teleport(location);
                        if (onSuccess != null) {
                            onSuccess.run();
                        }
                        ++this.asyncTasksCompleted;
                    }
                    catch (Exception e) {
                        if (onFailure != null) {
                            onFailure.accept("Erreur de t\u00e9l\u00e9portation: " + e.getMessage());
                        }
                        ++this.asyncTasksFailed;
                    }
                });
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Erreur lors de la v\u00e9rification de location: " + e.getMessage());
                ++this.asyncTasksFailed;
            }
        });
    }

    private boolean isLocationSafe(Location location) {
        if (location == null || location.getWorld() == null) {
            return false;
        }
        if (location.getY() < 0.0 || location.getY() > 256.0) {
            return false;
        }
        Location below = location.clone().subtract(0.0, 1.0, 0.0);
        String blockType = below.getBlock().getType().name();
        return !blockType.contains("LAVA") && !blockType.contains("FIRE");
    }

    public <T> CompletableFuture<T> queryAsync(AsyncQuery<T> query) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                Object result = query.execute();
                ++this.asyncTasksCompleted;
                return result;
            }
            catch (Exception e) {
                ++this.asyncTasksFailed;
                this.plugin.getLogger().severe("Erreur lors de la requ\u00eate async: " + e.getMessage());
                throw new RuntimeException(e);
            }
        }, this.executor);
    }

    public void writeAsync(Runnable operation, Runnable onSuccess, Consumer<Exception> onFailure) {
        this.runAsync(() -> {
            block3: {
                try {
                    operation.run();
                    ++this.asyncTasksCompleted;
                    if (onSuccess != null) {
                        this.runSync(onSuccess);
                    }
                }
                catch (Exception e) {
                    ++this.asyncTasksFailed;
                    this.plugin.getLogger().severe("Erreur lors de l'\u00e9criture async: " + e.getMessage());
                    if (onFailure == null) break block3;
                    this.runSync(() -> onFailure.accept(e));
                }
            }
        });
    }

    public void runAsync(Runnable task) {
        this.executor.submit(() -> {
            block2: {
                try {
                    task.run();
                }
                catch (Exception e) {
                    this.plugin.getLogger().severe("Erreur dans une t\u00e2che async: " + e.getMessage());
                    if (!this.plugin.getConfig().getBoolean("debug.enabled", false)) break block2;
                    e.printStackTrace();
                }
            }
        });
    }

    public void runSync(Runnable task) {
        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, task);
    }

    public BukkitTask runSyncLater(Runnable task, long delayTicks) {
        return this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, task, delayTicks);
    }

    public BukkitTask runAsyncLater(Runnable task, long delayTicks) {
        return this.plugin.getServer().getScheduler().runTaskLaterAsynchronously((Plugin)this.plugin, task, delayTicks);
    }

    public BukkitTask runAsyncTimer(Runnable task, long delayTicks, long periodTicks) {
        return this.plugin.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, task, delayTicks, periodTicks);
    }

    public void bulkSave(Runnable[] operations, Runnable onComplete) {
        this.runAsync(() -> {
            int success = 0;
            int failed = 0;
            for (Runnable operation : operations) {
                try {
                    operation.run();
                    ++success;
                }
                catch (Exception e) {
                    ++failed;
                    this.plugin.getLogger().warning("Erreur dans bulk save: " + e.getMessage());
                }
            }
            int finalSuccess = success;
            int finalFailed = failed;
            if (this.plugin.getConfig().getBoolean("debug.enabled", false)) {
                this.plugin.getLogger().info(String.format("Bulk save termin\u00e9: %d succ\u00e8s, %d \u00e9checs", finalSuccess, finalFailed));
            }
            this.asyncTasksCompleted += (long)success;
            this.asyncTasksFailed += (long)failed;
            if (onComplete != null) {
                this.runSync(onComplete);
            }
        });
    }

    public void shutdown() {
        this.plugin.getLogger().info("Arr\u00eat des t\u00e2ches asynchrones...");
        this.executor.shutdown();
        try {
            if (!this.executor.awaitTermination(10L, TimeUnit.SECONDS)) {
                this.plugin.getLogger().warning("Certaines t\u00e2ches async n'ont pas pu se terminer \u00e0 temps");
                this.executor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.executor.shutdownNow();
        }
        this.plugin.getLogger().info(String.format("AsyncOperations arr\u00eat\u00e9 (Total: %d succ\u00e8s, %d \u00e9checs)", this.asyncTasksCompleted, this.asyncTasksFailed));
    }

    public Map<String, Long> getStats() {
        HashMap<String, Long> stats = new HashMap<String, Long>();
        stats.put("completed", this.asyncTasksCompleted);
        stats.put("failed", this.asyncTasksFailed);
        stats.put("total", this.asyncTasksCompleted + this.asyncTasksFailed);
        return stats;
    }

    public void resetStats() {
        this.asyncTasksCompleted = 0L;
        this.asyncTasksFailed = 0L;
    }

    @FunctionalInterface
    public static interface AsyncQuery<T> {
        public T execute() throws Exception;
    }
}

