/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.mycommands.utils;

import fr.skynex.mycommands.MyCommands;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.bukkit.plugin.Plugin;

public final class DiscordWebhook {
    private DiscordWebhook() {
    }

    public static void sendAsync(MyCommands plugin, String webhookUrl, String content) {
        if (webhookUrl == null || webhookUrl.isEmpty() || webhookUrl.contains("...")) {
            return;
        }
        plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
            try {
                DiscordWebhook.send(webhookUrl, content);
            }
            catch (Exception e) {
                plugin.getLogger().warning("Discord webhook error: " + e.getMessage());
            }
        });
    }

    private static void send(String webhookUrl, String content) throws Exception {
        String json = "{\"content\":\"" + DiscordWebhook.escapeJson(content) + "\"}";
        byte[] bytes = json.getBytes(StandardCharsets.UTF_8);
        URL url = URI.create(webhookUrl).toURL();
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/json");
        conn.setRequestProperty("Content-Length", String.valueOf(bytes.length));
        conn.setDoOutput(true);
        conn.setConnectTimeout(5000);
        conn.setReadTimeout(5000);
        try (OutputStream os = conn.getOutputStream();){
            os.write(bytes);
        }
        int code = conn.getResponseCode();
        if (code < 200 || code >= 300) {
            throw new RuntimeException("HTTP " + code);
        }
    }

    private static String escapeJson(String s) {
        if (s == null) {
            return "";
        }
        return s.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t");
    }
}

