/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.mycore;

import fr.skynex.mycore.api.MyCoreAPI;
import fr.skynex.mycore.commands.MyCoreCommand;
import fr.skynex.mycore.database.DatabaseManager;
import fr.skynex.mycore.registry.PluginRegistry;
import fr.skynex.mycore.utils.Logger;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.plugin.java.JavaPlugin;

public class MyCore
extends JavaPlugin {
    private static MyCore instance;
    private static MyCoreAPI api;
    private DatabaseManager databaseManager;
    private PluginRegistry pluginRegistry;
    private Logger logger;

    public void onEnable() {
        instance = this;
        this.logger = new Logger(this);
        this.logger.info("&b\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2557");
        this.logger.info("&b\u2551         &f&lMyCore &7v" + this.getDescription().getVersion() + "              &b\u2551");
        this.logger.info("&b\u2551    &7\u00c9cosyst\u00e8me MyPlugins activ\u00e9        &b\u2551");
        this.logger.info("&b\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d");
        this.saveDefaultConfig();
        this.initDatabase();
        this.pluginRegistry = new PluginRegistry(this);
        api = new MyCoreAPI();
        MyCoreCommand coreCommand = new MyCoreCommand(this);
        this.getCommand("mycore").setExecutor((CommandExecutor)coreCommand);
        this.getCommand("mycore").setTabCompleter((TabCompleter)coreCommand);
        this.logger.success("MyCore activ\u00e9 avec succ\u00e8s !");
    }

    public void onDisable() {
        if (this.databaseManager != null) {
            this.databaseManager.shutdown();
        }
        if (this.pluginRegistry != null) {
            this.pluginRegistry.unregisterAll();
        }
        this.logger.info("&cMyCore d\u00e9sactiv\u00e9.");
        instance = null;
    }

    private void initDatabase() {
        if (this.getConfig().getBoolean("database.enabled", true)) {
            try {
                this.databaseManager = new DatabaseManager(this);
                this.logger.success("Connexion \u00e0 la base de donn\u00e9es \u00e9tablie.");
            }
            catch (Exception e) {
                this.logger.error("Impossible de se connecter \u00e0 la base de donn\u00e9es: " + e.getMessage());
                this.logger.warning("Les plugins utiliseront le stockage local.");
            }
        } else {
            this.logger.info("Base de donn\u00e9es d\u00e9sactiv\u00e9e dans la config.");
        }
    }

    public static MyCore getInstance() {
        return instance;
    }

    public static MyCoreAPI getAPI() {
        return api;
    }

    public DatabaseManager getDatabaseManager() {
        return this.databaseManager;
    }

    public PluginRegistry getPluginRegistry() {
        return this.pluginRegistry;
    }

    public Logger getPluginLogger() {
        return this.logger;
    }

    public boolean isDatabaseEnabled() {
        return this.databaseManager != null && this.databaseManager.isConnected();
    }
}

