/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.mycore.api;

import fr.skynex.mycore.MyCore;
import fr.skynex.mycore.api.auction.AuctionProvider;
import fr.skynex.mycore.api.economy.EconomyProvider;
import fr.skynex.mycore.api.lands.LandProvider;
import fr.skynex.mycore.api.player.PlayerProvider;
import fr.skynex.mycore.api.provider.Provider;
import fr.skynex.mycore.database.DatabaseManager;
import fr.skynex.mycore.registry.PluginRegistry;
import java.util.Optional;
import org.bukkit.plugin.java.JavaPlugin;

public class MyCoreAPI {
    public static <T extends Provider> void register(Class<T> providerClass, T provider, JavaPlugin plugin) {
        MyCore.getInstance().getPluginRegistry().register(providerClass, provider, plugin);
    }

    public static <T extends Provider> void unregister(Class<T> providerClass) {
        MyCore.getInstance().getPluginRegistry().unregister(providerClass);
    }

    public static void unregisterAll(JavaPlugin plugin) {
        MyCore.getInstance().getPluginRegistry().unregisterAll(plugin);
    }

    public static <T extends Provider> Optional<T> get(Class<T> providerClass) {
        return MyCore.getInstance().getPluginRegistry().get(providerClass);
    }

    public static <T extends Provider> boolean isAvailable(Class<T> providerClass) {
        return MyCore.getInstance().getPluginRegistry().isAvailable(providerClass);
    }

    public static Optional<EconomyProvider> getEconomy() {
        return MyCoreAPI.get(EconomyProvider.class);
    }

    public static boolean hasEconomy() {
        return MyCoreAPI.isAvailable(EconomyProvider.class);
    }

    public static Optional<LandProvider> getLands() {
        return MyCoreAPI.get(LandProvider.class);
    }

    public static boolean hasLands() {
        return MyCoreAPI.isAvailable(LandProvider.class);
    }

    public static Optional<AuctionProvider> getAuction() {
        return MyCoreAPI.get(AuctionProvider.class);
    }

    public static boolean hasAuction() {
        return MyCoreAPI.isAvailable(AuctionProvider.class);
    }

    public static Optional<PlayerProvider> getPlayer() {
        return MyCoreAPI.get(PlayerProvider.class);
    }

    public static boolean hasPlayer() {
        return MyCoreAPI.isAvailable(PlayerProvider.class);
    }

    public static DatabaseManager getDatabase() {
        return MyCore.getInstance().getDatabaseManager();
    }

    public static boolean isDatabaseAvailable() {
        return MyCore.getInstance().isDatabaseEnabled();
    }

    public static PluginRegistry getRegistry() {
        return MyCore.getInstance().getPluginRegistry();
    }

    public static boolean isPluginLoaded(String pluginName) {
        return MyCore.getInstance().getPluginRegistry().isPluginRegistered(pluginName);
    }

    public static void logTransaction(String type, String sourcePlugin, String playerUuid, String targetUuid, double amount, String description) {
        if (MyCoreAPI.isDatabaseAvailable()) {
            MyCoreAPI.getDatabase().logTransaction(type, sourcePlugin, playerUuid, targetUuid, amount, description);
        }
    }

    public static String getVersion() {
        return MyCore.getInstance().getDescription().getVersion();
    }
}

