/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.mycore.commands;

import fr.skynex.mycore.MyCore;
import fr.skynex.mycore.api.auction.AuctionProvider;
import fr.skynex.mycore.api.economy.EconomyProvider;
import fr.skynex.mycore.api.lands.LandProvider;
import fr.skynex.mycore.api.player.PlayerProvider;
import fr.skynex.mycore.registry.PluginRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.plugin.java.JavaPlugin;

public class MyCoreCommand
implements CommandExecutor,
TabCompleter {
    private final MyCore plugin;

    public MyCoreCommand(MyCore plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("mycore.admin")) {
            sender.sendMessage(this.colorize("&cVous n'avez pas la permission."));
            return true;
        }
        if (args.length == 0) {
            this.sendHelp(sender);
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "reload": {
                this.handleReload(sender);
                break;
            }
            case "status": {
                this.handleStatus(sender);
                break;
            }
            case "providers": {
                this.handleProviders(sender);
                break;
            }
            case "database": 
            case "db": {
                this.handleDatabase(sender);
                break;
            }
            default: {
                this.sendHelp(sender);
            }
        }
        return true;
    }

    private void handleReload(CommandSender sender) {
        this.plugin.reloadConfig();
        sender.sendMessage(this.colorize("&a\u2713 Configuration recharg\u00e9e !"));
    }

    private void handleStatus(CommandSender sender) {
        sender.sendMessage(this.colorize("&b&l\u2550\u2550\u2550\u2550\u2550\u2550\u2550 MyCore Status \u2550\u2550\u2550\u2550\u2550\u2550\u2550"));
        sender.sendMessage(this.colorize("&7Version: &f" + this.plugin.getDescription().getVersion()));
        sender.sendMessage(this.colorize("&7Database: " + (this.plugin.isDatabaseEnabled() ? "&aConnect\u00e9" : "&cD\u00e9connect\u00e9")));
        sender.sendMessage(this.colorize("&7Providers: &f" + this.plugin.getPluginRegistry().getProviderCount()));
        Map<String, JavaPlugin> plugins = this.plugin.getPluginRegistry().getRegisteredPlugins();
        sender.sendMessage(this.colorize("&7Plugins enregistr\u00e9s: &f" + plugins.size()));
        for (String pluginName : plugins.keySet()) {
            sender.sendMessage(this.colorize("  &8\u2192 &a" + pluginName));
        }
    }

    private void handleProviders(CommandSender sender) {
        PluginRegistry registry = this.plugin.getPluginRegistry();
        sender.sendMessage(this.colorize("&b&l\u2550\u2550\u2550\u2550\u2550\u2550\u2550 Providers \u2550\u2550\u2550\u2550\u2550\u2550\u2550"));
        this.checkProvider(sender, "EconomyProvider", registry.isAvailable(EconomyProvider.class));
        this.checkProvider(sender, "LandProvider", registry.isAvailable(LandProvider.class));
        this.checkProvider(sender, "AuctionProvider", registry.isAvailable(AuctionProvider.class));
        this.checkProvider(sender, "PlayerProvider", registry.isAvailable(PlayerProvider.class));
    }

    private void checkProvider(CommandSender sender, String name, boolean available) {
        String status = available ? "&a\u2713 Disponible" : "&c\u2717 Non disponible";
        sender.sendMessage(this.colorize("&7" + name + ": " + status));
    }

    private void handleDatabase(CommandSender sender) {
        sender.sendMessage(this.colorize("&b&l\u2550\u2550\u2550\u2550\u2550\u2550\u2550 Database \u2550\u2550\u2550\u2550\u2550\u2550\u2550"));
        if (!this.plugin.isDatabaseEnabled()) {
            sender.sendMessage(this.colorize("&cBase de donn\u00e9es non connect\u00e9e."));
            return;
        }
        sender.sendMessage(this.colorize("&7Status: &aConnect\u00e9"));
        sender.sendMessage(this.colorize("&7Host: &f" + this.plugin.getConfig().getString("database.host")));
        sender.sendMessage(this.colorize("&7Database: &f" + this.plugin.getConfig().getString("database.database")));
        sender.sendMessage(this.colorize("&7Pool size: &f" + this.plugin.getConfig().getInt("database.pool.max-size")));
    }

    private void sendHelp(CommandSender sender) {
        sender.sendMessage(this.colorize("&b&l\u2550\u2550\u2550\u2550\u2550\u2550\u2550 MyCore Help \u2550\u2550\u2550\u2550\u2550\u2550\u2550"));
        sender.sendMessage(this.colorize("&b/mycore reload &8- &7Recharger la config"));
        sender.sendMessage(this.colorize("&b/mycore status &8- &7Voir le statut"));
        sender.sendMessage(this.colorize("&b/mycore providers &8- &7Lister les providers"));
        sender.sendMessage(this.colorize("&b/mycore database &8- &7Info base de donn\u00e9es"));
    }

    private String colorize(String message) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            ArrayList<String> completions = new ArrayList<String>();
            String input = args[0].toLowerCase();
            for (String sub : Arrays.asList("reload", "status", "providers", "database")) {
                if (!sub.startsWith(input)) continue;
                completions.add(sub);
            }
            return completions;
        }
        return new ArrayList<String>();
    }
}

