/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.mycore.database;

import fr.skynex.mycore.MyCore;
import fr.skynex.mycore.libs.hikari.HikariConfig;
import fr.skynex.mycore.libs.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.bukkit.configuration.file.FileConfiguration;

public class DatabaseManager {
    private final MyCore plugin;
    private HikariDataSource dataSource;
    private boolean connected = false;

    public DatabaseManager(MyCore plugin) {
        this.plugin = plugin;
        this.initConnection();
    }

    private void initConnection() {
        FileConfiguration config = this.plugin.getConfig();
        String host = config.getString("database.host", "localhost");
        int port = config.getInt("database.port", 3306);
        String database = config.getString("database.database", "mycore");
        String username = config.getString("database.username", "root");
        String password = config.getString("database.password", "");
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setJdbcUrl("jdbc:mysql://" + host + ":" + port + "/" + database + "?useSSL=false&autoReconnect=true&useUnicode=true&characterEncoding=UTF-8");
        hikariConfig.setUsername(username);
        hikariConfig.setPassword(password);
        hikariConfig.setPoolName("MyCore-Pool");
        hikariConfig.setMaximumPoolSize(config.getInt("database.pool.max-size", 10));
        hikariConfig.setMinimumIdle(config.getInt("database.pool.min-idle", 2));
        hikariConfig.setIdleTimeout(config.getLong("database.pool.idle-timeout", 300000L));
        hikariConfig.setConnectionTimeout(config.getLong("database.pool.connection-timeout", 10000L));
        hikariConfig.setMaxLifetime(config.getLong("database.pool.max-lifetime", 1800000L));
        hikariConfig.addDataSourceProperty("cachePrepStmts", "true");
        hikariConfig.addDataSourceProperty("prepStmtCacheSize", "250");
        hikariConfig.addDataSourceProperty("prepStmtCacheSqlLimit", "2048");
        hikariConfig.addDataSourceProperty("useServerPrepStmts", "true");
        hikariConfig.addDataSourceProperty("useLocalSessionState", "true");
        hikariConfig.addDataSourceProperty("rewriteBatchedStatements", "true");
        hikariConfig.addDataSourceProperty("cacheResultSetMetadata", "true");
        hikariConfig.addDataSourceProperty("cacheServerConfiguration", "true");
        hikariConfig.addDataSourceProperty("elideSetAutoCommits", "true");
        hikariConfig.addDataSourceProperty("maintainTimeStats", "false");
        try {
            this.dataSource = new HikariDataSource(hikariConfig);
            this.connected = true;
            this.createCoreTables();
        }
        catch (Exception e) {
            this.plugin.getPluginLogger().error("Erreur de connexion MySQL: " + e.getMessage());
            this.connected = false;
            throw e;
        }
    }

    private void createCoreTables() {
        String createPlayersTable = "CREATE TABLE IF NOT EXISTS mycore_players (\n    uuid VARCHAR(36) PRIMARY KEY,\n    username VARCHAR(16) NOT NULL,\n    first_join TIMESTAMP DEFAULT CURRENT_TIMESTAMP,\n    last_seen TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,\n    playtime BIGINT DEFAULT 0,\n    INDEX idx_username (username)\n) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci\n";
        String createPluginDataTable = "CREATE TABLE IF NOT EXISTS mycore_plugin_data (\n    id INT AUTO_INCREMENT PRIMARY KEY,\n    plugin_name VARCHAR(64) NOT NULL,\n    data_key VARCHAR(128) NOT NULL,\n    data_value TEXT,\n    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,\n    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,\n    UNIQUE KEY unique_plugin_key (plugin_name, data_key),\n    INDEX idx_plugin (plugin_name)\n) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci\n";
        String createTransactionLogTable = "CREATE TABLE IF NOT EXISTS mycore_transaction_log (\n    id BIGINT AUTO_INCREMENT PRIMARY KEY,\n    transaction_type VARCHAR(32) NOT NULL,\n    source_plugin VARCHAR(64) NOT NULL,\n    player_uuid VARCHAR(36),\n    target_uuid VARCHAR(36),\n    amount DECIMAL(20, 2),\n    description TEXT,\n    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,\n    INDEX idx_player (player_uuid),\n    INDEX idx_type (transaction_type),\n    INDEX idx_date (created_at)\n) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci\n";
        try (Connection conn = this.getConnection();){
            conn.createStatement().execute(createPlayersTable);
            conn.createStatement().execute(createPluginDataTable);
            conn.createStatement().execute(createTransactionLogTable);
        }
        catch (SQLException e) {
            this.plugin.getPluginLogger().error("Erreur cr\u00e9ation tables: " + e.getMessage());
        }
    }

    public Connection getConnection() throws SQLException {
        if (this.dataSource == null || this.dataSource.isClosed()) {
            throw new SQLException("La source de donn\u00e9es n'est pas disponible");
        }
        return this.dataSource.getConnection();
    }

    public boolean isConnected() {
        return this.connected && this.dataSource != null && !this.dataSource.isClosed();
    }

    public void shutdown() {
        if (this.dataSource != null && !this.dataSource.isClosed()) {
            this.dataSource.close();
            this.plugin.getPluginLogger().info("Pool de connexions ferm\u00e9.");
        }
        this.connected = false;
    }

    public HikariDataSource getDataSource() {
        return this.dataSource;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public int executeUpdate(String sql, Object ... params) {
        try (Connection conn = this.getConnection();){
            int n;
            block15: {
                PreparedStatement stmt = conn.prepareStatement(sql);
                try {
                    for (int i = 0; i < params.length; ++i) {
                        stmt.setObject(i + 1, params[i]);
                    }
                    n = stmt.executeUpdate();
                    if (stmt == null) break block15;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return n;
        }
        catch (SQLException e) {
            this.plugin.getPluginLogger().error("Erreur SQL: " + e.getMessage());
            return -1;
        }
    }

    public ResultSet executeQuery(String sql, Object ... params) throws SQLException {
        Connection conn = this.getConnection();
        PreparedStatement stmt = conn.prepareStatement(sql);
        for (int i = 0; i < params.length; ++i) {
            stmt.setObject(i + 1, params[i]);
        }
        return stmt.executeQuery();
    }

    public void logTransaction(String type, String sourcePlugin, String playerUuid, String targetUuid, double amount, String description) {
        String sql = "INSERT INTO mycore_transaction_log\n(transaction_type, source_plugin, player_uuid, target_uuid, amount, description)\nVALUES (?, ?, ?, ?, ?, ?)\n";
        this.executeUpdate(sql, type, sourcePlugin, playerUuid, targetUuid, amount, description);
    }

    public void savePlayer(String uuid, String username) {
        String sql = "INSERT INTO mycore_players (uuid, username)\nVALUES (?, ?)\nON DUPLICATE KEY UPDATE username = ?, last_seen = CURRENT_TIMESTAMP\n";
        this.executeUpdate(sql, uuid, username, username);
    }

    public void setPluginData(String pluginName, String key, String value) {
        String sql = "INSERT INTO mycore_plugin_data (plugin_name, data_key, data_value)\nVALUES (?, ?, ?)\nON DUPLICATE KEY UPDATE data_value = ?, updated_at = CURRENT_TIMESTAMP\n";
        this.executeUpdate(sql, pluginName, key, value, value);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getPluginData(String pluginName, String key) {
        String sql = "SELECT data_value FROM mycore_plugin_data WHERE plugin_name = ? AND data_key = ?";
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setString(1, pluginName);
            stmt.setString(2, key);
            ResultSet rs = stmt.executeQuery();
            if (!rs.next()) return null;
            String string = rs.getString("data_value");
            return string;
        }
        catch (SQLException e) {
            this.plugin.getPluginLogger().error("Erreur lecture data: " + e.getMessage());
        }
        return null;
    }
}

