/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.mycore.events.economy;

import fr.skynex.mycore.events.MyCoreEvent;
import java.util.UUID;
import org.bukkit.event.HandlerList;

public class BalanceChangeEvent
extends MyCoreEvent {
    private static final HandlerList HANDLERS = new HandlerList();
    private final UUID playerUUID;
    private final double oldBalance;
    private final double newBalance;
    private final String reason;

    public BalanceChangeEvent(String sourcePlugin, UUID playerUUID, double oldBalance, double newBalance, String reason) {
        super(sourcePlugin, true);
        this.playerUUID = playerUUID;
        this.oldBalance = oldBalance;
        this.newBalance = newBalance;
        this.reason = reason;
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public double getOldBalance() {
        return this.oldBalance;
    }

    public double getNewBalance() {
        return this.newBalance;
    }

    public double getDifference() {
        return this.newBalance - this.oldBalance;
    }

    public boolean isIncrease() {
        return this.newBalance > this.oldBalance;
    }

    public boolean isDecrease() {
        return this.newBalance < this.oldBalance;
    }

    public String getReason() {
        return this.reason;
    }

    public HandlerList getHandlers() {
        return HANDLERS;
    }

    public static HandlerList getHandlerList() {
        return HANDLERS;
    }
}

