/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.mycore.registry;

import fr.skynex.mycore.MyCore;
import fr.skynex.mycore.api.provider.Provider;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.plugin.java.JavaPlugin;

public class PluginRegistry {
    private final MyCore core;
    private final Map<Class<? extends Provider>, ProviderEntry<?>> providers = new ConcurrentHashMap();
    private final Map<String, JavaPlugin> registeredPlugins = new ConcurrentHashMap<String, JavaPlugin>();

    public PluginRegistry(MyCore core) {
        this.core = core;
    }

    public <T extends Provider> void register(Class<T> providerClass, T provider, JavaPlugin plugin) {
        if (this.providers.containsKey(providerClass)) {
            this.core.getPluginLogger().warning("Provider " + providerClass.getSimpleName() + " d\u00e9j\u00e0 enregistr\u00e9, remplacement par " + plugin.getName());
        }
        this.providers.put(providerClass, new ProviderEntry<T>(provider, plugin));
        this.registeredPlugins.put(plugin.getName(), plugin);
        this.core.getPluginLogger().pluginRegistered(plugin.getName(), providerClass.getSimpleName());
    }

    public <T extends Provider> void unregister(Class<T> providerClass) {
        ProviderEntry<?> entry = this.providers.remove(providerClass);
        if (entry != null) {
            this.core.getPluginLogger().info("Provider " + providerClass.getSimpleName() + " d\u00e9senregistr\u00e9.");
        }
    }

    public void unregisterAll(JavaPlugin plugin) {
        this.providers.entrySet().removeIf(entry -> {
            if (((ProviderEntry)entry.getValue()).plugin().equals((Object)plugin)) {
                this.core.getPluginLogger().info("Provider " + ((Class)entry.getKey()).getSimpleName() + " d\u00e9senregistr\u00e9 (" + plugin.getName() + ")");
                return true;
            }
            return false;
        });
        this.registeredPlugins.remove(plugin.getName());
    }

    public void unregisterAll() {
        this.providers.clear();
        this.registeredPlugins.clear();
        this.core.getPluginLogger().info("Tous les providers d\u00e9senregistr\u00e9s.");
    }

    public <T extends Provider> Optional<T> get(Class<T> providerClass) {
        ProviderEntry<?> entry = this.providers.get(providerClass);
        if (entry != null) {
            return Optional.of(entry.provider());
        }
        return Optional.empty();
    }

    public <T extends Provider> boolean isAvailable(Class<T> providerClass) {
        return this.providers.containsKey(providerClass);
    }

    public <T extends Provider> Optional<JavaPlugin> getProviderPlugin(Class<T> providerClass) {
        ProviderEntry<?> entry = this.providers.get(providerClass);
        if (entry != null) {
            return Optional.of(entry.plugin());
        }
        return Optional.empty();
    }

    public boolean isPluginRegistered(String pluginName) {
        return this.registeredPlugins.containsKey(pluginName);
    }

    public Optional<JavaPlugin> getPlugin(String pluginName) {
        return Optional.ofNullable(this.registeredPlugins.get(pluginName));
    }

    public Map<String, JavaPlugin> getRegisteredPlugins() {
        return Map.copyOf(this.registeredPlugins);
    }

    public int getProviderCount() {
        return this.providers.size();
    }

    private record ProviderEntry<T extends Provider>(T provider, JavaPlugin plugin) {
    }
}

