/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.mycore.utils;

import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.plugin.java.JavaPlugin;

public class Logger {
    private final JavaPlugin plugin;
    private final String prefix;

    public Logger(JavaPlugin plugin) {
        this.plugin = plugin;
        this.prefix = "&8[&b" + plugin.getName() + "&8] ";
    }

    public Logger(JavaPlugin plugin, String customPrefix) {
        this.plugin = plugin;
        this.prefix = customPrefix;
    }

    public String colorize(String message) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    public void info(String message) {
        Bukkit.getConsoleSender().sendMessage(this.colorize(this.prefix + "&7" + message));
    }

    public void success(String message) {
        Bukkit.getConsoleSender().sendMessage(this.colorize(this.prefix + "&a\u2713 " + message));
    }

    public void warning(String message) {
        Bukkit.getConsoleSender().sendMessage(this.colorize(this.prefix + "&e\u26a0 " + message));
    }

    public void error(String message) {
        Bukkit.getConsoleSender().sendMessage(this.colorize(this.prefix + "&c\u2717 " + message));
    }

    public void debug(String message) {
        if (this.plugin.getConfig().getBoolean("debug", false)) {
            Bukkit.getConsoleSender().sendMessage(this.colorize(this.prefix + "&d[DEBUG] " + message));
        }
    }

    public void pluginRegistered(String pluginName, String providerType) {
        Bukkit.getConsoleSender().sendMessage(this.colorize(this.prefix + "&a\u2192 &f" + pluginName + " &7enregistr\u00e9 comme &b" + providerType));
    }

    public void exception(String message, Exception e) {
        this.error(message);
        if (this.plugin.getConfig().getBoolean("debug", false)) {
            e.printStackTrace();
        }
    }
}

