/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.myEconomy;

import fr.skynex.myEconomy.MyEconomy;
import fr.skynex.myEconomy.cache.BalanceCache;
import fr.skynex.myEconomy.database.DatabaseManager;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class EconomyManager {
    private final MyEconomy plugin;
    private final BalanceCache balanceCache;
    private File dataFile;
    private FileConfiguration dataConfig;
    private boolean useMySQL;
    private boolean useSQLite;

    public EconomyManager(MyEconomy plugin) {
        this.plugin = plugin;
        this.balanceCache = new BalanceCache(plugin);
        String dbType = plugin.getConfigManager().getDatabaseType().toLowerCase();
        boolean mysqlConfigured = dbType.equals("mysql");
        boolean sqliteConfigured = dbType.equals("sqlite");
        boolean mysqlAvailable = plugin.getDatabaseManager().isMySQLAvailable();
        boolean sqliteAvailable = plugin.getDatabaseManager().isSQLiteAvailable();
        this.useMySQL = mysqlConfigured && mysqlAvailable;
        boolean bl = this.useSQLite = sqliteConfigured && sqliteAvailable;
        if (mysqlConfigured && !mysqlAvailable) {
            plugin.getLogger().warning("MySQL configured but driver not available. Fallback to YAML.");
            this.setupDataFile();
        } else if (sqliteConfigured && !sqliteAvailable) {
            plugin.getLogger().warning("SQLite configured but driver not available. Fallback to YAML.");
            this.setupDataFile();
        } else if (this.useMySQL || this.useSQLite) {
            plugin.getDatabaseManager().connect();
        } else {
            this.setupDataFile();
        }
        plugin.getServer().getScheduler().runTaskTimer((Plugin)plugin, () -> {
            for (Player player : plugin.getServer().getOnlinePlayers()) {
                if (this.getBalance(player) != 0.0 || this.hasPlayedBefore(player)) continue;
                this.setBalance(player, plugin.getConfigManager().getStartingBalance());
            }
        }, 0L, 1200L);
    }

    private boolean hasPlayedBefore(Player player) {
        return this.getBalance(player) > 0.0 || this.plugin.getStatsManager().getStats(player.getUniqueId()).getTransactionsCount() > 0;
    }

    private void setupDataFile() {
        this.dataFile = new File(this.plugin.getDataFolder(), "balances.yml");
        if (!this.dataFile.exists()) {
            this.plugin.getDataFolder().mkdirs();
            try {
                this.dataFile.createNewFile();
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Unable to create balances.yml file");
                e.printStackTrace();
            }
        }
        this.dataConfig = YamlConfiguration.loadConfiguration((File)this.dataFile);
    }

    public double getBalance(UUID uuid) {
        Double cached = this.balanceCache.get(uuid);
        if (cached != null) {
            return cached;
        }
        double balance = this.useMySQL || this.useSQLite ? this.getBalanceSQL(uuid) : this.dataConfig.getDouble("balances." + uuid.toString(), 0.0);
        this.balanceCache.put(uuid, balance);
        return balance;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private double getBalanceSQL(UUID uuid) {
        ResultSet rs;
        block20: {
            DatabaseManager db = this.plugin.getDatabaseManager();
            if (!db.isConnected()) {
                return 0.0;
            }
            try {
                double d;
                Connection conn;
                block22: {
                    PreparedStatement stmt;
                    block21: {
                        conn = db.getConnection();
                        String sql = "SELECT balance FROM balances WHERE uuid = ?";
                        stmt = conn.prepareStatement(sql);
                        stmt.setString(1, uuid.toString());
                        rs = stmt.executeQuery();
                        try {
                            if (!rs.next()) break block20;
                            d = rs.getDouble("balance");
                            if (rs == null) break block21;
                        }
                        catch (Throwable throwable) {
                            if (rs == null) throw throwable;
                            try {
                                rs.close();
                                throw throwable;
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        rs.close();
                    }
                    if (stmt == null) break block22;
                    stmt.close();
                }
                if (conn == null) return d;
                conn.close();
                return d;
            }
            catch (SQLException e) {
                this.plugin.getLogger().severe("Error retrieving MySQL balance: " + e.getMessage());
                return 0.0;
            }
        }
        if (rs == null) return 0.0;
        rs.close();
        return 0.0;
    }

    public double getBalance(Player player) {
        return this.getBalance(player.getUniqueId());
    }

    public synchronized void setBalance(UUID uuid, double amount) {
        if (amount < 0.0) {
            amount = 0.0;
        }
        this.balanceCache.invalidate(uuid);
        if (this.useMySQL || this.useSQLite) {
            this.setBalanceSQL(uuid, amount);
        } else {
            this.dataConfig.set("balances." + uuid.toString(), (Object)amount);
            this.saveData();
        }
        this.balanceCache.put(uuid, amount);
    }

    private void setBalanceSQL(UUID uuid, double amount) {
        DatabaseManager db = this.plugin.getDatabaseManager();
        if (!db.isConnected()) {
            return;
        }
        try (Connection conn = db.getConnection();){
            String sql = this.useSQLite ? "INSERT OR REPLACE INTO balances (uuid, balance) VALUES (?, ?)" : "INSERT INTO balances (uuid, balance) VALUES (?, ?) ON DUPLICATE KEY UPDATE balance = ?";
            try (PreparedStatement stmt = conn.prepareStatement(sql);){
                stmt.setString(1, uuid.toString());
                stmt.setDouble(2, amount);
                if (!this.useSQLite) {
                    stmt.setDouble(3, amount);
                }
                stmt.executeUpdate();
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Error updating balance: " + e.getMessage());
        }
    }

    public void setBalance(Player player, double amount) {
        this.setBalance(player.getUniqueId(), amount);
    }

    public synchronized void addBalance(UUID uuid, double amount) {
        if (amount <= 0.0) {
            return;
        }
        double current = this.getBalance(uuid);
        this.setBalance(uuid, current + amount);
    }

    public void addBalance(Player player, double amount) {
        this.addBalance(player.getUniqueId(), amount);
    }

    public synchronized boolean removeBalance(UUID uuid, double amount) {
        if (amount <= 0.0) {
            return false;
        }
        double current = this.getBalance(uuid);
        if (current >= amount) {
            this.setBalance(uuid, current - amount);
            return true;
        }
        return false;
    }

    public boolean removeBalance(Player player, double amount) {
        return this.removeBalance(player.getUniqueId(), amount);
    }

    public boolean hasBalance(UUID uuid, double amount) {
        return this.getBalance(uuid) >= amount;
    }

    public boolean hasBalance(Player player, double amount) {
        return this.hasBalance(player.getUniqueId(), amount);
    }

    public boolean transfer(UUID from, UUID to, double amount) {
        return this.transfer(from, to, amount, 0.0);
    }

    public synchronized boolean transfer(UUID from, UUID to, double amount, double tax) {
        if (amount <= 0.0 || tax < 0.0) {
            return false;
        }
        if (from.equals(to)) {
            return false;
        }
        double totalAmount = amount + tax;
        double fromBalance = this.getBalance(from);
        if (fromBalance >= totalAmount) {
            this.setBalance(from, fromBalance - totalAmount);
            double toBalance = this.getBalance(to);
            this.setBalance(to, toBalance + amount);
            return true;
        }
        return false;
    }

    public boolean transfer(Player from, Player to, double amount) {
        return this.transfer(from.getUniqueId(), to.getUniqueId(), amount);
    }

    public boolean transfer(Player from, Player to, double amount, double tax) {
        return this.transfer(from.getUniqueId(), to.getUniqueId(), amount, tax);
    }

    public Map<UUID, Double> getTopBalances(int limit) {
        return this.getTopBalances(limit, null);
    }

    public Map<UUID, Double> getTopBalances(int limit, String period) {
        if ((this.useMySQL || this.useSQLite) && period != null) {
            return this.getTopBalancesSQL(limit, period);
        }
        if (this.useMySQL || this.useSQLite) {
            return this.getTopBalancesSQL(limit);
        }
        return this.getTopBalancesYAML(limit);
    }

    private Map<UUID, Double> getTopBalancesYAML(int limit) {
        HashMap<UUID, Double> balances = new HashMap<UUID, Double>();
        if (this.dataConfig.getConfigurationSection("balances") != null) {
            for (String key : this.dataConfig.getConfigurationSection("balances").getKeys(false)) {
                try {
                    UUID uuid = UUID.fromString(key);
                    double balance = this.dataConfig.getDouble("balances." + key, 0.0);
                    balances.put(uuid, balance);
                }
                catch (IllegalArgumentException e) {
                    this.plugin.getLogger().warning("Invalid UUID in balances.yml: " + key);
                }
            }
        }
        return balances.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).limit(limit).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
    }

    private Map<UUID, Double> getTopBalancesSQL(int limit) {
        return this.getTopBalancesSQL(limit, null);
    }

    private Map<UUID, Double> getTopBalancesSQL(int limit, String period) {
        LinkedHashMap<UUID, Double> balances = new LinkedHashMap<UUID, Double>();
        DatabaseManager db = this.plugin.getDatabaseManager();
        if (!db.isConnected()) {
            return balances;
        }
        try (Connection conn = db.getConnection();){
            Object sql;
            if (period != null && (period.equals("weekly") || period.equals("monthly"))) {
                String tableName = period + "_rankings";
                sql = "SELECT uuid, balance FROM " + tableName + " ORDER BY balance DESC LIMIT ?";
            } else {
                sql = "SELECT uuid, balance FROM balances ORDER BY balance DESC LIMIT ?";
            }
            try (PreparedStatement stmt = conn.prepareStatement((String)sql);){
                stmt.setInt(1, limit);
                try (ResultSet rs = stmt.executeQuery();){
                    while (rs.next()) {
                        try {
                            UUID uuid = UUID.fromString(rs.getString("uuid"));
                            double balance = rs.getDouble("balance");
                            balances.put(uuid, balance);
                        }
                        catch (IllegalArgumentException e) {
                            this.plugin.getLogger().warning("Invalid UUID in database: " + rs.getString("uuid"));
                        }
                    }
                }
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Error retrieving MySQL ranking: " + e.getMessage());
        }
        return balances;
    }

    private void saveData() {
        if (this.useMySQL || this.useSQLite) {
            return;
        }
        try {
            this.dataConfig.save(this.dataFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Unable to save balances.yml");
            e.printStackTrace();
        }
    }

    public void reload() {
        if (!this.useMySQL && !this.useSQLite) {
            this.dataConfig = YamlConfiguration.loadConfiguration((File)this.dataFile);
        }
    }

    public void invalidateCache() {
        this.balanceCache.invalidateAll();
    }

    public int clearAllBalances() {
        List<UUID> uuids = this.getAllPlayerUUIDs();
        for (UUID uuid : uuids) {
            this.setBalance(uuid, 0.0);
        }
        return uuids.size();
    }

    public int multiplyAllBalances(double factor) {
        List<UUID> uuids = this.getAllPlayerUUIDs();
        for (UUID uuid : uuids) {
            double current = this.getBalance(uuid);
            if (!(current > 0.0)) continue;
            this.setBalance(uuid, current * factor);
        }
        return uuids.size();
    }

    public List<UUID> getAllPlayerUUIDs() {
        if (this.useMySQL || this.useSQLite) {
            return this.getAllPlayerUUIDsSQL();
        }
        return this.getAllPlayerUUIDsYAML();
    }

    private List<UUID> getAllPlayerUUIDsYAML() {
        ArrayList<UUID> result = new ArrayList<UUID>();
        if (this.dataConfig.getConfigurationSection("balances") != null) {
            for (String key : this.dataConfig.getConfigurationSection("balances").getKeys(false)) {
                try {
                    result.add(UUID.fromString(key));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        return result;
    }

    private List<UUID> getAllPlayerUUIDsSQL() {
        ArrayList<UUID> result = new ArrayList<UUID>();
        DatabaseManager db = this.plugin.getDatabaseManager();
        if (!db.isConnected()) {
            return result;
        }
        try (Connection conn = db.getConnection();){
            String sql = "SELECT uuid FROM balances";
            try (PreparedStatement stmt = conn.prepareStatement(sql);
                 ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    try {
                        result.add(UUID.fromString(rs.getString("uuid")));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Error getting all UUIDs: " + e.getMessage());
        }
        return result;
    }

    public void shutdown() {
        if (this.balanceCache != null) {
            this.balanceCache.shutdown();
        }
    }
}

