/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.myEconomy.commands;

import fr.skynex.myEconomy.EconomyManager;
import fr.skynex.myEconomy.MyEconomy;
import fr.skynex.myEconomy.hologram.HologramManager;
import fr.skynex.myEconomy.migration.MigrationManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class EcoCommand
implements CommandExecutor,
TabCompleter {
    private final EconomyManager economyManager;
    private final MyEconomy plugin;

    public EcoCommand(EconomyManager economyManager) {
        this.economyManager = economyManager;
        this.plugin = MyEconomy.getInstance();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("myeconomy.admin")) {
            sender.sendMessage(this.plugin.getLanguageManager().getMessage("error-no-permission"));
            return true;
        }
        if (args.length < 1) {
            sender.sendMessage(this.plugin.getLanguageManager().getMessage("eco-usage"));
            return true;
        }
        String action = args[0].toLowerCase();
        if (action.equals("hologram")) {
            return this.handleHologramCommand(sender, args);
        }
        if (action.equals("reload")) {
            return this.handleReloadCommand(sender);
        }
        if (action.equals("clear") || action.equals("empty")) {
            return this.handleClearCommand(sender);
        }
        if (action.equals("multiply")) {
            return this.handleMultiplyCommand(sender, args);
        }
        if (action.equals("payall")) {
            return this.handlePayallCommand(sender, args);
        }
        if (action.equals("migrate")) {
            return this.handleMigrateCommand(sender, args);
        }
        if (args.length < 2) {
            sender.sendMessage(this.plugin.getLanguageManager().getMessage("eco-usage"));
            return true;
        }
        String playerName = args[1];
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)playerName);
        if (target == null || !target.hasPlayedBefore() && !target.isOnline()) {
            HashMap<String, String> errorPlaceholders = new HashMap<String, String>();
            errorPlaceholders.put("player", playerName);
            sender.sendMessage(this.plugin.getLanguageManager().getMessage("error-player-not-found", errorPlaceholders));
            return true;
        }
        UUID uuid = target.getUniqueId();
        String currency = this.plugin.getConfigManager().getCurrencyPlural();
        switch (action) {
            case "give": {
                if (args.length < 3) {
                    sender.sendMessage(this.plugin.getLanguageManager().getMessage("eco-give-usage"));
                    return true;
                }
                try {
                    UUID adminId;
                    double amount = Double.parseDouble(args[2]);
                    if (amount <= 0.0) {
                        sender.sendMessage(this.plugin.getLanguageManager().getMessage("error-amount-negative"));
                        return true;
                    }
                    this.economyManager.addBalance(uuid, amount);
                    this.plugin.getStatsManager().recordTransaction(uuid, amount, "earned");
                    UUID uUID = adminId = sender instanceof Player ? ((Player)sender).getUniqueId() : null;
                    if (adminId != null) {
                        this.plugin.getAuditLogger().logAdminAction("GIVE", adminId, uuid, amount, "Money given to " + target.getName());
                    }
                    HashMap<String, String> givePlaceholders = new HashMap<String, String>();
                    givePlaceholders.put("amount", String.format("%.2f", amount));
                    givePlaceholders.put("coins", currency);
                    givePlaceholders.put("player", target.getName());
                    sender.sendMessage(this.plugin.getLanguageManager().getMessage("eco-give-success", givePlaceholders));
                    if (!target.isOnline()) break;
                    HashMap<String, String> receivedPlaceholders = new HashMap<String, String>();
                    receivedPlaceholders.put("amount", String.format("%.2f", amount));
                    receivedPlaceholders.put("coins", currency);
                    ((Player)target).sendMessage(this.plugin.getLanguageManager().getMessage("eco-give-received", receivedPlaceholders));
                }
                catch (NumberFormatException e) {
                    HashMap<String, String> errorPlaceholders = new HashMap<String, String>();
                    errorPlaceholders.put("amount", args[2]);
                    sender.sendMessage(this.plugin.getLanguageManager().getMessage("error-invalid-amount", errorPlaceholders));
                }
                break;
            }
            case "take": {
                if (args.length < 3) {
                    sender.sendMessage(this.plugin.getLanguageManager().getMessage("eco-take-usage"));
                    return true;
                }
                try {
                    double amount = Double.parseDouble(args[2]);
                    if (amount <= 0.0) {
                        sender.sendMessage(this.plugin.getLanguageManager().getMessage("error-amount-negative"));
                        return true;
                    }
                    if (this.economyManager.removeBalance(uuid, amount)) {
                        UUID adminId;
                        this.plugin.getStatsManager().recordTransaction(uuid, amount, "spent");
                        UUID uUID = adminId = sender instanceof Player ? ((Player)sender).getUniqueId() : null;
                        if (adminId != null) {
                            this.plugin.getAuditLogger().logAdminAction("TAKE", adminId, uuid, amount, "Money taken from " + target.getName());
                        }
                        HashMap<String, String> takePlaceholders = new HashMap<String, String>();
                        takePlaceholders.put("amount", String.format("%.2f", amount));
                        takePlaceholders.put("coins", currency);
                        takePlaceholders.put("player", target.getName());
                        sender.sendMessage(this.plugin.getLanguageManager().getMessage("eco-take-success", takePlaceholders));
                        if (!target.isOnline()) break;
                        HashMap<String, String> takenPlaceholders = new HashMap<String, String>();
                        takenPlaceholders.put("amount", String.format("%.2f", amount));
                        takenPlaceholders.put("coins", currency);
                        ((Player)target).sendMessage(this.plugin.getLanguageManager().getMessage("eco-take-taken", takenPlaceholders));
                        break;
                    }
                    HashMap<String, String> insufficientPlaceholders = new HashMap<String, String>();
                    insufficientPlaceholders.put("balance", String.format("%.2f", this.economyManager.getBalance(uuid)));
                    insufficientPlaceholders.put("coins", currency);
                    sender.sendMessage(this.plugin.getLanguageManager().getMessage("eco-take-insufficient", insufficientPlaceholders));
                }
                catch (NumberFormatException e) {
                    HashMap<String, String> errorPlaceholders = new HashMap<String, String>();
                    errorPlaceholders.put("amount", args[2]);
                    sender.sendMessage(this.plugin.getLanguageManager().getMessage("error-invalid-amount", errorPlaceholders));
                }
                break;
            }
            case "set": {
                if (args.length < 3) {
                    sender.sendMessage(this.plugin.getLanguageManager().getMessage("eco-set-usage"));
                    return true;
                }
                try {
                    UUID adminId;
                    double amount = Double.parseDouble(args[2]);
                    if (amount < 0.0) {
                        sender.sendMessage(this.plugin.getLanguageManager().getMessage("error-amount-negative-or-zero"));
                        return true;
                    }
                    this.economyManager.setBalance(uuid, amount);
                    UUID uUID = adminId = sender instanceof Player ? ((Player)sender).getUniqueId() : null;
                    if (adminId != null) {
                        this.plugin.getAuditLogger().logAdminAction("SET", adminId, uuid, amount, "Balance set for " + target.getName());
                    }
                    HashMap<String, String> setPlaceholders = new HashMap<String, String>();
                    setPlaceholders.put("player", target.getName());
                    setPlaceholders.put("amount", String.format("%.2f", amount));
                    setPlaceholders.put("coins", currency);
                    sender.sendMessage(this.plugin.getLanguageManager().getMessage("eco-set-success", setPlaceholders));
                    if (!target.isOnline()) break;
                    HashMap<String, String> setReceivedPlaceholders = new HashMap<String, String>();
                    setReceivedPlaceholders.put("amount", String.format("%.2f", amount));
                    setReceivedPlaceholders.put("coins", currency);
                    ((Player)target).sendMessage(this.plugin.getLanguageManager().getMessage("eco-set-set", setReceivedPlaceholders));
                }
                catch (NumberFormatException e) {
                    HashMap<String, String> errorPlaceholders = new HashMap<String, String>();
                    errorPlaceholders.put("amount", args[2]);
                    sender.sendMessage(this.plugin.getLanguageManager().getMessage("error-invalid-amount", errorPlaceholders));
                }
                break;
            }
            case "reset": {
                double startingBalance = this.plugin.getConfigManager().getStartingBalance();
                this.economyManager.setBalance(uuid, startingBalance);
                HashMap<String, String> resetPlaceholders = new HashMap<String, String>();
                resetPlaceholders.put("player", target.getName());
                resetPlaceholders.put("amount", String.format("%.2f", startingBalance));
                resetPlaceholders.put("coins", currency);
                sender.sendMessage(this.plugin.getLanguageManager().getMessage("eco-reset-success", resetPlaceholders));
                if (!target.isOnline()) break;
                ((Player)target).sendMessage(this.plugin.getLanguageManager().getMessage("eco-reset-reset"));
                break;
            }
            default: {
                sender.sendMessage(this.plugin.getLanguageManager().getMessage("eco-unknown-action"));
            }
        }
        return true;
    }

    private boolean handleReloadCommand(CommandSender sender) {
        this.plugin.getConfigManager().reload();
        this.plugin.getLanguageManager().reload();
        this.plugin.getEconomyManager().reload();
        this.plugin.getGUIConfig().reload();
        if (this.plugin.getHologramManager() != null && this.plugin.getHologramManager().isDecentHologramsEnabled()) {
            this.plugin.getHologramManager().reload();
        }
        sender.sendMessage(this.plugin.getLanguageManager().getMessage("eco-reload-success"));
        return true;
    }

    private boolean handleClearCommand(CommandSender sender) {
        int count = this.economyManager.clearAllBalances();
        this.economyManager.invalidateCache();
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("count", String.valueOf(count));
        sender.sendMessage(this.plugin.getLanguageManager().getMessage("eco-clear-success", placeholders));
        return true;
    }

    private boolean handleMultiplyCommand(CommandSender sender, String[] args) {
        if (args.length < 2) {
            sender.sendMessage(this.plugin.getLanguageManager().getMessage("eco-multiply-usage"));
            return true;
        }
        try {
            double factor = Double.parseDouble(args[1]);
            if (factor <= 0.0) {
                sender.sendMessage(this.plugin.getLanguageManager().getMessage("error-amount-negative"));
                return true;
            }
            int count = this.economyManager.multiplyAllBalances(factor);
            this.economyManager.invalidateCache();
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("factor", String.format("%.2f", factor));
            placeholders.put("count", String.valueOf(count));
            sender.sendMessage(this.plugin.getLanguageManager().getMessage("eco-multiply-success", placeholders));
        }
        catch (NumberFormatException e) {
            HashMap<String, String> errorPlaceholders = new HashMap<String, String>();
            errorPlaceholders.put("amount", args[1]);
            sender.sendMessage(this.plugin.getLanguageManager().getMessage("error-invalid-amount", errorPlaceholders));
        }
        return true;
    }

    private boolean handlePayallCommand(CommandSender sender, String[] args) {
        if (args.length < 2) {
            sender.sendMessage(this.plugin.getLanguageManager().getMessage("eco-payall-usage"));
            return true;
        }
        try {
            double amount = Double.parseDouble(args[1]);
            if (amount <= 0.0) {
                sender.sendMessage(this.plugin.getLanguageManager().getMessage("error-amount-negative"));
                return true;
            }
            int count = 0;
            String currency = this.plugin.getConfigManager().getCurrencyPlural();
            for (Player p : Bukkit.getOnlinePlayers()) {
                this.economyManager.addBalance(p.getUniqueId(), amount);
                this.plugin.getStatsManager().recordTransaction(p.getUniqueId(), amount, "earned");
                HashMap<String, String> placeholders = new HashMap<String, String>();
                placeholders.put("amount", String.format("%.2f", amount));
                placeholders.put("coins", currency);
                p.sendMessage(this.plugin.getLanguageManager().getMessage("eco-payall-received", placeholders));
                ++count;
            }
            this.economyManager.invalidateCache();
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("amount", String.format("%.2f", amount));
            placeholders.put("coins", currency);
            placeholders.put("count", String.valueOf(count));
            sender.sendMessage(this.plugin.getLanguageManager().getMessage("eco-payall-success", placeholders));
        }
        catch (NumberFormatException e) {
            HashMap<String, String> errorPlaceholders = new HashMap<String, String>();
            errorPlaceholders.put("amount", args[1]);
            sender.sendMessage(this.plugin.getLanguageManager().getMessage("error-invalid-amount", errorPlaceholders));
        }
        return true;
    }

    private boolean handleMigrateCommand(CommandSender sender, String[] args) {
        if (args.length < 2) {
            HashMap<String, String> ph = new HashMap<String, String>();
            ph.put("sources", String.join((CharSequence)", ", MigrationManager.getSupportedSources()));
            sender.sendMessage(this.plugin.getLanguageManager().getMessage("migration-usage", ph));
            return true;
        }
        MigrationManager migrationManager = new MigrationManager(this.plugin);
        return migrationManager.migrate(sender, args[1]);
    }

    private boolean handleHologramCommand(CommandSender sender, String[] args) {
        String subAction;
        if (!sender.hasPermission("myeconomy.admin.hologram")) {
            sender.sendMessage(this.plugin.getLanguageManager().getMessage("error-no-permission"));
            return true;
        }
        HologramManager hologramManager = this.plugin.getHologramManager();
        if (hologramManager == null || !hologramManager.isDecentHologramsEnabled()) {
            sender.sendMessage(this.plugin.getLanguageManager().getMessage("hologram-not-available"));
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage(this.plugin.getLanguageManager().getMessage("hologram-usage"));
            return true;
        }
        switch (subAction = args[1].toLowerCase()) {
            case "create": {
                if (!(sender instanceof Player)) {
                    sender.sendMessage(this.plugin.getLanguageManager().getMessage("error-player-only"));
                    return true;
                }
                if (args.length < 3) {
                    sender.sendMessage(this.plugin.getLanguageManager().getMessage("hologram-create-usage"));
                    return true;
                }
                String createType = args[2].toLowerCase();
                if (!HologramManager.VALID_TYPES.contains(createType)) {
                    HashMap<String, String> errorPlaceholders = new HashMap<String, String>();
                    errorPlaceholders.put("types", String.join((CharSequence)", ", HologramManager.VALID_TYPES));
                    sender.sendMessage(this.plugin.getLanguageManager().getMessage("hologram-invalid-type", errorPlaceholders));
                    return true;
                }
                Player player = (Player)sender;
                Location location = player.getLocation();
                if (hologramManager.createHologram(createType, location)) {
                    HashMap<String, String> successPlaceholders = new HashMap<String, String>();
                    successPlaceholders.put("type", createType);
                    successPlaceholders.put("x", String.format("%.1f", location.getX()));
                    successPlaceholders.put("y", String.format("%.1f", location.getY()));
                    successPlaceholders.put("z", String.format("%.1f", location.getZ()));
                    sender.sendMessage(this.plugin.getLanguageManager().getMessage("hologram-created", successPlaceholders));
                    break;
                }
                sender.sendMessage(this.plugin.getLanguageManager().getMessage("hologram-create-failed"));
                break;
            }
            case "delete": {
                if (args.length < 3) {
                    sender.sendMessage(this.plugin.getLanguageManager().getMessage("hologram-delete-usage"));
                    return true;
                }
                String deleteType = args[2].toLowerCase();
                if (!HologramManager.VALID_TYPES.contains(deleteType)) {
                    HashMap<String, String> errorPlaceholders = new HashMap<String, String>();
                    errorPlaceholders.put("types", String.join((CharSequence)", ", HologramManager.VALID_TYPES));
                    sender.sendMessage(this.plugin.getLanguageManager().getMessage("hologram-invalid-type", errorPlaceholders));
                    return true;
                }
                if (!hologramManager.hologramExists(deleteType)) {
                    HashMap<String, String> notExistsPlaceholders = new HashMap<String, String>();
                    notExistsPlaceholders.put("type", deleteType);
                    sender.sendMessage(this.plugin.getLanguageManager().getMessage("hologram-not-exists", notExistsPlaceholders));
                    return true;
                }
                if (hologramManager.deleteHologram(deleteType)) {
                    HashMap<String, String> deletedPlaceholders = new HashMap<String, String>();
                    deletedPlaceholders.put("type", deleteType);
                    sender.sendMessage(this.plugin.getLanguageManager().getMessage("hologram-deleted", deletedPlaceholders));
                    break;
                }
                sender.sendMessage(this.plugin.getLanguageManager().getMessage("hologram-delete-failed"));
                break;
            }
            case "list": {
                Map<String, Location> locations = hologramManager.getHologramLocations();
                if (locations.isEmpty()) {
                    sender.sendMessage(this.plugin.getLanguageManager().getMessage("hologram-list-empty"));
                    break;
                }
                sender.sendMessage(this.plugin.getLanguageManager().getMessage("hologram-list-header"));
                for (Map.Entry<String, Location> entry : locations.entrySet()) {
                    Location loc = entry.getValue();
                    HashMap<String, String> listPlaceholders = new HashMap<String, String>();
                    listPlaceholders.put("type", entry.getKey());
                    listPlaceholders.put("world", loc.getWorld().getName());
                    listPlaceholders.put("x", String.format("%.1f", loc.getX()));
                    listPlaceholders.put("y", String.format("%.1f", loc.getY()));
                    listPlaceholders.put("z", String.format("%.1f", loc.getZ()));
                    sender.sendMessage(this.plugin.getLanguageManager().getMessage("hologram-list-entry", listPlaceholders));
                }
                break;
            }
            case "reload": {
                hologramManager.reload();
                sender.sendMessage(this.plugin.getLanguageManager().getMessage("hologram-reloaded"));
                break;
            }
            case "update": {
                hologramManager.updateAllHolograms();
                sender.sendMessage(this.plugin.getLanguageManager().getMessage("hologram-updated"));
                break;
            }
            default: {
                sender.sendMessage(this.plugin.getLanguageManager().getMessage("hologram-usage"));
            }
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions;
        block11: {
            block12: {
                block10: {
                    completions = new ArrayList<String>();
                    if (args.length != 1) break block10;
                    String input = args[0].toLowerCase();
                    for (String action : Arrays.asList("give", "take", "set", "reset", "clear", "empty", "multiply", "payall", "reload", "migrate", "hologram")) {
                        if (!action.startsWith(input)) continue;
                        completions.add(action);
                    }
                    break block11;
                }
                if (args.length != 2) break block12;
                String firstArg = args[0].toLowerCase();
                String input = args[1].toLowerCase();
                if (firstArg.equals("migrate")) {
                    for (String src : MigrationManager.getSupportedSources()) {
                        if (!src.startsWith(input)) continue;
                        completions.add(src);
                    }
                } else if (firstArg.equals("hologram")) {
                    for (String subAction : Arrays.asList("create", "delete", "list", "reload", "update")) {
                        if (!subAction.startsWith(input)) continue;
                        completions.add(subAction);
                    }
                } else {
                    for (Player player : this.plugin.getServer().getOnlinePlayers()) {
                        if (!player.getName().toLowerCase().startsWith(input)) continue;
                        completions.add(player.getName());
                    }
                }
                break block11;
            }
            if (args.length != 3) break block11;
            String firstArg = args[0].toLowerCase();
            String secondArg = args[1].toLowerCase();
            String input = args[2].toLowerCase();
            if (firstArg.equals("hologram") && (secondArg.equals("create") || secondArg.equals("delete"))) {
                for (String type : HologramManager.VALID_TYPES) {
                    if (!type.startsWith(input)) continue;
                    completions.add(type);
                }
            }
        }
        return completions;
    }
}

