/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.myEconomy.discord;

import fr.skynex.myEconomy.MyEconomy;
import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;

public class DiscordWebhook {
    private final MyEconomy plugin;
    private String webhookUrl;
    private boolean enabled;

    public DiscordWebhook(MyEconomy plugin) {
        this.plugin = plugin;
        this.loadConfig();
    }

    private void loadConfig() {
        FileConfiguration config = this.plugin.getConfig();
        this.webhookUrl = config.getString("discord.webhook-url", "");
        this.enabled = config.getBoolean("discord.enabled", false) && !this.webhookUrl.isEmpty();
    }

    public void sendMarketCrash(String itemName, double crashPercentage) {
        if (!this.enabled) {
            return;
        }
        Embed embed = new Embed();
        embed.setTitle("\ud83d\udca5 Stock Market Crash Detected!");
        embed.setDescription("**" + itemName + "** suffered a crash of **" + String.format("%.1f", crashPercentage) + "%**!");
        embed.setColor(new Color(255, 0, 0));
        embed.addField("Item", itemName, true);
        embed.addField("Drop", String.format("%.1f%%", crashPercentage), true);
        this.send(embed);
    }

    public void sendMarketManipulation(String playerName, String itemName, double ownership) {
        if (!this.enabled) {
            return;
        }
        Embed embed = new Embed();
        embed.setTitle("\u26a0\ufe0f Market Manipulation");
        embed.setDescription("**" + playerName + "** owns **" + String.format("%.1f", ownership) + "%** of the **" + itemName + "** market");
        embed.setColor(new Color(255, 165, 0));
        embed.addField("Player", playerName, true);
        embed.addField("Item", itemName, true);
        embed.addField("Ownership", String.format("%.1f%%", ownership), true);
        this.send(embed);
    }

    public void sendLargeTransaction(String from, String to, double amount) {
        if (!this.enabled) {
            return;
        }
        Embed embed = new Embed();
        embed.setTitle("\ud83d\udcb0 Large Transaction");
        embed.setDescription("**" + from + "** sent **" + String.format("%.2f", amount) + "** to **" + to + "**");
        embed.setColor(new Color(0, 255, 0));
        embed.addField("From", from, true);
        embed.addField("To", to, true);
        embed.addField("Amount", String.format("%.2f", amount), true);
        this.send(embed);
    }

    public void sendEconomicEvent(String eventName, String description) {
        if (!this.enabled) {
            return;
        }
        Embed embed = new Embed();
        embed.setTitle("\ud83c\udfb2 Economic Event");
        embed.setDescription("**" + eventName + "**\n" + description);
        embed.setColor(new Color(138, 43, 226));
        this.send(embed);
    }

    public void sendRankingReward(String playerName, int position, double reward, String type) {
        if (!this.enabled) {
            return;
        }
        Embed embed = new Embed();
        embed.setTitle("\ud83c\udfc6 Ranking Reward");
        embed.setDescription("**" + playerName + "** finished **#" + position + "** in the **" + type + "** ranking and received **" + String.format("%.2f", reward) + "**!");
        embed.setColor(new Color(255, 215, 0));
        embed.addField("Player", playerName, true);
        embed.addField("Position", "#" + position, true);
        embed.addField("Reward", String.format("%.2f", reward), true);
        this.send(embed);
    }

    private void send(Embed embed) {
        if (!this.enabled || this.webhookUrl.isEmpty()) {
            return;
        }
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                URL url = URI.create(this.webhookUrl).toURL();
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("POST");
                connection.setRequestProperty("Content-Type", "application/json");
                connection.setDoOutput(true);
                String json = embed.toJson();
                try (OutputStream os = connection.getOutputStream();){
                    byte[] input = json.getBytes(StandardCharsets.UTF_8);
                    os.write(input, 0, input.length);
                }
                int responseCode = connection.getResponseCode();
                if (responseCode != 200 && responseCode != 204) {
                    this.plugin.getLogger().warning("Discord webhook error: " + responseCode);
                }
            }
            catch (IOException e) {
                this.plugin.getLogger().warning("Error sending Discord webhook: " + e.getMessage());
            }
        });
    }

    public void reload() {
        this.loadConfig();
    }

    private static class Embed {
        private String title;
        private String description;
        private Color color;
        private List<Field> fields = new ArrayList<Field>();

        private Embed() {
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setColor(Color color) {
            this.color = color;
        }

        public void addField(String name, String value, boolean inline) {
            this.fields.add(new Field(name, value, inline));
        }

        public String toJson() {
            StringBuilder json = new StringBuilder();
            json.append("{\"embeds\":[{\"title\":\"").append(this.escape(this.title)).append("\"");
            if (this.description != null) {
                json.append(",\"description\":\"").append(this.escape(this.description)).append("\"");
            }
            if (this.color != null) {
                int rgb = this.color.getRGB() & 0xFFFFFF;
                json.append(",\"color\":").append(rgb);
            }
            if (!this.fields.isEmpty()) {
                json.append(",\"fields\":[");
                for (int i = 0; i < this.fields.size(); ++i) {
                    if (i > 0) {
                        json.append(",");
                    }
                    json.append(this.fields.get(i).toJson());
                }
                json.append("]");
            }
            json.append("}]}");
            return json.toString();
        }

        private String escape(String str) {
            return str.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "\\r");
        }
    }

    private static class Field {
        private String name;
        private String value;
        private boolean inline;

        public Field(String name, String value, boolean inline) {
            this.name = name;
            this.value = value;
            this.inline = inline;
        }

        public String toJson() {
            return "{\"name\":\"" + this.escape(this.name) + "\",\"value\":\"" + this.escape(this.value) + "\",\"inline\":" + this.inline + "}";
        }

        private String escape(String str) {
            return str.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "\\r");
        }
    }
}

