/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.myEconomy.gui;

import fr.skynex.myEconomy.MyEconomy;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class GUIAnimator {
    public static void animateInventoryOpen(Inventory inv, Player player, MyEconomy plugin) {
    }

    public static void animateItemUpdate(final Inventory inv, final int slot, final ItemStack newItem, MyEconomy plugin) {
        final ItemStack oldItem = inv.getItem(slot);
        new BukkitRunnable(){
            int count = 0;

            public void run() {
                if (this.count >= 3) {
                    inv.setItem(slot, newItem);
                    this.cancel();
                    return;
                }
                if (this.count % 2 == 0) {
                    inv.setItem(slot, GUIAnimator.createFlashItem());
                } else {
                    inv.setItem(slot, oldItem);
                }
                ++this.count;
            }
        }.runTaskTimer((Plugin)plugin, 0L, 3L);
    }

    public static void createProgressBar(int current, int max, int length) {
        StringBuilder bar = new StringBuilder("\u00a77[");
        int filled = (int)((double)current / (double)max * (double)length);
        for (int i = 0; i < length; ++i) {
            if (i < filled) {
                bar.append("\u00a7a\u2588");
                continue;
            }
            bar.append("\u00a77\u2588");
        }
        bar.append("\u00a77]");
    }

    private static ItemStack createFlashItem() {
        ItemStack item = new ItemStack(Material.YELLOW_STAINED_GLASS_PANE);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.displayName((Component)LegacyComponentSerializer.legacySection().deserialize("\u00a7e*"));
        }
        item.setItemMeta(meta);
        return item;
    }

    public static String formatProgressBar(double current, double max, int length) {
        StringBuilder bar = new StringBuilder("\u00a77[");
        int filled = (int)(current / max * (double)length);
        filled = Math.max(0, Math.min(length, filled));
        for (int i = 0; i < length; ++i) {
            if (i < filled) {
                bar.append("\u00a7a\u2588");
                continue;
            }
            bar.append("\u00a77\u2588");
        }
        bar.append("\u00a77]");
        return bar.toString();
    }

    public static String formatAnimatedNumber(double number, String currency) {
        return String.format("\u00a7e%.2f \u00a77%s", number, currency);
    }
}

