/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.myEconomy.integration;

import fr.skynex.myEconomy.MyEconomy;
import fr.skynex.myEconomy.integration.DynamicPricingSystem;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class AuctionHouseIntegration
implements Listener {
    private final MyEconomy plugin;
    private boolean enabled;
    private Plugin auctionHousePlugin;
    private DynamicPricingSystem dynamicPricing;
    private final Map<UUID, Double> pendingTransactions;

    public AuctionHouseIntegration(MyEconomy plugin) {
        this.plugin = plugin;
        this.pendingTransactions = new HashMap<UUID, Double>();
        this.enabled = false;
        if (!plugin.getConfigManager().isAuctionHouseEnabled()) {
            plugin.getLogger().info("Auction House integration disabled in configuration.");
            return;
        }
        this.detectAuctionHouse();
        if (this.enabled) {
            plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
            if (plugin.getConfigManager().isAuctionHouseDynamicPricingEnabled()) {
                this.dynamicPricing = new DynamicPricingSystem(plugin);
                plugin.getLogger().info("Auction House dynamic pricing system enabled!");
            }
            plugin.getLogger().info("Auction House integration enabled!");
        } else {
            plugin.getLogger().info("No compatible auction plugin detected (MyAuction, AuctionGUIPlus, AuctionHouse, etc.). Integration will not be available.");
        }
    }

    private void detectAuctionHouse() {
        String[] possibleNames;
        for (String name : possibleNames = new String[]{"MyAuction", "AuctionGUIPlus", "AuctionHouse", "Auction-House", "zAuctionHouse", "auctionhouse", "AuctionHousePlus"}) {
            Plugin found = this.plugin.getServer().getPluginManager().getPlugin(name);
            if (found == null || !found.isEnabled()) continue;
            this.auctionHousePlugin = found;
            this.enabled = true;
            String version = found.getPluginMeta().getVersion();
            this.plugin.getLogger().info("Auction plugin detected: " + found.getName() + " v" + version);
            return;
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!this.enabled || !(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        String title = event.getView().title().toString();
        if (title.contains("Auction") || title.contains("Ench\u00e8re") || title.contains("Auction House") || title.contains("AuctionGUI") || title.contains("AH") || title.contains("Ench\u00e8res")) {
            this.scanAuctionHouseItems(event.getView().getTopInventory());
            this.handleAuctionTransaction(player, event);
        }
    }

    private void scanAuctionHouseItems(Inventory inventory) {
        if (this.dynamicPricing == null || !this.plugin.getConfigManager().isAuctionHouseDynamicPricingEnabled()) {
            return;
        }
        if (this.dynamicPricing != null) {
            this.dynamicPricing.resetCache();
        }
        for (int i = 0; i < inventory.getSize(); ++i) {
            ItemStack item = inventory.getItem(i);
            if (item == null || item.getType() == Material.AIR) continue;
            int stackCount = (int)Math.ceil((double)item.getAmount() / 64.0);
            if (stackCount == 0) {
                stackCount = 1;
            }
            this.dynamicPricing.registerItemForSale(item, stackCount);
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (!this.enabled || !(event.getPlayer() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getPlayer();
        UUID playerId = player.getUniqueId();
        String title = event.getView().title().toString();
        if (title.contains("Auction") || title.contains("Ench\u00e8re") || title.contains("Auction House") || title.contains("AuctionGUI") || title.contains("AH") || title.contains("Ench\u00e8res")) {
            this.scanAuctionHouseItems(event.getView().getTopInventory());
        }
        if (this.pendingTransactions.containsKey(playerId)) {
            double amount = this.pendingTransactions.remove(playerId);
            this.plugin.getStatsManager().recordTransaction(playerId, amount, "auction-house");
            if (amount >= this.plugin.getConfigManager().getPayConfirmationThreshold()) {
                this.plugin.getAuditLogger().logTransaction("AUCTION_HOUSE", playerId, null, amount, "Auction House transaction");
            }
        }
    }

    private void handleAuctionTransaction(Player player, InventoryClickEvent event) {
        ItemStack clickedItem;
        double previousBalance;
        double difference;
        double currentBalance = this.plugin.getEconomyManager().getBalance(player);
        UUID playerId = player.getUniqueId();
        if (this.pendingTransactions.containsKey(playerId) && Math.abs(difference = currentBalance - (previousBalance = this.pendingTransactions.get(playerId).doubleValue())) > 0.01 && (clickedItem = event.getCurrentItem()) != null && clickedItem.getType() != Material.AIR && this.plugin.getMarketIntelligence() != null && this.plugin.getConfigManager().isMarketLearningTrackAuctionHouse()) {
            int quantity = clickedItem.getAmount();
            String transactionType = difference > 0.0 ? "auction-sale" : "auction-purchase";
            this.plugin.getMarketIntelligence().recordTransaction(clickedItem.getType(), Math.abs(difference), quantity, transactionType);
        }
        this.pendingTransactions.put(playerId, currentBalance);
    }

    public void recordPurchase(Player buyer, Player seller, ItemStack item, double amount) {
        if (item != null && item.getType() != Material.AIR && this.plugin.getMarketIntelligence() != null && this.plugin.getConfigManager().isMarketLearningTrackAuctionHouse()) {
            this.plugin.getMarketIntelligence().recordTransaction(item.getType(), amount, item.getAmount(), "auction-purchase");
        }
        this.recordPurchase(buyer, seller, amount);
    }

    public void recordPurchase(Player buyer, Player seller, double amount) {
        if (!this.enabled || !this.plugin.getConfigManager().isAuctionHouseTrackTransactions()) {
            return;
        }
        double purchaseTax = 0.0;
        double saleTax = 0.0;
        double commission = 0.0;
        double netAmountForSeller = amount;
        if (this.plugin.getConfigManager().isAuctionHouseApplyTaxes()) {
            purchaseTax = amount * this.plugin.getConfigManager().getAuctionHousePurchaseTaxPercentage();
            if (purchaseTax > 0.0) {
                this.plugin.getEconomyManager().removeBalance(buyer.getUniqueId(), purchaseTax);
            }
            saleTax = amount * this.plugin.getConfigManager().getAuctionHouseSaleTaxPercentage();
            commission = amount * this.plugin.getConfigManager().getAuctionHouseCommissionPercentage();
            netAmountForSeller = amount - saleTax - commission;
            if (seller != null && (saleTax > 0.0 || commission > 0.0)) {
                double totalDeduction = saleTax + commission;
                this.plugin.getEconomyManager().removeBalance(seller.getUniqueId(), totalDeduction);
            }
        }
        this.plugin.getStatsManager().recordTransaction(buyer.getUniqueId(), amount + purchaseTax, "auction-purchase");
        if (seller != null) {
            this.plugin.getStatsManager().recordTransaction(seller.getUniqueId(), netAmountForSeller, "auction-sale");
        }
        if (this.plugin.getMarketIntelligence() == null || this.plugin.getConfigManager().isMarketLearningTrackAuctionHouse()) {
            // empty if block
        }
        if (this.plugin.getConfigManager().isAuctionHouseSendNotifications()) {
            this.plugin.getNotificationManager().sendTransactionSuccess(buyer, "AH Purchase", amount, seller != null ? seller.getName() : "Auction House");
            if (seller != null) {
                this.plugin.getNotificationManager().sendTransactionSuccess(seller, "AH Sale", netAmountForSeller, buyer.getName());
                if (saleTax > 0.0 || commission > 0.0) {
                    HashMap<String, String> taxPlaceholders = new HashMap<String, String>();
                    taxPlaceholders.put("tax", String.format("%.2f", saleTax));
                    taxPlaceholders.put("commission", String.format("%.2f", commission));
                    taxPlaceholders.put("net", String.format("%.2f", netAmountForSeller));
                    seller.sendMessage(this.plugin.getLanguageManager().getMessage("auction-sale-tax-info", taxPlaceholders));
                }
            }
        }
        if (this.plugin.getConfigManager().isAuctionHouseLogLargeTransactions() && amount >= this.plugin.getConfigManager().getPayConfirmationThreshold()) {
            Object details = "Auction House purchase";
            if (saleTax > 0.0 || commission > 0.0) {
                details = (String)details + String.format(" (Tax: %.2f, Commission: %.2f)", saleTax, commission);
            }
            this.plugin.getAuditLogger().logTransaction("AUCTION_HOUSE", buyer.getUniqueId(), seller != null ? seller.getUniqueId() : null, amount, (String)details);
        }
    }

    public void recordSale(Player seller, ItemStack item, double amount) {
        if (item != null && item.getType() != Material.AIR && this.plugin.getMarketIntelligence() != null && this.plugin.getConfigManager().isMarketLearningTrackAuctionHouse()) {
            this.plugin.getMarketIntelligence().recordTransaction(item.getType(), amount, item.getAmount(), "auction-sale");
        }
        this.recordSale(seller, amount);
    }

    public void recordSale(Player seller, double amount) {
        if (!this.enabled || !this.plugin.getConfigManager().isAuctionHouseTrackTransactions()) {
            return;
        }
        double saleTax = 0.0;
        double commission = 0.0;
        double netAmount = amount;
        if (this.plugin.getConfigManager().isAuctionHouseApplyTaxes()) {
            saleTax = amount * this.plugin.getConfigManager().getAuctionHouseSaleTaxPercentage();
            commission = amount * this.plugin.getConfigManager().getAuctionHouseCommissionPercentage();
            netAmount = amount - saleTax - commission;
            double totalDeduction = saleTax + commission;
            if (totalDeduction > 0.0) {
                this.plugin.getEconomyManager().removeBalance(seller.getUniqueId(), totalDeduction);
            }
        }
        this.plugin.getStatsManager().recordTransaction(seller.getUniqueId(), netAmount, "auction-sale");
        if (this.plugin.getConfigManager().isAuctionHouseSendNotifications()) {
            this.plugin.getNotificationManager().sendTransactionSuccess(seller, "AH Sale", netAmount, null);
            if (saleTax > 0.0 || commission > 0.0) {
                HashMap<String, String> taxPlaceholders = new HashMap<String, String>();
                taxPlaceholders.put("tax", String.format("%.2f", saleTax));
                taxPlaceholders.put("commission", String.format("%.2f", commission));
                taxPlaceholders.put("net", String.format("%.2f", netAmount));
                seller.sendMessage(this.plugin.getLanguageManager().getMessage("auction-sale-tax-info", taxPlaceholders));
            }
        }
        if (this.plugin.getConfigManager().isAuctionHouseLogLargeTransactions() && amount >= this.plugin.getConfigManager().getPayConfirmationThreshold()) {
            Object details = "Auction House sale";
            if (saleTax > 0.0 || commission > 0.0) {
                details = (String)details + String.format(" (Tax: %.2f, Commission: %.2f, Net: %.2f)", saleTax, commission, netAmount);
            }
            this.plugin.getAuditLogger().logTransaction("AUCTION_HOUSE", seller.getUniqueId(), null, amount, (String)details);
        }
    }

    public void recordPurchase(Player buyer, double amount) {
        if (!this.enabled || !this.plugin.getConfigManager().isAuctionHouseTrackTransactions()) {
            return;
        }
        double purchaseTax = 0.0;
        double totalAmount = amount;
        if (this.plugin.getConfigManager().isAuctionHouseApplyTaxes() && (purchaseTax = amount * this.plugin.getConfigManager().getAuctionHousePurchaseTaxPercentage()) > 0.0) {
            this.plugin.getEconomyManager().removeBalance(buyer.getUniqueId(), purchaseTax);
            totalAmount = amount + purchaseTax;
        }
        this.plugin.getStatsManager().recordTransaction(buyer.getUniqueId(), totalAmount, "auction-purchase");
        if (this.plugin.getConfigManager().isAuctionHouseSendNotifications()) {
            this.plugin.getNotificationManager().sendTransactionSuccess(buyer, "AH Purchase", amount, "Auction House");
            if (purchaseTax > 0.0) {
                HashMap<String, String> taxPlaceholders = new HashMap<String, String>();
                taxPlaceholders.put("tax", String.format("%.2f", purchaseTax));
                taxPlaceholders.put("total", String.format("%.2f", totalAmount));
                buyer.sendMessage(this.plugin.getLanguageManager().getMessage("auction-purchase-tax-info", taxPlaceholders));
            }
        }
        if (this.plugin.getConfigManager().isAuctionHouseLogLargeTransactions() && amount >= this.plugin.getConfigManager().getPayConfirmationThreshold()) {
            Object details = "Auction House purchase";
            if (purchaseTax > 0.0) {
                details = (String)details + String.format(" (Tax: %.2f)", purchaseTax);
            }
            this.plugin.getAuditLogger().logTransaction("AUCTION_HOUSE", buyer.getUniqueId(), null, amount, (String)details);
        }
    }

    public AuctionHouseStats getPlayerStats(UUID playerId) {
        return new AuctionHouseStats(0, 0, 0.0, 0.0);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Plugin getAuctionHousePlugin() {
        return this.auctionHousePlugin;
    }

    public DynamicPricingSystem getDynamicPricing() {
        return this.dynamicPricing;
    }

    public boolean validateSalePrice(Player player, ItemStack item, double proposedPrice, int stackCount) {
        if (this.dynamicPricing == null || !this.plugin.getConfigManager().isAuctionHouseDynamicPricingEnabled()) {
            return true;
        }
        DynamicPricingSystem.PriceValidationResult result = this.dynamicPricing.validatePrice(item, proposedPrice, stackCount);
        if (!result.isAcceptable()) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("suggested", String.format("%.2f", result.getSuggestedPrice()));
            placeholders.put("proposed", String.format("%.2f", proposedPrice));
            placeholders.put("supply", String.valueOf(this.dynamicPricing.getSupplyCount(item.getType())));
            placeholders.put("max", String.format("%.2f", result.getMaxPrice()));
            player.sendMessage(this.plugin.getLanguageManager().getMessage("auction-price-too-high", placeholders));
            if (this.plugin.getConfigManager().isAuctionHouseBlockOverpricedSales()) {
                return false;
            }
        } else if (Math.abs(proposedPrice - result.getSuggestedPrice()) > 0.01) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("suggested", String.format("%.2f", result.getSuggestedPrice()));
            placeholders.put("supply", String.valueOf(this.dynamicPricing.getSupplyCount(item.getType())));
            player.sendMessage(this.plugin.getLanguageManager().getMessage("auction-price-suggestion", placeholders));
        }
        return true;
    }

    public void registerItemForSale(ItemStack item, int stackCount) {
        if (this.dynamicPricing != null) {
            this.dynamicPricing.registerItemForSale(item, stackCount);
        }
    }

    public void removeItemFromSale(ItemStack item, int stackCount) {
        if (this.dynamicPricing != null) {
            this.dynamicPricing.removeItemFromSale(item, stackCount);
        }
    }

    public static class AuctionHouseStats {
        private final int purchases;
        private final int sales;
        private final double totalSpent;
        private final double totalEarned;

        public AuctionHouseStats(int purchases, int sales, double totalSpent, double totalEarned) {
            this.purchases = purchases;
            this.sales = sales;
            this.totalSpent = totalSpent;
            this.totalEarned = totalEarned;
        }

        public int getPurchases() {
            return this.purchases;
        }

        public int getSales() {
            return this.sales;
        }

        public double getTotalSpent() {
            return this.totalSpent;
        }

        public double getTotalEarned() {
            return this.totalEarned;
        }

        public double getNetProfit() {
            return this.totalEarned - this.totalSpent;
        }
    }
}

