/*
 * Decompiled with CFR 0.152.
 */
package fr.skynex.myEconomy.migration;

import fr.skynex.myEconomy.MyEconomy;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;

public class MigrationManager {
    private final MyEconomy plugin;

    public MigrationManager(MyEconomy plugin) {
        this.plugin = plugin;
    }

    public boolean migrate(CommandSender sender, String source) {
        String src;
        switch (src = source.toLowerCase()) {
            case "essentials": 
            case "essx": {
                return this.migrateFromEssentials(sender);
            }
            case "cmi": {
                return this.migrateFromCMI(sender);
            }
        }
        sender.sendMessage(this.plugin.getLanguageManager().getMessage("migration-unknown-source").replace("{source}", source));
        return false;
    }

    private boolean migrateFromEssentials(CommandSender sender) {
        File pluginsFolder = this.plugin.getServer().getWorldContainer();
        File essUserdata = new File(pluginsFolder, "plugins/Essentials/userdata");
        if (!essUserdata.exists()) {
            sender.sendMessage(this.plugin.getLanguageManager().getMessage("migration-source-not-found").replace("{path}", essUserdata.getAbsolutePath()));
            return false;
        }
        HashMap<UUID, Double> balances = new HashMap<UUID, Double>();
        File[] files = essUserdata.listFiles((dir, name) -> name.endsWith(".yml"));
        if (files == null || files.length == 0) {
            sender.sendMessage(this.plugin.getLanguageManager().getMessage("migration-no-data"));
            return false;
        }
        for (File file : files) {
            try {
                UUID uuid;
                YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
                double money = config.getDouble("money", 0.0);
                if (money <= 0.0) continue;
                String fileName = file.getName().replace(".yml", "");
                try {
                    uuid = UUID.fromString(fileName);
                }
                catch (IllegalArgumentException e) {
                    continue;
                }
                balances.put(uuid, money);
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.WARNING, "Error reading " + file.getName() + ": " + e.getMessage());
            }
        }
        return this.applyMigration(sender, balances, "Essentials");
    }

    private boolean migrateFromCMI(CommandSender sender) {
        File pluginsFolder = this.plugin.getServer().getWorldContainer();
        File cmiData = new File(pluginsFolder, "plugins/CMI/UserData");
        if (!cmiData.exists()) {
            cmiData = new File(pluginsFolder, "plugins/CMI/userdata");
        }
        if (!cmiData.exists()) {
            sender.sendMessage(this.plugin.getLanguageManager().getMessage("migration-source-not-found").replace("{path}", cmiData.getAbsolutePath()));
            return false;
        }
        HashMap<UUID, Double> balances = new HashMap<UUID, Double>();
        File[] files = cmiData.listFiles((dir, name) -> name.endsWith(".yml"));
        if (files == null || files.length == 0) {
            sender.sendMessage(this.plugin.getLanguageManager().getMessage("migration-no-data"));
            return false;
        }
        for (File file : files) {
            try {
                UUID uuid;
                YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
                double money = config.getDouble("Stats.Balance", config.getDouble("Balance", 0.0));
                if (money <= 0.0) continue;
                String fileName = file.getName().replace(".yml", "");
                try {
                    uuid = UUID.fromString(fileName);
                }
                catch (IllegalArgumentException e) {
                    continue;
                }
                balances.put(uuid, money);
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.WARNING, "Error reading " + file.getName() + ": " + e.getMessage());
            }
        }
        return this.applyMigration(sender, balances, "CMI");
    }

    private boolean applyMigration(CommandSender sender, Map<UUID, Double> balances, String sourceName) {
        int count = 0;
        for (Map.Entry<UUID, Double> entry : balances.entrySet()) {
            this.plugin.getEconomyManager().setBalance(entry.getKey(), (double)entry.getValue());
            ++count;
        }
        this.plugin.getEconomyManager().invalidateCache();
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("count", String.valueOf(count));
        placeholders.put("source", sourceName);
        sender.sendMessage(this.plugin.getLanguageManager().getMessage("migration-success", placeholders));
        return true;
    }

    public static String[] getSupportedSources() {
        return new String[]{"essentials", "essx", "cmi"};
    }
}

